/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.filechoser;

import com.appframework.components.customizedbutton.ToolBarButton;
import com.appframework.utils.OS;
import com.appframework.utils.UIUtils;
import com.appframework.utils.Utils;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.filechoser.ChangesListener;
import com.novell.gw.jclient.application.controls.filechoser.FileSelectedEvent;
import com.novell.gw.jclient.application.controls.filechoser.FileSelectedListener;
import com.novell.gw.jclient.application.controls.filechoser.GWFileChooser;
import com.novell.gw.jclient.application.controls.filechoser.GWMacFileChooser;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextField;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.toolbars.GWToolBar;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;

public class FileChooserPanel
extends OrientablePanel {
    private JLabel label;
    private JButton button;
    private JTextField textField;
    private String buttonText;
    private int verticalGap = 0;
    private ChangesListener changesListener;
    private FileFilter fileFilter;
    private FilenameFilter filenameFilter;
    private boolean isTextScalable;
    private EventListenerList fileSelectedEventListeners = new EventListenerList();

    public FileChooserPanel(String title, String value, int fileChooserState) {
        this(title, value, null, fileChooserState, 5, false);
    }

    public FileChooserPanel(String title, String value, int fileChooserState, boolean isScalable) {
        this(title, value, null, fileChooserState, 5, isScalable);
    }

    public FileChooserPanel(String title, String value, int fileChooserState, int vgap, boolean isScalable) {
        this(title, value, null, fileChooserState, vgap, isScalable);
    }

    public FileChooserPanel(String title, String value, String theButtonText, int fileChooserState, int vgap, boolean isScalable) {
        this.isTextScalable = isScalable;
        this.button = new ToolBarButton(new ChooseFileAction(fileChooserState));
        this.button.setMargin(new Insets(1, 0, 1, 0));
        this.buttonText = theButtonText;
        this.textField = new GWTextField(value);
        this.textField.setColumns(30);
        this.textField.setBorder(BorderFactory.createLoweredBevelBorder());
        this.textField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                FileChooserPanel.this.setValueChanged();
            }

            public void removeUpdate(DocumentEvent e) {
                FileChooserPanel.this.setValueChanged();
            }

            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.textField.setName("FileChooserPanel_textField");
        if (this.isTextScalable) {
            String alignment = "align=" + (this.getComponentOrientation().isLeftToRight() ? "left" : "right");
            this.label = new JMnemonicLabel("<html><p " + alignment + '>' + title + "</p></html>", this.textField);
            this.label.setComponentOrientation(this.getComponentOrientation());
        } else {
            this.label = new JMnemonicLabel(title, this.textField);
            this.label.setComponentOrientation(this.getComponentOrientation());
        }
        this.verticalGap = vgap < 0 ? 10 : vgap;
        this.buildUI();
        this.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
    }

    private void setValueChanged() {
        if (this.changesListener != null) {
            this.changesListener.setValueChanged();
        }
    }

    protected void buildUI() {
        this.createButton();
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 21;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.fill = 2;
        c.weightx = 1.0;
        this.add((Component)this.label, c);
        c.fill = 2;
        c.gridy = 1;
        c.gridwidth = 1;
        c.insets.top = this.verticalGap;
        c.weightx = 1.0;
        this.add((Component)this.textField, c);
        c.fill = 0;
        c.gridx = 1;
        c.insets.left = 2;
        c.weightx = 0.0;
        GWToolBar toolBar = new GWToolBar();
        toolBar.add(this.button);
        toolBar.setBorder(null);
        this.add((Component)toolBar, c);
    }

    private void createButton() {
        if (this.buttonText == null) {
            if (ImageResources.ICON_FOLDER == null) {
                this.button.setText("...");
            } else {
                this.button.setIcon(ImageResources.ICON_FOLDER);
                this.button.setBorder(null);
            }
        } else {
            this.button.setText(this.buttonText);
        }
        this.button.setPreferredSize(new Dimension(19, 19));
    }

    private void fireFileSelected(File selectedFile) {
        if (this.fileSelectedEventListeners.getListenerCount(FileSelectedListener.class) > 0) {
            FileSelectedListener[] listeners;
            FileSelectedEvent event = new FileSelectedEvent(this, selectedFile);
            for (FileSelectedListener listener : listeners = (FileSelectedListener[])this.fileSelectedEventListeners.getListeners(FileSelectedListener.class)) {
                listener.fileSelected(event);
            }
        }
    }

    public void addFileSelectedListener(FileSelectedListener listener) {
        this.fileSelectedEventListeners.add(FileSelectedListener.class, listener);
    }

    public void removeFileSelecedListener(FileSelectedListener listener) {
        this.fileSelectedEventListeners.remove(FileSelectedListener.class, listener);
    }

    public void setChangesListener(ChangesListener theChangesListener) {
        this.changesListener = theChangesListener;
    }

    public String getText() {
        String text = this.textField.getText();
        return (text = FileChooserPanel.getPath(text)) == null ? "" : text;
    }

    public static String getPath(String text) {
        String path = FileSystemView.getFileSystemView().getHomeDirectory().getPath();
        if (text.startsWith("~/")) {
            text = text.replaceFirst("~", path);
        } else if (text.startsWith("~")) {
            text = text.replaceFirst("~", path + "/");
        }
        return text;
    }

    public void setText(String theText) {
        this.textField.setText(theText);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.label.setEnabled(enabled);
        this.button.setEnabled(enabled);
        this.textField.setEnabled(enabled);
    }

    public void setFilter(String description, String[] extensions) {
        if (extensions == null) {
            return;
        }
        if (OS.isMacOS()) {
            OwnFilenameFilter filter = new OwnFilenameFilter(description);
            for (int i = 0; i < extensions.length; ++i) {
                filter.addExtension(extensions[i]);
            }
            this.filenameFilter = filter;
        } else {
            OwnFilter filter = new OwnFilter(description);
            for (int i = 0; i < extensions.length; ++i) {
                filter.addExtension(extensions[i]);
            }
            this.fileFilter = filter;
        }
    }

    public void setDisplayedMnemonic(int keyCode) {
        if (!OS.isMacOS()) {
            this.label.setDisplayedMnemonic(keyCode);
        }
    }

    public void setDisplayedMnemonic(char mnemonic) {
        if (!OS.isMacOS()) {
            this.label.setDisplayedMnemonic(mnemonic);
        }
    }

    public void setDisplayedMnemonicIndex(int index) {
        if (!OS.isMacOS()) {
            this.label.setDisplayedMnemonicIndex(index);
        }
    }

    private static class OwnFilenameFilter
    implements FilenameFilter {
        private String description;
        private List extensions = new ArrayList();

        public OwnFilenameFilter(String theDescription) {
            this.description = theDescription;
        }

        public boolean accept(File dir, String name) {
            String extention = Utils.getExtention(name);
            boolean bool = this.extensions.contains(extention);
            return bool;
        }

        public void addExtension(String ext) {
            this.extensions.add(ext);
        }

        public int getExtCount() {
            return this.extensions.size();
        }

        public String getDescription() {
            return this.description;
        }
    }

    private static class OwnFilter
    extends FileFilter {
        private String description;
        private List extensions = new ArrayList();

        public OwnFilter(String theDescription) {
            this.description = theDescription;
        }

        public boolean accept(File f) {
            return this.extensions.contains(Utils.getExtention(f.getName()));
        }

        public void addExtension(String ext) {
            this.extensions.add(ext);
        }

        public int getExtCount() {
            return this.extensions.size();
        }

        public String getDescription() {
            return this.description;
        }
    }

    private class ChooseFileAction
    extends AbstractAction {
        private int dialogMode;

        public ChooseFileAction(int theMode) {
            if (theMode != 0 && theMode != 1) {
                throw new NullPointerException();
            }
            this.dialogMode = theMode;
        }

        public void actionPerformed(ActionEvent e) {
            File directory = null;
            File file = new File(FileChooserPanel.this.textField.getText());
            directory = Utils.getExistingParentFile(file);
            String dialogCaption = "";
            File selectedFile = null;
            if (OS.isMacOS()) {
                if (this.dialogMode == 0) {
                    dialogCaption = StringResources.SELECT_FILE;
                } else if (this.dialogMode == 1) {
                    dialogCaption = StringResources.SELECT_DIRECTORY;
                    System.setProperty("apple.awt.fileDialogForDirectories", "true");
                }
                Frame frame = ControlsUtils.getFrameForComponent(FileChooserPanel.this);
                if (frame == null) {
                    return;
                }
                GWMacFileChooser fileChoser = new GWMacFileChooser(frame, dialogCaption, directory, 0);
                if (FileChooserPanel.this.filenameFilter != null) {
                    fileChoser.setFilenameFilter(FileChooserPanel.this.filenameFilter);
                }
                if (this.dialogMode == 0 && file.exists()) {
                    fileChoser.setSelectedFile(file);
                }
                UIUtils.centerWindow((Window)fileChoser, FileChooserPanel.this.button);
                fileChoser.setVisible(true);
                String selectedFilePath = fileChoser.getFile();
                String selecteddirectory = fileChoser.getDirectory();
                if (selectedFilePath != null) {
                    boolean isOK = false;
                    File f = new File(selecteddirectory + selectedFilePath);
                    if (this.dialogMode == 0) {
                        isOK = true;
                        selectedFile = f;
                    } else if (this.dialogMode == 1) {
                        isOK = f.isDirectory();
                    }
                    if (isOK) {
                        FileChooserPanel.this.textField.setText(selecteddirectory + selectedFilePath);
                        FileChooserPanel.this.setValueChanged();
                    }
                }
                if (this.dialogMode == 1) {
                    System.setProperty("apple.awt.fileDialogForDirectories", "false");
                }
            } else {
                if (this.dialogMode == 0) {
                    dialogCaption = StringResources.SELECT_FILE;
                } else if (this.dialogMode == 1) {
                    dialogCaption = StringResources.SELECT_DIRECTORY;
                }
                Window w = ControlsUtils.getWindowForComponent(FileChooserPanel.this);
                GWFileChooser fileChoser = w instanceof Frame ? new GWFileChooser((Frame)w, dialogCaption, directory, this.dialogMode, 0, false) : new GWFileChooser((Dialog)w, dialogCaption, directory, this.dialogMode, 0, false);
                if (FileChooserPanel.this.fileFilter != null) {
                    fileChoser.setFileFilter(FileChooserPanel.this.fileFilter);
                    fileChoser.setAcceptAllFileFilter(false);
                }
                if (this.dialogMode == 0 && file.exists()) {
                    fileChoser.setSelectedFile(file);
                }
                UIUtils.centerWindow((Window)fileChoser, FileChooserPanel.this.button);
                fileChoser.pack();
                fileChoser.setVisible(true);
                String[] selectedFileNames = fileChoser.getResult();
                if (selectedFileNames != null) {
                    boolean isOK = false;
                    File f = new File(selectedFileNames[0]);
                    if (this.dialogMode == 0) {
                        isOK = OS.isMacOS() ? true : f.isFile();
                        if (isOK) {
                            selectedFile = f;
                        }
                    } else if (this.dialogMode == 1) {
                        isOK = f.isDirectory();
                    }
                    if (isOK) {
                        FileChooserPanel.this.textField.setText(selectedFileNames[0]);
                    }
                }
            }
            if (selectedFile != null) {
                FileChooserPanel.this.fireFileSelected(selectedFile);
            }
        }
    }
}

