/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.filter;

import com.novell.gw.jclient.application.controls.filter.ContactFilter;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicCheckBox;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;

public class ContactFilterPanel
extends OrientablePanel {
    private ContactFilter filter;
    private JCheckBox cbContact;
    private JCheckBox cbGroup;
    private JCheckBox cbResource;
    private JCheckBox cbOrganization;

    public ContactFilterPanel(ContactFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException("filter is null");
        }
        this.buildUI();
        this.setFilter(filter);
    }

    private void buildUI() {
        this.cbContact = new JMnemonicCheckBox(StringResources.CONTACT);
        this.cbGroup = new JMnemonicCheckBox(StringResources.GROUP);
        this.cbResource = new JMnemonicCheckBox(StringResources.RESOURCE);
        this.cbOrganization = new JMnemonicCheckBox(StringResources.ORGANIZATION);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.anchor = 23;
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)this.cbContact, c);
        c.gridx = 1;
        this.add((Component)this.cbGroup, c);
        c.gridx = 0;
        c.gridy = 1;
        this.add((Component)this.cbResource, c);
        c.gridx = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.add((Component)this.cbOrganization, c);
    }

    public void setSystemAddressBook(boolean systemAddressBook) {
        this.filter.setSystemAddressBook(systemAddressBook);
    }

    private void setFilter(ContactFilter filter) {
        this.cbContact.setSelected(filter.isContact());
        this.cbGroup.setSelected(filter.isGroup());
        this.cbOrganization.setSelected(filter.isOrganization());
        this.cbResource.setSelected(filter.isResource());
        this.filter = filter;
    }

    public ContactFilter getFilter() {
        this.filter.setContact(this.cbContact.isSelected());
        this.filter.setGroup(this.cbGroup.isSelected());
        this.filter.setOrganization(this.cbOrganization.isSelected());
        this.filter.setResource(this.cbResource.isSelected());
        return this.filter;
    }

    private void handleReset() {
        this.cbContact.setSelected(true);
        this.cbGroup.setSelected(true);
        this.cbOrganization.setSelected(true);
        this.cbResource.setSelected(true);
    }

    public class ActionAdvanced
    extends AbstractAction {
        public ActionAdvanced() {
            super(StringResources.ADVANCED_FILTER);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
        }
    }

    public class ActionReset
    extends AbstractAction {
        public ActionReset() {
            super(StringResources.ACTION_RESET);
        }

        public void actionPerformed(ActionEvent e) {
            ContactFilterPanel.this.handleReset();
        }
    }
}

