/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.filter;

import com.appframework.mvc.MVCController;
import com.novell.gw.ab.AddressBookItemListFilter;
import com.novell.gw.engine.Filter;
import com.novell.gw.engine.ItemListFilter;
import com.novell.gw.jclient.api.interfaces.IDataStore;
import com.novell.gw.jclient.application.GWMainAppFrameActionList;
import com.novell.gw.jclient.application.controls.ColoredScrollPane;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.GWLabeledSeparator;
import com.novell.gw.jclient.application.controls.MinimumSizeKeepingPanel;
import com.novell.gw.jclient.application.controls.addressbook.ABUtils;
import com.novell.gw.jclient.application.controls.addressbook.AddressSelector;
import com.novell.gw.jclient.application.controls.filter.AbstractFilter;
import com.novell.gw.jclient.application.controls.filter.AdvancedFilter;
import com.novell.gw.jclient.application.controls.filter.ContactFilter;
import com.novell.gw.jclient.application.controls.filter.ContactFilterPanel;
import com.novell.gw.jclient.application.controls.filter.CustomFilter;
import com.novell.gw.jclient.application.controls.filter.DraftItemsFilter;
import com.novell.gw.jclient.application.controls.filter.EmptyFilter;
import com.novell.gw.jclient.application.controls.filter.PostedItemsFilter;
import com.novell.gw.jclient.application.controls.filter.ReceivedItemsFilter;
import com.novell.gw.jclient.application.controls.filter.SentItemsFilter;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DateChangeEvent;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.RecuringDateSelector;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextField;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientableCheckBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.dialogs.rules.AdvancedConditionsDialog;
import com.novell.gw.jclient.application.frames.options.compose.send.SelectCategoryControl;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.GWEngineUtils;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.categories.CategoryUtils;
import com.novell.gw.jclient.bl.om.items.MessageUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Calendar;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class FilterPanel
extends MinimumSizeKeepingPanel {
    private AddressSelector tfFrom;
    private AddressSelector tfToCC;
    private AddressSelector tfDisplayName;
    private JTextField tfEmailAddress = new GWTextField(20);
    private JTextField tfLastName = new GWTextField();
    private JTextField tfFirstName = new GWTextField();
    private JTextField tfOrganization = new GWTextField();
    private JTextField tfDepartment = new GWTextField();
    private JTextField tfSubject = new GWTextField(20);
    private JTextField tfMessage = new GWTextField();
    private OrientableCheckBox cbDateBetween;
    private SelectCategoryControl categoryChooser;
    private RecuringDateSelector dateFrom;
    private RecuringDateSelector dateTo;
    private JTextArea taAdvancedDescription;
    private AbstractFilter filter;
    private MODE mode;
    private JDialog parentDialog;
    private int height;
    private boolean isContact;
    private int boxTypeHide;
    ContactFilterPanel contactFilterPanel;
    private String userGuid;
    private MVCController parentController;

    public FilterPanel(JDialog parentDialog, MVCController parentController, com.novell.gw.jclient.bl.om.filter.Filter filter, boolean isContact) {
        this.height = new GWTextField().getPreferredSize().getSize().height;
        this.tfMessage.setName("Filterpanel_tfMessage");
        if (parentDialog == null) {
            throw new IllegalArgumentException("parentDialog is null");
        }
        if (parentController == null) {
            throw new IllegalArgumentException("parentDialog does not have controller");
        }
        this.boxTypeHide = filter != null ? filter.getBoxType() : 0;
        this.mode = MODE.NONE;
        this.parentController = parentController;
        this.parentDialog = parentDialog;
        this.userGuid = ControlsUtils.getUserGuid(parentController);
        this.isContact = isContact;
        if (isContact) {
            this.buildControlsForContactUI();
        } else {
            this.buildControlsUI();
        }
        Dimension size = this.getPreferredSize();
        this.setMinimalHeight(size.height);
        this.setMinimalWidth(size.width);
        this.setMaximumSize(size);
        this.setFilter(filter);
    }

    private MVCController getParentController() {
        return this.parentController;
    }

    private void buildControlsForContactUI() {
        ContactFilter contactFilter;
        this.removeAll();
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        if (this.filter instanceof ContactFilter) {
            contactFilter = (ContactFilter)this.filter;
        } else {
            boolean isSystemAB = false;
            if (this.getParentController() instanceof GWMainAppFrameActionList) {
                isSystemAB = ABUtils.isSystemABAbstractFolder((GWMainAppFrameActionList)this.getParentController());
            }
            contactFilter = new ContactFilter(new AddressBookItemListFilter(isSystemAB), isSystemAB);
        }
        this.contactFilterPanel = new ContactFilterPanel(contactFilter);
        this.add((Component)this.contactFilterPanel, c);
        this.tfDisplayName = new AddressSelector(null, this.getParentController()){

            public Dimension getMinimumSize() {
                return new Dimension(100, FilterPanel.this.height);
            }

            public Dimension getPreferredSize() {
                return new Dimension(100, FilterPanel.this.height);
            }
        };
        ++c.gridy;
        c.insets = new Insets(2, 1, 3, 1);
        c.weightx = 1.0;
        c.fill = 1;
        c.weighty = 0.0;
        this.add((Component)new JMnemonicLabel(StringResources.DISPLAY_NAME_C, this.tfDisplayName.getTextComponent()), c);
        ++c.gridy;
        this.add((Component)this.tfDisplayName, c);
        ++c.gridy;
        this.add((Component)new JMnemonicLabel(StringResources.EMAIL_ADDRESS_C, this.tfEmailAddress), c);
        ++c.gridy;
        this.add((Component)this.tfEmailAddress, c);
        ++c.gridy;
        this.add((Component)new JMnemonicLabel(StringResources.LAST_NAME, this.tfLastName), c);
        ++c.gridy;
        this.add((Component)this.tfLastName, c);
        ++c.gridy;
        this.add((Component)new JMnemonicLabel(StringResources.FIRST_NAME, this.tfFirstName), c);
        ++c.gridy;
        this.add((Component)this.tfFirstName, c);
        ++c.gridy;
        this.add((Component)new JMnemonicLabel(StringResources.ORGANIZATION_C, this.tfOrganization), c);
        ++c.gridy;
        this.add((Component)this.tfOrganization, c);
        ++c.gridy;
        this.add((Component)new JMnemonicLabel(StringResources.DEPARTMENT_C, this.tfDepartment), c);
        ++c.gridy;
        this.add((Component)this.tfDepartment, c);
        ++c.gridy;
        ++c.gridy;
        this.add((Component)this.tfDepartment, c);
        ++c.gridy;
        this.categoryChooser = new SelectCategoryControl(CategoryUtils.createNewCategoryList(this.userGuid), this.userGuid);
        this.add((Component)new JMnemonicLabel(StringResources.CATEGORIES_C, this.categoryChooser), c);
        ++c.gridy;
        this.add((Component)this.categoryChooser, c);
        ++c.gridy;
        c.weighty = 1.0;
        this.add((Component)new JPanel(), c);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.repaint();
        this.validate();
    }

    private void populateControlsForContactUI() {
        this.buildControlsForContactUI();
        if (this.filter instanceof ContactFilter) {
            ContactFilter contactFilter = (ContactFilter)this.filter;
            this.tfDisplayName.setText(contactFilter.getDisplayName());
            this.tfFirstName.setText(contactFilter.getFirstName());
            this.tfLastName.setText(contactFilter.getLastName());
            this.tfEmailAddress.setText(contactFilter.getEmailAddress());
            this.tfOrganization.setText(contactFilter.getOrganization());
            this.tfDepartment.setText(contactFilter.getDepartment());
            if (contactFilter.getCategories() != null) {
                this.categoryChooser.setCategories(contactFilter.getCategories());
            } else {
                this.categoryChooser.setCategories(CategoryUtils.createNewCategoryList(this.userGuid));
            }
        }
    }

    private void buildControlsUI() {
        this.removeAll();
        this.setLayout(new GridBagLayout());
        this.tfFrom = new AddressSelector(null, this.getParentController()){

            public Dimension getMinimumSize() {
                return new Dimension(100, FilterPanel.this.height);
            }

            public Dimension getPreferredSize() {
                return new Dimension(100, FilterPanel.this.height);
            }
        };
        JMnemonicLabel lbFrom = new JMnemonicLabel(StringResources.FROM_C, this.tfFrom.getTextComponent());
        this.tfToCC = new AddressSelector(null, this.getParentController()){

            public Dimension getMinimumSize() {
                return new Dimension(100, FilterPanel.this.height);
            }

            public Dimension getPreferredSize() {
                return new Dimension(100, FilterPanel.this.height);
            }
        };
        JMnemonicLabel lbToCC = new JMnemonicLabel(StringResources.TO_CC, this.tfToCC.getTextComponent());
        JMnemonicLabel lbSubject = new JMnemonicLabel(StringResources.SUBJECT_C, this.tfSubject);
        JMnemonicLabel lbMessage = new JMnemonicLabel(StringResources.MESSAGE_C, this.tfMessage);
        this.categoryChooser = new SelectCategoryControl(CategoryUtils.createNewCategoryList(this.userGuid), this.userGuid);
        JMnemonicLabel lbCategory = new JMnemonicLabel(StringResources.CATEGORY, this.categoryChooser);
        this.cbDateBetween = new OrientableCheckBox(new ActionDateBetween());
        GWLabeledSeparator lbDateRange = new GWLabeledSeparator(StringResources.DATE_RANGE);
        this.dateFrom = new RecuringDateSelectorForFilter(false);
        this.dateFrom.setDate(Calendar.getInstance());
        this.dateFrom.setEnabled(false);
        this.dateTo = new RecuringDateSelectorForFilter(false);
        this.dateTo.setDate(Calendar.getInstance());
        this.dateTo.setEnabled(false);
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 1, 3, 1);
        c.weightx = 1.0;
        c.fill = 1;
        c.anchor = 19;
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)lbFrom, c);
        ++c.gridy;
        this.add((Component)this.tfFrom, c);
        ++c.gridy;
        this.add((Component)lbToCC, c);
        ++c.gridy;
        this.add((Component)this.tfToCC, c);
        ++c.gridy;
        this.add((Component)lbSubject, c);
        ++c.gridy;
        this.add((Component)this.tfSubject, c);
        ++c.gridy;
        this.add((Component)lbMessage, c);
        ++c.gridy;
        this.add((Component)this.tfMessage, c);
        ++c.gridy;
        this.add((Component)lbCategory, c);
        ++c.gridy;
        c.fill = 2;
        c.weighty = 0.0;
        this.add((Component)this.categoryChooser, c);
        ++c.gridy;
        c.weighty = 0.0;
        c.fill = 1;
        this.add((Component)lbDateRange, c);
        ++c.gridy;
        this.add((Component)this.cbDateBetween, c);
        ++c.gridy;
        this.add((Component)this.cbDateBetween, c);
        OrientablePanel pnl = new OrientablePanel(new GridBagLayout());
        ++c.gridy;
        c.fill = 0;
        c.anchor = 23;
        this.add((Component)pnl, c);
        GridBagConstraints cc = (GridBagConstraints)c.clone();
        c = new GridBagConstraints();
        c.anchor = 21;
        c.weightx = 0.0;
        c.fill = 0;
        c.gridy = 0;
        pnl.add((Component)this.dateFrom, c);
        c.gridx = 1;
        pnl.add((Component)new OrientableLabel(' ' + StringResources.AND + ' '), c);
        c.gridx = 2;
        pnl.add((Component)this.dateTo, c);
        ++cc.gridy;
        cc.fill = 1;
        cc.weighty = 1.0;
        this.add((Component)new OrientablePanel(), cc);
        this.setBorder(BorderFactory.createEmptyBorder());
    }

    private void populateControlsUI() {
        if (this.filter instanceof CustomFilter) {
            CustomFilter customFilter = (CustomFilter)this.filter;
            this.tfFrom.setText(customFilter.getFrom());
            this.tfToCC.setText(customFilter.getToCC());
            this.tfSubject.setText(customFilter.getSubject());
            this.tfMessage.setText(customFilter.getMessage());
            if (customFilter.getCategories() != null) {
                this.categoryChooser.setCategories(customFilter.getCategories());
            } else {
                this.categoryChooser.setCategories(CategoryUtils.createNewCategoryList(this.userGuid));
            }
            Calendar dateFrom = customFilter.getdateFrom();
            Calendar dateTo = customFilter.getdateTo();
            if (dateFrom != null && dateTo != null) {
                this.dateFrom.setDate(dateFrom);
                this.dateTo.setDate(dateTo);
                this.cbDateBetween.setSelected(true);
                this.dateFrom.setEnabled(true);
                this.dateTo.setEnabled(true);
            } else {
                this.cbDateBetween.setSelected(false);
                this.dateFrom.setEnabled(false);
                this.dateTo.setEnabled(false);
            }
            this.selectFirstFilledComponent();
        } else if (this.filter == null || "".equals(this.filter.generateDescription())) {
            this.tfFrom.setText("");
            this.tfToCC.setText("");
            this.tfSubject.setText("");
            this.tfMessage.setText("");
            this.categoryChooser.setCategories(CategoryUtils.createNewCategoryList(this.userGuid));
        } else {
            throw new IllegalArgumentException("unexpected filter class: " + this.filter.getClass().getName());
        }
    }

    private void buildDescriptionUI() {
        this.removeAll();
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.taAdvancedDescription = new JTextArea();
        this.taAdvancedDescription.setLineWrap(true);
        this.taAdvancedDescription.setEditable(false);
        this.taAdvancedDescription.setBackground(this.getBackground());
        ColoredScrollPane scrollPane = new ColoredScrollPane(this.taAdvancedDescription, 20, 31);
        this.add((Component)scrollPane, c);
        this.setBorder(BorderFactory.createBevelBorder(1));
    }

    private void populateDescriptionUI() {
        String userGuid = ControlsUtils.getUserGuid(this.getParentController());
        IDataStore dataStore = GWCommandManager.getInstance(userGuid).getCurrentDataStore();
        Filter nf = new Filter(dataStore.getNativeDataStore(), this.filter == null ? null : this.filter.getItemListFilter(), false);
        String description = nf.generateDescription();
        this.taAdvancedDescription.setText(description);
    }

    protected void setFilter(com.novell.gw.jclient.bl.om.filter.Filter filter) {
        this.filter = (AbstractFilter)filter;
        this.handleFilterChanged();
    }

    private void handleFilterChanged() {
        MODE newMode = this.filter == null ? (this.isContact ? MODE.CONTACT : MODE.CONTROLS) : MODE.getMode(this.filter);
        if (this.mode != newMode) {
            if (newMode == MODE.CONTROLS) {
                this.buildControlsUI();
            } else if (newMode == MODE.CONTACT) {
                this.buildControlsForContactUI();
            } else if (newMode == MODE.DESCRIPTION) {
                this.buildDescriptionUI();
            } else {
                throw new IllegalStateException("unexpected mode: " + (Object)((Object)this.mode));
            }
            this.mode = newMode;
        }
        if (this.mode == MODE.CONTROLS) {
            this.populateControlsUI();
        } else if (this.mode == MODE.CONTACT) {
            this.populateControlsForContactUI();
        } else if (this.mode == MODE.DESCRIPTION) {
            this.populateDescriptionUI();
        } else {
            throw new IllegalStateException("unexpected mode: " + (Object)((Object)this.mode));
        }
    }

    private CustomFilter getCustomFilter() {
        if (this.cbDateBetween.isSelected()) {
            return new CustomFilter(this.tfFrom.getText(), this.tfToCC.getText(), this.tfSubject.getText(), this.tfMessage.getText(), this.categoryChooser.getCategories(), this.dateFrom.getDate(), this.dateTo.getDate());
        }
        return new CustomFilter(this.tfFrom.getText(), this.tfToCC.getText(), this.tfSubject.getText(), this.tfMessage.getText(), this.categoryChooser.getCategories());
    }

    private ContactFilter getContactFilter() {
        ContactFilter contactFilter = this.contactFilterPanel.getFilter();
        contactFilter.setDisplayName(this.tfDisplayName.getText());
        contactFilter.setFirstName(this.tfFirstName.getText());
        contactFilter.setLastName(this.tfLastName.getText());
        contactFilter.setEmailAddress(this.tfEmailAddress.getText());
        contactFilter.setOrganization(this.tfOrganization.getText());
        contactFilter.setDepartment(this.tfDepartment.getText());
        contactFilter.setCategories(this.categoryChooser.getCategories());
        return contactFilter;
    }

    public com.novell.gw.jclient.bl.om.filter.Filter getFilter() {
        CustomFilter customFilter;
        MessageUtils.showBusyCursor(true);
        AbstractFilter filter = this.isCustomOrEmptyFilter() && !this.isContact ? ((customFilter = this.getCustomFilter()) == null || customFilter.isEmpty() ? new EmptyFilter() : customFilter) : (this.isContact && MODE.DESCRIPTION != this.mode ? this.getContactFilter() : this.filter);
        if (this.boxTypeHide != 0) {
            if (filter instanceof EmptyFilter) {
                if (this.boxTypeHide == 2) {
                    filter = new SentItemsFilter();
                } else if (this.boxTypeHide == 1) {
                    filter = new ReceivedItemsFilter();
                } else if (this.boxTypeHide == 4) {
                    filter = new PostedItemsFilter();
                } else if (this.boxTypeHide == 8) {
                    filter = new DraftItemsFilter();
                }
            } else {
                filter.setBoxType(this.boxTypeHide);
            }
        }
        MessageUtils.showBusyCursor(false);
        return filter;
    }

    private void selectFirstFilledComponent() {
        if (!"".equals(this.tfFrom.getText())) {
            this.tfFrom.selectAll();
            this.tfFrom.requestFocus();
            return;
        }
        if (!"".equals(this.tfToCC.getText())) {
            this.tfToCC.selectAll();
            this.tfToCC.requestFocus();
            return;
        }
        if (!"".equals(this.tfSubject.getText())) {
            this.tfSubject.selectAll();
            this.tfSubject.requestFocus();
            return;
        }
        if (!"".equals(this.tfMessage.getText())) {
            this.tfMessage.selectAll();
            this.tfMessage.requestFocus();
        }
    }

    protected boolean isCustomOrEmptyFilter() {
        return this.filter == null || "".equals(this.filter.generateDescription()) || this.filter instanceof CustomFilter;
    }

    private class RecuringDateSelectorForFilter
    extends RecuringDateSelector {
        private Dimension preferredSize;

        public RecuringDateSelectorForFilter(boolean hasRecurringLabel) {
            super(hasRecurringLabel);
            RecuringDateSelector date = new RecuringDateSelector(false);
            date.setDate(Calendar.getInstance());
            this.preferredSize = new Dimension(date.getPreferredSize().getSize().width + 10, FilterPanel.this.height);
        }

        public Dimension getMinimumSize() {
            return this.preferredSize;
        }

        public Dimension getPreferredSize() {
            return this.preferredSize;
        }

        public void valueChanged(DateChangeEvent e) {
            super.valueChanged(e);
            Calendar dateTo = FilterPanel.this.dateTo.getDate();
            Calendar dateFrom = FilterPanel.this.dateFrom.getDate();
            if (dateFrom != null && dateTo != null) {
                dateFrom.set(9, 0);
                dateFrom.set(10, 0);
                dateFrom.set(12, 0);
                dateFrom.set(13, 0);
                dateFrom.set(14, 0);
                dateTo.set(9, 1);
                dateTo.set(10, 11);
                dateTo.set(12, 59);
                dateTo.set(13, 59);
                dateTo.set(14, 999);
                if (dateFrom.compareTo(dateTo) > 0) {
                    FilterPanel.this.dateTo.setDate(FilterPanel.this.dateFrom.getDate());
                } else if (dateTo.compareTo(dateFrom) < 0) {
                    FilterPanel.this.dateFrom.setDate(FilterPanel.this.dateTo.getDate());
                }
            }
        }
    }

    private class ActionDateBetween
    extends AbstractAction {
        public ActionDateBetween() {
            super(StringResources.CREATED_OR_DELIVERED_BETWEEN);
        }

        public void actionPerformed(ActionEvent e) {
            boolean isSelected = ((OrientableCheckBox)e.getSource()).isSelected();
            FilterPanel.this.dateFrom.setEnabled(isSelected);
            FilterPanel.this.dateTo.setEnabled(isSelected);
        }
    }

    public class ActionAdvanced
    extends AbstractAction {
        public ActionAdvanced() {
            super(StringResources.ADVANCED_FIND);
        }

        public void actionPerformed(ActionEvent e) {
            String userGuid = ControlsUtils.getUserGuid(FilterPanel.this.parentController);
            IDataStore dataStore = GWCommandManager.getInstance(userGuid).getCurrentDataStore();
            ItemListFilter itemlistFilter = FilterPanel.this.getFilter().getItemListFilter();
            Filter fn = new Filter(dataStore.getNativeDataStore(), itemlistFilter, false);
            AdvancedConditionsDialog dialog = new AdvancedConditionsDialog(FilterPanel.this.parentDialog, FilterPanel.this.getParentController(), fn, userGuid, false);
            dialog.pack();
            dialog.setLocationRelativeTo(null);
            dialog.setVisible(true);
            if (dialog.isOkActionProcessed()) {
                fn = dialog.getFilter();
                ItemListFilter filter = new ItemListFilter(fn);
                com.novell.gw.jclient.bl.om.filter.Filter f = FilterPanel.this.isContact && filter.canShowAsSimple(dataStore.getNativeDataStore()) ? new AdvancedFilter(filter) : GWEngineUtils.createFilter(filter, dataStore);
                FilterPanel.this.setFilter(f);
            }
            dialog.dispose();
        }
    }

    public class ActionReset
    extends AbstractAction {
        public ActionReset() {
            super(StringResources.ACTION_RESET);
        }

        public void actionPerformed(ActionEvent e) {
            if (FilterPanel.this.isContact) {
                boolean isSystemAB = false;
                if (FilterPanel.this.getParentController() instanceof GWMainAppFrameActionList) {
                    isSystemAB = ABUtils.isSystemABAbstractFolder((GWMainAppFrameActionList)FilterPanel.this.getParentController());
                }
                FilterPanel.this.setFilter(new ContactFilter(new AddressBookItemListFilter(isSystemAB), isSystemAB));
            } else {
                FilterPanel.this.setFilter(new CustomFilter());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum MODE {
        NONE,
        CONTROLS,
        DESCRIPTION,
        CONTACT;


        static MODE getMode(com.novell.gw.jclient.bl.om.filter.Filter filter) {
            if (filter instanceof ContactFilter) {
                return CONTACT;
            }
            if (filter == null) {
                return NONE;
            }
            return filter instanceof CustomFilter || "".equals(filter.getItemListFilter().generateDescription()) ? CONTROLS : DESCRIPTION;
        }
    }
}

