/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.filter;

import com.appframework.ActionList;
import com.appframework.ApplicationFrameActionList;
import com.appframework.filter.FiltersFactory;
import com.appframework.mvc.MVCController;
import com.appframework.resources.ImageResources;
import com.appframework.utils.UIUtils;
import com.novell.gw.engine.ItemListFilter;
import com.novell.gw.jclient.api.interfaces.IDataStore;
import com.novell.gw.jclient.application.GWMainAppFrame;
import com.novell.gw.jclient.application.GWMainAppFrameActionList;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.controls.filter.AdvancedFilter;
import com.novell.gw.jclient.application.controls.menus.AbstractActionsPopupMenu;
import com.novell.gw.jclient.application.controls.menus.FilterGWItemsPopupMenu;
import com.novell.gw.jclient.application.controls.menus.FilterSelectAction;
import com.novell.gw.jclient.application.controls.menus.GWMenu;
import com.novell.gw.jclient.application.controls.panelviews.PanelView;
import com.novell.gw.jclient.application.controls.skinnable.ComponentProperty;
import com.novell.gw.jclient.application.controls.skinnable.SkinProperty;
import com.novell.gw.jclient.application.controls.skinnable.SkinnableLabel;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.categories.CategoryUtils;
import com.novell.gw.jclient.bl.om.filter.Filter;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.folders.ContactsFolder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

class HeaderFindLabel
extends SkinnableLabel {
    private boolean mouseOn = false;
    private ImageIcon downArrow = ImageResources.ARROW_DOWN;
    private static final Insets WIDER_INSETS = new Insets(4, 3, 4, 3);
    private static final int ARROW_DISTANCE = 3;
    private AbstractFolder folder = null;

    public HeaderFindLabel(ApplicationFrameActionList actionList) {
        this.skinnableDelegate.clearPropertyBindings();
        this.skinnableDelegate.putSkinProperty(SkinProperty.HIGHLIGHTED_TEXT_COLOR, ComponentProperty.CUSTOM);
        this.skinnableDelegate.putSkinProperty(SkinProperty.HEADER_TEXT_COLOR, ComponentProperty.CUSTOM);
        this.skinnableDelegate.putSkinProperty(SkinProperty.HEADER_FONT_SIZE, ComponentProperty.FONT_SIZE);
        if (this.getComponentOrientation().isLeftToRight()) {
            this.setText(' ' + StringResources.FIND_C);
        } else {
            this.setText(StringResources.FIND_C + ' ');
        }
        this.addMouseListener(new HeaderLabelFindMouseListener(this, actionList));
    }

    public void paint(Graphics g) {
        if (this.mouseOn) {
            super.setForeground((Color)this.getClientProperty((Object)SkinProperty.HIGHLIGHTED_TEXT_COLOR));
            UIUtils.paintGradient(g, this);
        } else {
            super.setForeground((Color)this.getClientProperty((Object)SkinProperty.HEADER_TEXT_COLOR));
        }
        super.paint(g);
        Font f = this.getFont();
        Rectangle stringBounds = g.getFontMetrics(f).getStringBounds(this.getText(), g).getBounds();
        int x = UIUtils.getComponentOrientation().isLeftToRight() ? stringBounds.width + HeaderFindLabel.WIDER_INSETS.left : this.getSize().width - stringBounds.width - HeaderFindLabel.WIDER_INSETS.left - this.downArrow.getIconWidth();
        g.drawImage(this.downArrow.getImage(), x, (this.getSize().height - this.downArrow.getIconHeight()) / 2, this);
    }

    private Dimension calcSize() {
        Font f = this.getFont();
        FontMetrics fm = this.getFontMetrics(f);
        Rectangle stringBounds = new Rectangle(0, 0, fm.stringWidth(this.getText()), fm.getHeight());
        Insets i = WIDER_INSETS;
        int w = (this.getIcon() == null ? 0 : this.getIcon().getIconWidth() + this.getIconTextGap()) + stringBounds.width;
        w += i.left;
        w += 6 + this.downArrow.getIconWidth();
        int h = stringBounds.height + i.top + i.bottom;
        return new Dimension(w += i.right, h);
    }

    public Dimension getPreferredSize() {
        return this.calcSize();
    }

    public Dimension getMinimumSize() {
        return this.calcSize();
    }

    void setFolder(AbstractFolder folder) {
        this.folder = folder;
    }

    private class ContactsPopupMenu
    extends AbstractActionsPopupMenu {
        ButtonGroup buttonGroup;
        private JMenuItem miClear;
        private JMenuItem miCreateContactFilter;

        public ContactsPopupMenu(ActionList theActionList) {
            super(theActionList);
            this.buttonGroup = new ButtonGroup();
            this.build();
        }

        private void build() {
            this.miCreateContactFilter = this.getActionList().getAction(ActionKey.CREATE_GWITEM_FILTER).getMenuItem();
            this.add(this.miCreateContactFilter);
            this.miClear = this.getActionList().getAction(ActionKey.CLEAR_FILTER).getMenuItem();
            this.add(this.miClear);
            this.addSeparator();
            this.add(this.createCategoryMenuItem());
            this.addSeparator();
            this.add(this.getActionList().getAction(ActionKey.FILTER_FOR_GROUPS).getMenuItem());
            this.add(this.getActionList().getAction(ActionKey.FILTER_FOR_CONTACTS).getMenuItem());
            this.add(this.getActionList().getAction(ActionKey.FILTER_FOR_RESOURCES).getMenuItem());
            this.add(this.getActionList().getAction(ActionKey.FILTER_FOR_ORGANIZATIONS).getMenuItem());
            this.addSeparator();
            String userGuid = EngineCommandManager.getUserGuid();
            IDataStore ds = EngineCommandManager.getInstance(userGuid).getCurrentDataStore();
            int count = ds.getSavedFilterCount(2);
            boolean isMore = false;
            for (int i = 0; i < count; ++i) {
                ItemListFilter itemfilter = ds.getSavedFilter(2, i);
                if (itemfilter.getShowOnMenu()) {
                    AdvancedFilter f = new AdvancedFilter(itemfilter);
                    f.setContactType(true);
                    this.add(new FilterSelectAction((MVCController)this.actionList.getMVCView().getController(), f, itemfilter.getName()).getMenuItem());
                    continue;
                }
                isMore = true;
            }
            if (isMore) {
                this.add(this.actionList.getAction(ActionKey.MORE_FILTER).getMenuItem());
            }
        }

        public JMenu createCategoryMenuItem() {
            GWMenu menuCategories = new GWMenu(StringResources.CATEGORIES);
            Filter filter = FiltersFactory.getInstance().getFilter(this.actionList);
            menuCategories.add(this.actionList.getAction(ActionKey.ALL_CATEGORIES).getMenuItem());
            menuCategories.addSeparator();
            CategoryUtils.populateMenuWithCategories(menuCategories, filter, this.actionList);
            menuCategories.addSeparator();
            menuCategories.add(this.getActionList().getAction(ActionKey.MORE_CATEGORIES_FILTER).getMenuItem());
            return menuCategories;
        }

        public void show(Component invoker, int x, int y) {
            if (this.actionList instanceof GWMainAppFrameActionList && ((GWMainAppFrameActionList)this.actionList).getMVCView() != null && ((GWMainAppFrame)((GWMainAppFrameActionList)this.actionList).getMVCView()).getFolder() != null) {
                this.checkMenuOpenedInPanel(this.actionList);
                String title = this.isInPanel ? StringResources.formatString(StringResources.IN_SOME_PANEL_D, this.panelName) : StringResources.formatString(StringResources.IN_SOME_FOLDER_D, HeaderFindLabel.this.folder.getName());
                this.miCreateContactFilter.setText(title);
            }
            boolean isClear = FiltersFactory.getInstance().getFilter(this.actionList) != null;
            this.miClear.setVisible(isClear);
            this.remove(3);
            this.insert(this.createCategoryMenuItem(), 3);
            super.show(invoker, x, y);
        }
    }

    private class HeaderLabelFindMouseListener
    extends MouseAdapter {
        private ApplicationFrameActionList actionList;
        private JPopupMenu contactsPopupMenu;
        private JPopupMenu messagesPopupMenu;
        private JComponent component;

        public HeaderLabelFindMouseListener(JComponent theComponent, ApplicationFrameActionList actionList) {
            this.component = theComponent;
            this.actionList = actionList;
        }

        public void mouseEntered(MouseEvent e) {
            HeaderFindLabel.this.mouseOn = true;
            HeaderFindLabel.this.setBackground(Color.ORANGE);
            e.getComponent().setCursor(new Cursor(12));
            HeaderFindLabel.this.repaint();
        }

        public void mouseExited(MouseEvent e) {
            HeaderFindLabel.this.mouseOn = false;
            HeaderFindLabel.this.repaint();
            e.getComponent().setCursor(new Cursor(0));
        }

        public void mousePressed(MouseEvent e) {
            int x = this.component.getWidth() - HeaderFindLabel.this.downArrow.getIconWidth() / 2 - 6;
            this.getPopupMenu().show(this.component, x, this.component.getHeight() / 2 + HeaderFindLabel.this.downArrow.getIconHeight());
            e.getComponent().setCursor(new Cursor(0));
        }

        private JPopupMenu getPopupMenu() {
            if (this.getFolder() instanceof ContactsFolder) {
                if (this.contactsPopupMenu == null) {
                    this.contactsPopupMenu = new ContactsPopupMenu(this.actionList);
                }
                return this.contactsPopupMenu;
            }
            if (this.messagesPopupMenu == null) {
                this.messagesPopupMenu = new FilterGWItemsPopupMenu(this.actionList);
            }
            return this.messagesPopupMenu;
        }

        private AbstractFolder getFolder() {
            AbstractFolder folder = null;
            if (this.actionList instanceof GWMainAppFrameActionList) {
                PanelView selectedPanel;
                GWMainAppFrame frame = (GWMainAppFrame)((GWMainAppFrameActionList)this.actionList).getMVCView();
                if (frame.isMultiPanelView() && (selectedPanel = frame.getMultiPanelView().getSelectedPanel()) != null) {
                    folder = selectedPanel.getPanelFolder();
                }
                if (folder == null) {
                    folder = frame.getFolder();
                }
            }
            return folder;
        }
    }
}

