/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.filter;

import com.appframework.ApplicationFrame;
import com.novell.gw.engine.ItemListFilter;
import com.novell.gw.jclient.api.impl.APIWrapperManager;
import com.novell.gw.jclient.application.GWMainAppFrame;
import com.novell.gw.jclient.application.GWMainAppFrameActionList;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.GridBagAdapter;
import com.novell.gw.jclient.application.controls.basicdialogs.ApplicationDialog;
import com.novell.gw.jclient.application.controls.filter.AbstractViewFiltersDialog;
import com.novell.gw.jclient.application.controls.filter.AdvancedFilter;
import com.novell.gw.jclient.application.controls.filter.CustomFilter;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.dialogs.GWDialog;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.filter.Filter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;

public class OpenFilterDialog
extends AbstractViewFiltersDialog {
    private static Logger logger = Logger.getLogger(OpenFilterDialog.class);
    protected JButton btnDelete;
    private ArrayList<ItemListFilter> arrFilterDeleted;
    private Filter filter;

    public OpenFilterDialog() {
        this.init();
    }

    public OpenFilterDialog(ApplicationDialog dialog) {
        super(dialog);
        this.init();
    }

    public OpenFilterDialog(GWDialog theDialog) {
        super(theDialog);
        this.init();
    }

    public OpenFilterDialog(ApplicationFrame frame) {
        super(frame);
        this.init();
    }

    private void init() {
        this.arrFilterDeleted = new ArrayList();
        this.setTitle(StringResources.LIST_FILTERS);
        this.listFilters.addListSelectionListener(new FilterListSelectionListener());
        this.buildUI();
        if (this.listFilters.getModel().getSize() != 0) {
            this.listFilters.clearSelection();
            this.listFilters.setSelectedIndex(0);
        }
        this.cbPutOnMenu.addActionListener(new PutOnMenuActionListener());
    }

    protected void performOkAction() {
        int i;
        int size = this.arrFilterDeleted.size();
        if (size > 0) {
            for (i = 0; i < size; ++i) {
                this.arrFilterDeleted.get(i).delete(this.dataStore.getNativeDataStore());
            }
        }
        for (i = 0; i < this.arrShowOn.size(); ++i) {
            ItemListFilter itemfilter = (ItemListFilter)this.arrFilter.get(i);
            if (itemfilter.getShowOnMenu() == ((Boolean)this.arrShowOn.get(i)).booleanValue()) continue;
            itemfilter.save(itemfilter.getName(), ((Boolean)this.arrShowOn.get(i)).booleanValue(), this.dataStore.getNativeDataStore());
        }
        boolean isContact = false;
        if (this.parentController.getActionList() instanceof GWMainAppFrameActionList) {
            isContact = ((GWMainAppFrame)((GWMainAppFrameActionList)this.parentController.getActionList()).getMVCView()).getFolder().isContactsFolder();
        }
        if (this.listFilters.getModel().getSize() != 0) {
            int selIndex = this.listFilters.getSelectedIndex();
            ItemListFilter itemfilter = (ItemListFilter)this.arrFilter.get(selIndex);
            if (isContact) {
                this.filter = new AdvancedFilter(itemfilter);
                ((AdvancedFilter)this.filter).setContactType(true);
            } else if (itemfilter.canShowAsSimple(this.dataStore.getNativeDataStore())) {
                CustomFilter filter = new CustomFilter(itemfilter.getFromText(), itemfilter.getToCcText(), itemfilter.getSubjectText(), itemfilter.getMessage(), APIWrapperManager.getCategoryList(itemfilter.getCategories(this.dataStore.getNativeDataStore())));
                this.filter = filter;
            } else {
                AdvancedFilter advFilter = new AdvancedFilter(itemfilter);
                this.filter = advFilter;
            }
        } else {
            this.filter = null;
        }
    }

    public Filter getFilter() {
        return this.filter;
    }

    private void buildUI() {
        OrientablePanel pnlLeft = new OrientablePanel(new GridBagLayout());
        GridBagAdapter adapter = new GridBagAdapter(pnlLeft);
        adapter.setColumnCount(2);
        adapter.setResizableColumn(1);
        adapter.setInsets(new Insets(0, 5, 0, 5));
        adapter.setIpadx(140);
        adapter.addComponent(new OrientableLabel(StringResources.NAME_C));
        adapter.setInsets(new Insets(0, 5, 0, 5));
        adapter.addComponent(new OrientableLabel(StringResources.DESCRIPTION_C));
        adapter.setWidthY(100);
        adapter.addComponent(new OrientableScrollPane(this.listFilters));
        adapter.addComponent(new OrientableScrollPane(this.talistDescription));
        adapter.addComponent(this.cbPutOnMenu);
        adapter.endRow();
        this.panCenterPanel.add((Component)pnlLeft, "Center");
        this.panCenterPanel.add((Component)this.buildButtonsPane(), "After");
        this.panCenterPanel.setPreferredSize(new Dimension(500, 200));
    }

    private JPanel buildButtonsPane() {
        OrientablePanel pnlButtons = new OrientablePanel(new GridBagLayout());
        GridBagAdapter adapter = new GridBagAdapter(pnlButtons);
        adapter.setColumnCount(1);
        adapter.addComponent(this.btnOK);
        adapter.addComponent(this.btnCancel);
        this.btnDelete = new JMnemonicButton(new DeleteFilterAction());
        adapter.addComponent(this.btnDelete);
        OrientablePanel pnlContent = new OrientablePanel(new BorderLayout());
        pnlContent.add((Component)pnlButtons, "North");
        return pnlContent;
    }

    public JButton getBtnDelete() {
        return this.btnDelete;
    }

    private class PutOnMenuActionListener
    implements ActionListener {
        private PutOnMenuActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (OpenFilterDialog.this.listFilters.getModel().getSize() != 0 && OpenFilterDialog.this.listFilters.getSelectedValue() instanceof String) {
                int selIndex = OpenFilterDialog.this.listFilters.getSelectedIndex();
                OpenFilterDialog.this.arrShowOn.set(selIndex, OpenFilterDialog.this.cbPutOnMenu.isSelected());
            }
        }
    }

    private class FilterListSelectionListener
    implements ListSelectionListener {
        private FilterListSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (OpenFilterDialog.this.listFilters.getSelectedValue() instanceof CustomFilter) {
                if (!OpenFilterDialog.this.btnDelete.isEnabled()) {
                    OpenFilterDialog.this.btnDelete.setEnabled(true);
                }
                if (!OpenFilterDialog.this.cbPutOnMenu.isEnabled()) {
                    OpenFilterDialog.this.cbPutOnMenu.setEnabled(true);
                }
                OpenFilterDialog.this.cbPutOnMenu.setSelected(((CustomFilter)OpenFilterDialog.this.listFilters.getSelectedValue()).isPutOnMenu());
            }
            OpenFilterDialog.this.valueChanged(true);
        }
    }

    private class DeleteFilterAction
    extends AbstractAction {
        public DeleteFilterAction() {
            super(StringResources.ACTION_DELETE);
            if (OpenFilterDialog.this.listFilters.getModel().getSize() == 0) {
                this.setEnabled(false);
            }
        }

        public void actionPerformed(ActionEvent e) {
            if (OpenFilterDialog.this.listFilters.getModel().getSize() != 0 && OpenFilterDialog.this.listFilters.getModel().getSize() > OpenFilterDialog.this.listFilters.getSelectedIndex() && OpenFilterDialog.this.listFilters.getSelectedValue() instanceof String) {
                int selIndex = OpenFilterDialog.this.listFilters.getSelectedIndex();
                ItemListFilter itemfilter = (ItemListFilter)OpenFilterDialog.this.arrFilter.get(selIndex);
                OpenFilterDialog.this.arrFilterDeleted.add(itemfilter);
                OpenFilterDialog.this.arrFilter.remove(selIndex);
                OpenFilterDialog.this.arrShowOn.remove(selIndex);
            }
            OpenFilterDialog.this.updateFilterList();
            OpenFilterDialog.this.valueChanged(true);
            if (OpenFilterDialog.this.listFilters.getModel().getSize() == OpenFilterDialog.this.listFilters.getSelectedIndex()) {
                OpenFilterDialog.this.listFilters.setSelectedIndex(OpenFilterDialog.this.listFilters.getSelectedIndex() - 1);
            } else if (OpenFilterDialog.this.listFilters.getModel().getSize() < OpenFilterDialog.this.listFilters.getSelectedIndex()) {
                OpenFilterDialog.this.listFilters.setSelectedIndex(-1);
            }
        }
    }
}

