/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.filter;

import com.appframework.utils.Utils;
import com.novell.gw.ab.AddressBookItemListFilter;
import com.novell.gw.engine.ItemListFilter;
import com.novell.gw.jclient.application.controls.filter.AbstractFilter;

public class QuickFilter
extends AbstractFilter {
    private String text;
    private boolean isContact;
    private boolean isSystemContact = false;

    public QuickFilter(String aText, boolean isContact) {
        this.text = aText;
        this.isContact = isContact;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public boolean isContact() {
        return this.isContact;
    }

    public void setSystem(boolean isSystem) {
        this.isSystemContact = isSystem;
    }

    public ItemListFilter getItemListFilter() {
        Object itemListFilter = this.isContact ? new AddressBookItemListFilter(this.isSystemContact) : new ItemListFilter();
        itemListFilter.setBoxType(this.getBoxType());
        itemListFilter.setQuickFilter(this.text, this.isContact);
        return itemListFilter;
    }

    public String getDescription() {
        StringBuilder description = new StringBuilder();
        description.append("QuickFilter Text: ").append(this.text);
        if (this.isContact) {
            description.append(": Is Contact");
        } else {
            description.append(": NOT Contact");
        }
        return description.toString();
    }

    public boolean isEmpty() {
        return Utils.isNullOrEmpty(this.text) && super.isEmpty();
    }
}

