/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.folderstree;

import com.appframework.Application;
import com.appframework.ApplicationFrame;
import com.appframework.level.Level;
import com.appframework.level.LevelManager;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.controls.folderstree.GWFoldersTreeController;
import com.novell.gw.jclient.application.controls.folderstree.GWFoldersTreeModel;
import com.novell.gw.jclient.application.controls.folderstree.GWTree;
import com.novell.gw.jclient.application.controls.folderstree.MainGWFoldersTreeRenderer;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeCellRenderer;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GWFoldersTree
extends GWTree
implements MVCView<GWFoldersTreeController<GWFoldersTree>, Object> {
    private static Logger logger = Logger.getLogger(GWFoldersTree.class);
    protected GWFoldersTreeController controller;

    protected GWFoldersTree(MVCController parentController, String userGuid) {
        this.setController((MVCController)this.createFolderTreeController(parentController));
        GWFoldersTreeModel model = new GWFoldersTreeModel(this.getController(), userGuid);
        this.setModel(model);
        this.putClientProperty("JTree.lineStyle", "Angled");
        this.getSelectionModel().setSelectionMode(1);
        this.expandRow(0);
        this.setComponentOrientation(UIUtils.getComponentOrientation());
    }

    protected GWFoldersTreeController createFolderTreeController(MVCController parentController) {
        return new GWFoldersTreeController<GWFoldersTree>(this, parentController);
    }

    public void refreshTree(boolean doReload) {
        String userGuid = this.getOwnerFrameUserGUID();
        ((GWFoldersTreeModel)this.getModel()).refreshFolders(userGuid);
    }

    public abstract void selectFolder(AbstractFolder var1);

    public abstract void expandFolder(AbstractFolder var1);

    @Override
    public void setController(GWFoldersTreeController controller) {
        this.controller = controller;
    }

    @Override
    public GWFoldersTreeController getController() {
        return this.controller;
    }

    @Override
    public void setMVCModel(Object theModel) {
    }

    @Override
    public Object getMVCModel() {
        return null;
    }

    public void drawItFocused(boolean isFocused) {
        TreeCellRenderer renderer = this.getCellRenderer();
        if (renderer instanceof MainGWFoldersTreeRenderer) {
            MainGWFoldersTreeRenderer treeRenderer = (MainGWFoldersTreeRenderer)renderer;
            treeRenderer.setTreeFocused(isFocused);
            this.repaint();
        }
    }

    public void clear() {
        logger.debug((Object)"clearing...");
        String userGuid = this.getOwnerFrameUserGUID();
        ((GWFoldersTreeModel)this.getModel()).clear(userGuid);
        Level level = this.getController().getLevel();
        logger.debug((Object)("releasing controller at level " + level));
        LevelManager.release(level);
    }

    protected String getOwnerFrameUserGUID() {
        String userGuid = null;
        ApplicationFrame appFrame = (ApplicationFrame)SwingUtilities.getAncestorOfClass(ApplicationFrame.class, this);
        if (appFrame == null) {
            appFrame = Application.getActiveFrame();
        }
        if (appFrame == null) {
            appFrame = Application.getGWMainAppFrame();
        }
        if (appFrame != null) {
            userGuid = appFrame.getUserGuid();
        }
        return userGuid;
    }
}

