/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.folderstree;

import com.novell.gw.jclient.application.controls.folderstree.GWFoldersTree;
import com.novell.gw.jclient.application.options.ApplicationOptions;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public final class GWFoldersTreeSerializer {
    private static boolean loaded = false;
    private static final List EXPANDED_NODES_IDS = new LinkedList();

    public static synchronized void save(GWFoldersTree theTree) {
        EXPANDED_NODES_IDS.clear();
        StringBuffer ids = new StringBuffer();
        int nCount = theTree.getRowCount();
        for (int i = 0; i < nCount; ++i) {
            DefaultMutableTreeNode node;
            Object userObject;
            if (!theTree.isExpanded(i) || !((userObject = (node = (DefaultMutableTreeNode)theTree.getPathForRow(i).getLastPathComponent()).getUserObject()) instanceof AbstractFolder)) continue;
            String id = ((AbstractFolder)userObject).getID();
            EXPANDED_NODES_IDS.add(id);
            ids.append(id);
            ids.append(',');
        }
        int length = ids.length();
        if (length > 0) {
            ids.delete(length - 1, length);
        }
        ApplicationOptions.getInstance().put("FOLDERS_TREE_EXPANDED_NODES", ids.toString());
        loaded = true;
    }

    public static void restore(JTree theTree) {
        TreeModel model = theTree.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();
        GWFoldersTreeSerializer.doRestore(root, theTree);
    }

    private static void doRestore(DefaultMutableTreeNode root, JTree theTree) {
        int nCount = root.getChildCount();
        for (int i = 0; i < nCount; ++i) {
            DefaultMutableTreeNode childAt = (DefaultMutableTreeNode)root.getChildAt(i);
            try {
                AbstractFolder folder = (AbstractFolder)childAt.getUserObject();
                if (GWFoldersTreeSerializer.isExpaded(folder.getID())) {
                    TreePath expandedPath = new TreePath(childAt.getPath());
                    theTree.expandPath(expandedPath);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (childAt.isLeaf()) continue;
            GWFoldersTreeSerializer.doRestore(childAt, theTree);
        }
    }

    public static synchronized boolean isExpaded(String theFoldersID) {
        if (!loaded) {
            GWFoldersTreeSerializer.loadTreeState();
        }
        return EXPANDED_NODES_IDS.contains(theFoldersID);
    }

    private static synchronized void loadTreeState() {
        String list = ApplicationOptions.getInstance().getString("FOLDERS_TREE_EXPANDED_NODES", null);
        if (list != null) {
            EXPANDED_NODES_IDS.clear();
            StringTokenizer st = new StringTokenizer(list, ",");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (token == null || token.length() <= 0) continue;
                EXPANDED_NODES_IDS.add(token);
            }
        }
        loaded = true;
    }

    private GWFoldersTreeSerializer() {
    }
}

