/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar;

import com.appframework.ActionList;
import com.appframework.AppAction;
import com.appframework.mvc.Command;
import com.appframework.mvc.GlobalCommand;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.appframework.utils.Day;
import com.appframework.utils.UIUtils;
import com.novell.gw.engine.DataStoreSettings;
import com.novell.gw.jclient.api.enums.CalendarViewType;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.api.interfaces.IViewDisplaySettings;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.ActionNewPostedAppointment;
import com.novell.gw.jclient.application.actions.ActionNewPostedReminderNote;
import com.novell.gw.jclient.application.actions.ActionNewPostedTask;
import com.novell.gw.jclient.application.commands.AttributeKey;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.IItemListComponentDataModel;
import com.novell.gw.jclient.application.controls.gwcalendar.CalendarRefreshEvent;
import com.novell.gw.jclient.application.controls.gwcalendar.CalendarStateEvent;
import com.novell.gw.jclient.application.controls.gwcalendar.CalendarStateListener;
import com.novell.gw.jclient.application.controls.gwcalendar.ClockListener;
import com.novell.gw.jclient.application.controls.gwcalendar.DateAndTimeFormattingUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.TypesToggle;
import com.novell.gw.jclient.application.controls.gwcalendar.TypesToggleChangeListener;
import com.novell.gw.jclient.application.controls.gwcalendar.TypesToggleEvent;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DateChangeEvent;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DateValueChangeListener;
import com.novell.gw.jclient.application.controls.gwcalendar.yearlycalendar.YearlyCalendar;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.skinnable.SkinnablePanel;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.plaf.PLAFChanger;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.items.MessageUtils;
import com.novell.gw.jclient.bl.om.items.TimeInterval;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.JLabel;
import org.apache.log4j.Logger;

public abstract class CalendarView
extends SkinnablePanel
implements MVCView,
CalendarStateListener,
ClockListener {
    private static Logger logger = Logger.getLogger(CalendarView.class);
    public static Dimension HEADER_LABEL_SIZE = new Dimension(20, PLAFChanger.getFontSize() + 8);
    protected Day currentDate;
    private Calendar selectedDate;
    protected TimeZone currentTimeZone;
    protected TypesToggle typesToggle;
    protected JLabel lblTitle;
    protected MVCController controller;
    private CalendarViewType activeCalendarViewType;
    private boolean isActive = true;
    private boolean needRefreshAppointments = true;
    private boolean needRefreshNotes = true;
    private boolean needRefreshTasks = true;
    private boolean refreshedAppointments;
    private boolean refreshedNotes;
    private boolean refreshedTasks;
    private boolean needRefresh;
    protected OrientablePanel titlePanel;
    protected String optionFrameName;
    protected boolean showWeekNumber;
    protected boolean highlightWeekends;
    protected int firstDayOfWeek;
    protected boolean showYearlyCalendar = true;
    protected static final int ALL_DAY_ITEMS_PANEL_HEIGHT = 60;
    protected IItemListComponentDataModel calendarItemListData;
    protected YearlyCalendar yearlyCalendarComponent;
    protected boolean calendarAdjusting = false;

    public CalendarView(Calendar theCurrentDay, TypesToggle theToggle, MVCController theParentController, boolean showYearlyCalendar, IItemListComponentDataModel calendarItemListData) {
        if (calendarItemListData == null) {
            throw new IllegalArgumentException("calendarItemListData is null");
        }
        this.calendarItemListData = calendarItemListData;
        DataStoreSettings dataStoreSettings = GWCommandManager.getInstance(EngineCommandManager.getUserGuid()).getDataStoreSettings();
        this.highlightWeekends = (Integer)dataStoreSettings.getMonthCalendarHighlightDays().getValue() == 1;
        this.showWeekNumber = (Boolean)dataStoreSettings.getMonthCalendarShowWeekNumber().getValue();
        this.firstDayOfWeek = (Integer)dataStoreSettings.getMonthCalendarFirstDay().getValue();
        this.showYearlyCalendar = showYearlyCalendar;
        this.currentTimeZone = theCurrentDay.getTimeZone();
        this.currentDate = new Day(theCurrentDay);
        this.selectedDate = (Calendar)theCurrentDay.clone();
        this.typesToggle = theToggle;
        this.typesToggle.addChangeListener(new ChangeListener());
        this.controller = this.createController(theParentController);
        this.optionFrameName = ControlsUtils.getFrameForController(this.controller).getOptionFrameName();
        new DropTarget(this, 3, new CalendarViewDropTargetListener());
    }

    public boolean checkNoteAccess() {
        ActionList aList = this.getController().getActionList();
        AppAction action = aList.getAction(ActionKey.NEW_POSTED_REMINDERNOTE);
        return ((ActionNewPostedReminderNote)action).checkAccess();
    }

    public boolean checkTaskAccess() {
        ActionList aList = this.getController().getActionList();
        AppAction action = aList.getAction(ActionKey.NEW_POSTED_TASK);
        return ((ActionNewPostedTask)action).checkAccess();
    }

    public boolean checkAppointmentAccess() {
        ActionList aList = this.getController().getActionList();
        AppAction action = aList.getAction(ActionKey.NEW_POSTED_APPOINTMENT);
        return ((ActionNewPostedAppointment)action).checkAccess();
    }

    public CalendarViewType getActiveViewType() {
        return this.activeCalendarViewType;
    }

    protected abstract MVCController createController(MVCController var1);

    protected void buildYearlyCalendarComponent() {
        this.yearlyCalendarComponent.addValueChangeListener(new YearlyCalendarComponentCalendarListener());
    }

    protected void processYearlyCalendarComponentValueChanged(DateChangeEvent e) {
        if (this.calendarAdjusting) {
            return;
        }
        this.selectedDate = GWCalendarUtils.applyDayToCalendar(e.getDay(), this.selectedDate);
        logger.debug((Object)("firing SELECTED_DATE_CHANGED: " + DateAndTimeFormattingUtils.calendarToLogString(this.selectedDate)));
        Command command = new Command(70, this.selectedDate);
        command.setAttribute((Object)AttributeKey.CALENDAR, ControlsUtils.getParentGWCalendarController(this.getController()));
        this.getController().processCommand(command);
    }

    private void adjustViews(TypesToggleEvent theEvent) {
        int toggleID = theEvent.getToggleID();
        switch (toggleID) {
            case 0: {
                this.adjustAppointments();
                break;
            }
            case 1: {
                this.adjustNotes();
                break;
            }
            case 2: {
                this.adjustTasks();
            }
        }
        this.updateUI();
    }

    public AbstractFolder getFolder() {
        return this.calendarItemListData.getAbstractFolder();
    }

    public IItemList getItemList() {
        return this.calendarItemListData.getItemList();
    }

    public IViewDisplaySettings getDisplaySettings() {
        return this.calendarItemListData.getViewDisplaySettings();
    }

    protected void setSelectedTime() {
        Calendar calendar = GWCalendarUtils.convertDayToCalendar(this.currentDate);
        DataStoreSettings dataStoreSettings = GWCommandManager.getInstance(EngineCommandManager.getUserGuid()).getDataStoreSettings();
        int min = (Integer)dataStoreSettings.getCalendarWorkDayStartTime().getValue();
        logger.debug((Object)("min: " + min));
        calendar.set(11, min / 60);
        calendar.set(12, min % 60);
        logger.debug((Object)("calendar: " + DateAndTimeFormattingUtils.calendarToLogString(calendar)));
        Command command = new Command(70, calendar);
        command.setAttribute((Object)AttributeKey.CALENDAR, ControlsUtils.getParentGWCalendarController(this.getController()));
        this.getController().processCommand(command);
    }

    protected void buildUI() {
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.initTitleLable();
        this.titlePanel.add((Component)this.lblTitle, "First");
        this.add((Component)this.titlePanel, "North");
    }

    protected void initTitleLable() {
        this.titlePanel = new OrientablePanel(new BorderLayout());
        this.titlePanel.setOpaque(false);
        this.lblTitle = new OrientableLabel("Header");
        this.lblTitle.setOpaque(false);
        this.lblTitle.setPreferredSize(HEADER_LABEL_SIZE);
        this.lblTitle.setMinimumSize(HEADER_LABEL_SIZE);
    }

    public Object getMVCModel() {
        return null;
    }

    protected final void refresh(boolean folderWasChanged) {
        this.refresh(folderWasChanged, null);
    }

    protected void refresh(boolean folderWasChanged, TimeInterval theChangedInterval) {
        if (this.canRefresh()) {
            MessageUtils.showBusyCursor(true);
            this.prepareRefresh(folderWasChanged);
            IItemList itemList = this.getItemList();
            if (this.typesToggle.isShowAppointments() && this.needRefreshAppointments) {
                this.refreshAppointments(itemList, theChangedInterval);
                this.refreshAllDayEvents(itemList, theChangedInterval);
                this.needRefreshAppointments = false;
            }
            if (this.typesToggle.isShowNotes() && this.needRefreshNotes) {
                this.refreshNotes(itemList, theChangedInterval);
                this.needRefreshNotes = false;
            }
            if (this.typesToggle.isShowTasks() && this.needRefreshTasks) {
                this.refreshTasks(itemList, theChangedInterval);
                this.needRefreshTasks = false;
            }
            this.adjustClock();
            this.needRefresh = false;
            MessageUtils.showBusyCursor(false);
        } else if (theChangedInterval != null) {
            this.setDirty();
        }
    }

    protected abstract CalendarViewType getViewType();

    protected void prepareRefresh(boolean folderWasChanged) {
    }

    protected void refreshTasks(IItemList theItemList, TimeInterval theChangedInterval) {
    }

    protected void refreshNotes(IItemList theItemList, TimeInterval theChangedInterval) {
    }

    protected void refreshAppointments(IItemList theItemList, TimeInterval theChangedInterval) {
    }

    protected void refreshAllDayEvents(IItemList theItemList, TimeInterval theChangedInterval) {
    }

    protected void setDirty() {
    }

    protected void adjustTasks() {
    }

    protected void adjustNotes() {
    }

    protected void adjustAppointments() {
    }

    protected final boolean canRefresh() {
        return this.isActive && this.activeCalendarViewType == this.getViewType();
    }

    protected boolean isNeedRefresh() {
        return this.needRefreshAppointments || this.needRefreshNotes || this.needRefreshTasks;
    }

    private void needRefresh() {
        this.needRefreshAppointments = true;
        this.needRefreshNotes = true;
        this.needRefreshTasks = true;
    }

    public void setController(MVCController theController) {
        this.controller = theController;
    }

    public MVCController getController() {
        return this.controller;
    }

    public void change(CalendarStateEvent theEvent) {
        TimeZone newTimeZone = OptionManager.getInstance().getDateTimeOptions().getTimeZone();
        if (!newTimeZone.equals(this.currentTimeZone)) {
            this.currentTimeZone = newTimeZone;
        }
        this.activeCalendarViewType = theEvent.getViewType();
        this.isActive = theEvent.isActivated();
        this.needRefresh();
        this.refresh(true);
    }

    public void refresh(CalendarRefreshEvent theEvent) {
        this.needRefresh();
        this.refresh(true, theEvent.getRefreshInterval());
    }

    protected void needRefresh(boolean b) {
        if (this.needRefresh != b) {
            this.needRefresh = b;
            if (this.needRefresh) {
                this.backupStates();
            } else {
                this.restoreStates();
            }
        }
    }

    private void restoreStates() {
        this.needRefreshAppointments = !this.refreshedAppointments;
        this.needRefreshTasks = !this.refreshedTasks;
        this.needRefreshNotes = !this.refreshedNotes;
        this.refreshedAppointments = false;
        this.refreshedTasks = false;
        this.refreshedNotes = false;
    }

    private void backupStates() {
        if (!this.needRefreshAppointments) {
            this.needRefreshAppointments = true;
            this.refreshedAppointments = true;
        }
        if (!this.needRefreshNotes) {
            this.needRefreshNotes = true;
            this.refreshedNotes = true;
        }
        if (!this.needRefreshTasks) {
            this.needRefreshTasks = true;
            this.refreshedTasks = true;
        }
    }

    public void clockTik() {
        this.adjustClock();
    }

    protected void adjustClock() {
    }

    public void setMVCModel(Object theModel) {
        if (theModel instanceof Date) {
            Calendar calendar = GWCalendarUtils.getToday();
            calendar.setTime((Date)theModel);
            this.selectedDate = (Calendar)calendar.clone();
            this.currentDate.setCalendar(calendar);
            this.adjustCurrentDay();
        }
    }

    public Date getCurrentDate() {
        return GWCalendarUtils.convertDayToCalendar(this.currentDate).getTime();
    }

    public void refreshUIOptions() {
        DataStoreSettings dataStoreSettings = GWCommandManager.getInstance(EngineCommandManager.getUserGuid()).getDataStoreSettings();
        this.showWeekNumber = (Boolean)dataStoreSettings.getMonthCalendarShowWeekNumber().getValue();
        this.firstDayOfWeek = (Integer)dataStoreSettings.getMonthCalendarFirstDay().getValue();
        this.highlightWeekends = (Integer)dataStoreSettings.getMonthCalendarHighlightDays().getValue() == 1;
    }

    protected abstract void adjustCurrentDay();

    private class YearlyCalendarComponentCalendarListener
    implements DateValueChangeListener {
        private YearlyCalendarComponentCalendarListener() {
        }

        public void valueChanged(DateChangeEvent e) {
            CalendarView.this.processYearlyCalendarComponentValueChanged(e);
        }
    }

    private class CalendarViewDropTargetListener
    extends DropTargetAdapter {
        private CalendarViewDropTargetListener() {
        }

        public void dragOver(DropTargetDragEvent dtde) {
            Point location = dtde.getLocation();
            if (UIUtils.getComponentOrientation().isLeftToRight() && location.x < 2 || !UIUtils.getComponentOrientation().isLeftToRight() && location.x > CalendarView.this.getWidth() - 2) {
                CalendarView.this.controller.processCommand(new GlobalCommand(1752));
            }
        }

        public void drop(DropTargetDropEvent dtde) {
        }
    }

    private class ChangeListener
    implements TypesToggleChangeListener {
        private ChangeListener() {
        }

        public void changed(TypesToggleEvent theEvent) {
            logger.debug((Object)("catch calendarTypeChanged : " + CalendarView.this.getClass().getName()));
            CalendarView.this.refresh(false);
            CalendarView.this.adjustViews(theEvent);
        }
    }
}

