/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar;

import com.appframework.mvc.MVCController;
import com.novell.gw.engine.EngineException;
import com.novell.gw.jclient.application.controls.gwcalendar.TypedActiveItemLabel;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.bl.om.items.ItemAndItemListInfo;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import org.apache.log4j.Logger;

public abstract class CheckBoxItemLabel
extends TypedActiveItemLabel {
    private static Logger logger = Logger.getLogger(CheckBoxItemLabel.class);
    private Rectangle checkbox;
    private int checkBorder = 2;
    protected boolean checkboxLTRInit = this.isLTR;

    public CheckBoxItemLabel(boolean isMultiLine, ItemAndItemListInfo itemAndItemListInfo, Color backColor, MVCController theParentController, boolean doCheckAlignIcons) {
        super(isMultiLine, itemAndItemListInfo, backColor, theParentController, doCheckAlignIcons);
        this.addMouseListener(new CheckBoxMouseListener());
        this.setChecked(this.getItem().isStatusCompleted());
        this.checkbox = new Rectangle(this.iconXOffset + this.checkBorder, this.iconYOffset + this.checkBorder, this.getTypeIconWidth() - 2 * this.checkBorder, this.getTypeIconHeight() - 2 * this.checkBorder);
    }

    public void initLTRCheckbox() {
        if (!this.isLTR) {
            this.checkbox = new Rectangle(this.getWidth() - this.iconXOffset - this.getTypeIconWidth() + this.checkBorder, this.iconYOffset + this.checkBorder, this.getTypeIconWidth() - 2 * this.checkBorder, this.getTypeIconHeight() - 2 * this.checkBorder);
        }
        this.checkboxLTRInit = true;
    }

    protected boolean checkboxContains(Point thePoint) {
        if (!this.checkboxLTRInit) {
            this.initLTRCheckbox();
        }
        return this.checkbox != null && this.checkbox.contains(thePoint);
    }

    protected void setChecked(boolean checked) {
        this.setTypeIcon(checked ? ImageResources.ICON_CALENDAR_CHECKED : ImageResources.ICON_CALENDAR_UNCHECKED);
        this.repaint();
    }

    public int getCheckBorder() {
        return this.checkBorder;
    }

    public void setCheckBorder(int checkBorder) {
        this.checkBorder = checkBorder;
    }

    public Rectangle getCheckbox() {
        return this.checkbox;
    }

    public void setCheckbox(Rectangle checkbox) {
        this.checkbox = checkbox;
    }

    private class CheckBoxMouseListener
    extends MouseAdapter {
        private CheckBoxMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            CheckBoxItemLabel label = CheckBoxItemLabel.this;
            if (label.checkboxContains(e.getPoint())) {
                try {
                    boolean completed = !label.getItem().isStatusCompleted();
                    label.getItem().markComplete(completed);
                    label.setChecked(completed);
                }
                catch (EngineException ex) {
                    logger.error((Object)ex);
                    logger.debug((Object)ex, (Throwable)ex);
                }
            }
        }
    }
}

