/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar;

import com.appframework.Tested;
import com.appframework.utils.Utils;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.frames.options.compose.dateAndTime.DateAndTimeElement;
import com.novell.gw.jclient.application.frames.options.compose.dateAndTime.DateAndTimeFormat;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class DateAndTimeFormattingUtils {
    private static final Logger logger = Logger.getLogger(DateAndTimeFormattingUtils.class);
    private static final Pattern DATE_TIME_SEPARATOR_PATTERN = Pattern.compile("[\u6708\u65e5\u5e74\ub144\uc6d4\uc77c]");
    @Tested
    public static final String[] TIME_DEFAULT_TYPES;
    @Tested
    public static final String[] SHORT_DATE_DEFAULT_TYPES;
    @Tested
    public static final String[] LONG_DATE_DEFAULT_TYPES;
    public static final String DATE_TIME_SEPARATOR = " ";

    @Tested(completely=false)
    public static DateAndTimeFormat convertStringToDateAndTimeFormat(String string, String customTimeFormat, String customShortDateFormat, String customLongDateFormat) {
        if (Utils.isNullOrEmpty(string)) {
            throw new IllegalArgumentException("string is null or empty");
        }
        DateAndTimeElement leadingElement = null;
        DateAndTimeElement trailingElement = null;
        ArrayList<String> times = new ArrayList<String>();
        times.addAll(Arrays.asList(TIME_DEFAULT_TYPES));
        if (!Utils.isNullOrEmpty(customTimeFormat)) {
            times.add(customTimeFormat);
        }
        for (String timeFormat : times) {
            if (string.startsWith(timeFormat)) {
                leadingElement = DateAndTimeElement.TIME;
                if (string.equals(timeFormat)) {
                    return DateAndTimeFormat.getDateAndTimeFormat(leadingElement, trailingElement);
                }
                string = string.substring((timeFormat + DATE_TIME_SEPARATOR).length());
                break;
            }
            if (!string.endsWith(DATE_TIME_SEPARATOR + timeFormat)) continue;
            trailingElement = DateAndTimeElement.TIME;
            string = string.substring(0, string.length() - (timeFormat + DATE_TIME_SEPARATOR).length());
            break;
        }
        if (leadingElement != null) {
            trailingElement = DateAndTimeFormattingUtils.isShortDateFormat(string) ? DateAndTimeElement.SHORT_DATE : DateAndTimeElement.LONG_DATE;
        } else {
            leadingElement = DateAndTimeFormattingUtils.isShortDateFormat(string) ? DateAndTimeElement.SHORT_DATE : DateAndTimeElement.LONG_DATE;
        }
        return DateAndTimeFormat.getDateAndTimeFormat(leadingElement, trailingElement);
    }

    public static String convertDateAndTimeFormatToString(DateAndTimeFormat format, String currentTimeFormat, String currentShortDateFormat, String currentLongDateFormat) {
        if (format == null) {
            throw new IllegalArgumentException("format is null");
        }
        if (Utils.isNullOrEmpty(currentTimeFormat)) {
            throw new IllegalArgumentException("currentTimeFormat is null");
        }
        if (Utils.isNullOrEmpty(currentShortDateFormat)) {
            throw new IllegalArgumentException("currentShortDateFormat is null");
        }
        if (Utils.isNullOrEmpty(currentLongDateFormat)) {
            throw new IllegalArgumentException("currentLongDateFormat is null");
        }
        String result = DateAndTimeFormattingUtils.convertDateAndTimeElementToString(format.getLeadingElement(), currentTimeFormat, currentShortDateFormat, currentLongDateFormat);
        if (format.hasTrailingElement()) {
            result = result + DATE_TIME_SEPARATOR + DateAndTimeFormattingUtils.convertDateAndTimeElementToString(format.getTrailingElement(), currentTimeFormat, currentShortDateFormat, currentLongDateFormat);
        }
        return result;
    }

    private static String convertDateAndTimeElementToString(DateAndTimeElement element, String timeFormat, String shortDateFormat, String longDateFormat) {
        assert (element != null);
        assert (!Utils.isNullOrEmpty(timeFormat));
        assert (!Utils.isNullOrEmpty(shortDateFormat));
        assert (!Utils.isNullOrEmpty(longDateFormat));
        switch (element) {
            case TIME: {
                return timeFormat;
            }
            case LONG_DATE: {
                return longDateFormat;
            }
            case SHORT_DATE: {
                return shortDateFormat;
            }
        }
        throw new IllegalStateException("unexpected DateAndTimeElement: " + (Object)((Object)element));
    }

    public static String formatDate(Date date, String format) {
        if (date == null) {
            throw new IllegalArgumentException("date is null");
        }
        if (Utils.isNullOrEmpty(format)) {
            throw new IllegalArgumentException("format is null or empty");
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(format, Locale.getDefault());
        return dateFormat.format(date);
    }

    public static boolean isFormatValid(String format) {
        if (format == null || format.length() == 0) {
            return false;
        }
        for (int i = 0; i < format.length(); ++i) {
            String s = format.substring(i, i + 1);
            if (s.equals(DATE_TIME_SEPARATOR) || Pattern.matches("\\p{Punct}", s) || Pattern.matches("[a-zA-Z]", s) || DATE_TIME_SEPARATOR_PATTERN.matcher(s).matches()) continue;
            return false;
        }
        try {
            SimpleDateFormat df = new SimpleDateFormat(format, Locale.getDefault());
            df.format(new Date());
        }
        catch (Exception e) {
            return false;
        }
        int n = 0;
        int nCount = format.length();
        for (int i = 0; i < nCount; ++i) {
            if (format.charAt(i) == '\'') {
                ++n;
            }
            try {
                int temp = Integer.decode(format.substring(i, i + 1));
                if (n % 2 != 0) continue;
                return false;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return true;
    }

    public static boolean isShortDateFormat(String format) {
        int maxShortDateLength = 0;
        for (String shortDateFormat : SHORT_DATE_DEFAULT_TYPES) {
            if (shortDateFormat.length() <= maxShortDateLength) continue;
            maxShortDateLength = shortDateFormat.length();
        }
        int minLongDateFormat = 100;
        for (String longDateFormat : LONG_DATE_DEFAULT_TYPES) {
            if (longDateFormat.length() >= minLongDateFormat) continue;
            minLongDateFormat = longDateFormat.length();
        }
        return format.length() < (maxShortDateLength + minLongDateFormat) / 2;
    }

    public static String extractDateFormatFromDateTimeFormat(String dateTimeFormat, String customTimeFormat) {
        if (Utils.isNullOrEmpty(dateTimeFormat)) {
            throw new IllegalArgumentException("string is null or empty");
        }
        DateAndTimeFormat format = DateAndTimeFormattingUtils.convertStringToDateAndTimeFormat(dateTimeFormat, customTimeFormat, null, null);
        if (!format.containsElement(DateAndTimeElement.LONG_DATE) && !format.containsElement(DateAndTimeElement.SHORT_DATE)) {
            throw new IllegalArgumentException("format " + dateTimeFormat + " does not contain date formatting");
        }
        if (format.containsElement(DateAndTimeElement.TIME)) {
            ArrayList<String> times = new ArrayList<String>();
            times.addAll(Arrays.asList(TIME_DEFAULT_TYPES));
            if (!Utils.isNullOrEmpty(customTimeFormat)) {
                times.add(customTimeFormat);
            }
            for (String timeFormat : times) {
                if (dateTimeFormat.startsWith(timeFormat)) {
                    dateTimeFormat = dateTimeFormat.substring((timeFormat + DATE_TIME_SEPARATOR).length());
                    break;
                }
                if (!dateTimeFormat.endsWith(timeFormat)) continue;
                dateTimeFormat = dateTimeFormat.substring(0, dateTimeFormat.length() - (timeFormat + DATE_TIME_SEPARATOR).length());
                break;
            }
        }
        return dateTimeFormat;
    }

    public static String calendarToLogString(Calendar calendar) {
        if (calendar == null) {
            return "null";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(calendar.getClass().getSimpleName());
        builder.append('(');
        builder.append(calendar.get(1));
        builder.append('-');
        builder.append(calendar.get(2) + 1);
        builder.append('-');
        builder.append(calendar.get(5));
        builder.append(' ');
        builder.append(calendar.get(11));
        builder.append(':');
        builder.append(calendar.get(12));
        builder.append(':');
        builder.append(calendar.get(13));
        builder.append(':');
        builder.append(calendar.get(14));
        builder.append(' ');
        builder.append(calendar.getTimeZone().getDisplayName());
        builder.append(')');
        return builder.toString();
    }

    public static DateFormat getDateFormat(String format) {
        if (format == null) {
            throw new IllegalArgumentException("format is null");
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        dateFormat.setCalendar(GWCalendarUtils.getToday());
        return dateFormat;
    }

    public static DateFormat getHoursFormat() {
        String hourFormatString = DateAndTimeFormattingUtils.is24HourFormat() ? "H" : "h";
        return DateAndTimeFormattingUtils.getDateFormat(hourFormatString);
    }

    public static boolean isAmpmMarkerShown() {
        String pattern = OptionManager.getInstance().getDateTimeOptions().getTimeFormat();
        return pattern.contains("a");
    }

    public static boolean is24HourFormat() {
        String timeFormatPattern = OptionManager.getInstance().getDateTimeOptions().getTimeFormat();
        Boolean format24 = DateAndTimeFormattingUtils.is24HourFormatPattern(timeFormatPattern);
        if (format24 != null) {
            return format24;
        }
        logger.warn((Object)("time format in options is invalid: " + timeFormatPattern));
        DateFormat localeFormat = DateFormat.getTimeInstance(3, EngineCommandManager.getLocale());
        if (localeFormat instanceof SimpleDateFormat) {
            timeFormatPattern = ((SimpleDateFormat)localeFormat).toPattern();
            format24 = DateAndTimeFormattingUtils.is24HourFormatPattern(timeFormatPattern);
            if (format24 != null) {
                return format24;
            }
            logger.warn((Object)("time format is invalid for current locale: " + timeFormatPattern));
        }
        Calendar dummyDate = GWCalendarUtils.getTodayWithoutTimeFraction();
        int dummyPmHourValue = 23;
        dummyDate.set(11, dummyPmHourValue);
        String formattedTime = localeFormat.format(dummyDate.getTime());
        return formattedTime.contains(Integer.toString(dummyPmHourValue));
    }

    @Tested
    public static Boolean is24HourFormatPattern(String timeFormatPattern) {
        boolean is12;
        if (timeFormatPattern == null) {
            logger.warn((Object)("invalid timeFormatPattern: " + timeFormatPattern));
            return null;
        }
        boolean is24 = timeFormatPattern.indexOf(72) != -1;
        boolean bl = is12 = timeFormatPattern.indexOf(104) != -1;
        if (is24 && is12) {
            logger.warn((Object)("invalid timeFormatPattern: " + timeFormatPattern));
            return null;
        }
        if (is24) {
            return Boolean.TRUE;
        }
        if (is12) {
            return Boolean.FALSE;
        }
        logger.warn((Object)("invalid timeFormatPattern: " + timeFormatPattern));
        return null;
    }

    static {
        ArrayList<String> formats = new ArrayList<String>();
        if (StringResources.TIME_DEFAULT_TYPE_1 != null) {
            formats.add(StringResources.TIME_DEFAULT_TYPE_1);
        }
        if (StringResources.TIME_DEFAULT_TYPE_2 != null) {
            formats.add(StringResources.TIME_DEFAULT_TYPE_2);
        }
        if (StringResources.TIME_DEFAULT_TYPE_3 != null) {
            formats.add(StringResources.TIME_DEFAULT_TYPE_3);
        }
        if (StringResources.TIME_DEFAULT_TYPE_4 != null) {
            formats.add(StringResources.TIME_DEFAULT_TYPE_4);
        }
        TIME_DEFAULT_TYPES = formats.toArray(new String[formats.size()]);
        formats = new ArrayList();
        if (StringResources.SHORT_DATE_TYPE_1 != null) {
            formats.add(StringResources.SHORT_DATE_TYPE_1);
        }
        if (StringResources.SHORT_DATE_TYPE_2 != null) {
            formats.add(StringResources.SHORT_DATE_TYPE_2);
        }
        if (StringResources.SHORT_DATE_TYPE_3 != null) {
            formats.add(StringResources.SHORT_DATE_TYPE_3);
        }
        if (StringResources.SHORT_DATE_TYPE_4 != null) {
            formats.add(StringResources.SHORT_DATE_TYPE_4);
        }
        SHORT_DATE_DEFAULT_TYPES = formats.toArray(new String[formats.size()]);
        formats = new ArrayList();
        if (StringResources.LONG_DATE_TYPE_1 != null) {
            formats.add(StringResources.LONG_DATE_TYPE_1);
        }
        if (StringResources.LONG_DATE_TYPE_2 != null) {
            formats.add(StringResources.LONG_DATE_TYPE_2);
        }
        if (StringResources.LONG_DATE_TYPE_3 != null) {
            formats.add(StringResources.LONG_DATE_TYPE_3);
        }
        if (StringResources.LONG_DATE_TYPE_4 != null) {
            formats.add(StringResources.LONG_DATE_TYPE_4);
        }
        LONG_DATE_DEFAULT_TYPES = formats.toArray(new String[formats.size()]);
    }
}

