/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar;

import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.application.controls.gwcalendar.CheckBoxItemLabel;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.TaskItemLabel;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.ColorConstants;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.ItemAndItemListInfo;
import com.novell.gw.jclient.bl.om.items.TaskItem;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.util.Date;
import javax.swing.SwingUtilities;

public class TaskTableItemLabel
extends CheckBoxItemLabel {
    public int firstColumnWidth;

    public void updateUI() {
        super.updateUI();
        super.updateUI();
        this.firstColumnWidth = this.getFontMetrics(this.getFont()).stringWidth("W999") + 13;
    }

    public TaskTableItemLabel(boolean isMultiLine, ItemAndItemListInfo itemAndItemListInfo, Color backColor, MVCController theParentController) {
        super(isMultiLine, itemAndItemListInfo, backColor, theParentController, true);
    }

    protected void paintIcons(Graphics g) {
        if (this.getTypeIcon() != null) {
            this.getTypeIcon().paintIcon(this, g, this.getIconX(this.iconXOffset, this.getTypeIconWidth()), this.iconYOffset);
        }
        String priority = null;
        if (this.getItem() instanceof TaskItem) {
            priority = ((TaskItem)this.getItem()).getTaskPriority();
        }
        if (priority == null) {
            priority = "";
        }
        int priorityWidth = SwingUtilities.computeStringWidth(this.getFontMetrics(this.getFont()), priority);
        g.drawString(priority, this.getIconX(this.firstColumnWidth - priorityWidth - this.iconIconGap, priorityWidth), g.getFontMetrics().getHeight() - 1);
        if (this.getStatusIcon() != null) {
            int x = this.getIconX(this.firstColumnWidth, this.getTypeIconWidth());
            this.getStatusIcon().paintIcon(this, g, x += this.iconIconGap, this.iconYOffset);
        }
    }

    protected int getTextStartX() {
        int result = this.firstColumnWidth + this.iconTextGap;
        if (this.getStatusIcon() != null) {
            result += this.getStatusIconWidth() + this.iconIconGap;
        }
        return result;
    }

    protected void paintSelection(Graphics g) {
        if (!this.checkboxLTRInit) {
            this.initLTRCheckbox();
        }
        Graphics2D g2D = (Graphics2D)g;
        Color c = g2D.getColor();
        Stroke s = g2D.getStroke();
        AbstractItem item = this.getItem();
        int x = this.isLTR ? 0 : this.getWidth() - this.firstColumnWidth;
        g2D.setColor(ColorConstants.TIME_PANEL_COLOR);
        if (!item.isStatusCompleted()) {
            Date startDate = new Date();
            Date endDate = new Date();
            if (item instanceof TaskItem) {
                TaskItem task = (TaskItem)item;
                startDate = task.getStartDate();
                endDate = task.getEndDate();
            }
            Date today = GWCalendarUtils.getToday().getTime();
            if (!(item.isStatusCompleted() || !GWCalendarUtils.isSameDate(today, startDate) && item instanceof TaskItem)) {
                if (GWCalendarUtils.isSameDate(today, endDate)) {
                    Color leftGradientColor = this.isLTR ? TaskItemLabel.TASK_NOT_COMPLETED_DUE_TODAY_COLOR : Color.WHITE;
                    Color rightGradientColor = this.isLTR ? Color.WHITE : TaskItemLabel.TASK_NOT_COMPLETED_DUE_TODAY_COLOR;
                    g2D.setPaint(new GradientPaint(x, 0.0f, leftGradientColor, x + this.firstColumnWidth, 0.0f, rightGradientColor));
                } else if (!GWCalendarUtils.isSameDate(today, endDate) && GWCalendarUtils.getDifferenceInSeconds(today, endDate) > 0L) {
                    Color leftGradientColor = this.isLTR ? TaskItemLabel.TASK_NOT_COMPLETED_PAST_DUE_COLOR : Color.WHITE;
                    Color rightGradientColor = this.isLTR ? Color.WHITE : TaskItemLabel.TASK_NOT_COMPLETED_PAST_DUE_COLOR;
                    g2D.setPaint(new GradientPaint(x, 0.0f, leftGradientColor, x + this.firstColumnWidth, 0.0f, rightGradientColor));
                }
            }
        }
        g2D.fillRect(x, 0, this.firstColumnWidth, this.getHeight());
        g2D.setColor(Color.WHITE);
        g2D.fill(this.getCheckbox());
        x = this.getSelectionX(this.firstColumnWidth);
        int x1 = this.isLTR ? this.firstColumnWidth : 0;
        Color calendarDisplayColor = item.getCalendarDisplayColor();
        Color calendarDisplayFinalGradientColor = item.getCalendarDisplayFinalGradientColor();
        if (this.isLTR) {
            g2D.setPaint(new GradientPaint(this.firstColumnWidth + 1, 0.0f, calendarDisplayColor, this.getWidth(), 0.0f, calendarDisplayFinalGradientColor));
        } else {
            g2D.setPaint(new GradientPaint(1.0f, 0.0f, calendarDisplayFinalGradientColor, this.getWidth() - this.firstColumnWidth, 0.0f, calendarDisplayColor));
        }
        g2D.fillRect(x1, 0, this.getWidth() - this.firstColumnWidth, this.getHeight());
        g2D.setColor(Color.LIGHT_GRAY);
        g2D.drawLine(0, 0, this.getWidth() - 1, 0);
        g2D.drawLine(0, this.getHeight() - 1, this.getWidth() - 1, this.getHeight() - 1);
        g2D.setColor(ColorConstants.BORDER_COLOR);
        g2D.drawLine(x, 0, x, this.getHeight() - 1);
        if (this.isSelected()) {
            g2D.setColor(ColorConstants.SELECTED_BORDER_COLOR);
            g2D.setStroke(new BasicStroke(1.0f, 2, 0, 10.0f, new float[]{1.0f, 2.0f}, 0.0f));
            g2D.drawRect(0, 1, this.getWidth() - 1, this.getHeight() - 3);
            g2D.setColor(ColorConstants.BORDER_COLOR);
            g2D.drawLine(x, 1, x, this.getHeight() - 2);
        }
        g2D.setStroke(s);
        g2D.setColor(c);
    }
}

