/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar.ToolBarProperties;

import com.novell.gw.jclient.api.enums.CalendarViewType;
import com.novell.gw.jclient.application.resources.StringResources;
import java.io.Serializable;

public class PropertiesViewListItem
implements Serializable {
    private String name;
    private String viewName;
    private CalendarViewType calendarViewType;

    public PropertiesViewListItem(String name, CalendarViewType calendarViewType) {
        this.name = name;
        this.calendarViewType = calendarViewType;
        this.updateViewName();
    }

    public PropertiesViewListItem(PropertiesViewListItem item) {
        this.name = item.getName();
        this.calendarViewType = item.getView();
        this.viewName = item.getViewName();
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setView(CalendarViewType calendarViewType) {
        this.calendarViewType = calendarViewType;
        this.updateViewName();
    }

    private void updateViewName() {
        switch (this.calendarViewType) {
            case DAILY: {
                this.viewName = StringResources.DAY;
                break;
            }
            case WEEKLY: {
                this.viewName = StringResources.WEEK;
                break;
            }
            case MONTHLY: {
                this.viewName = StringResources.MONTH;
                break;
            }
            case YEARLY: {
                this.viewName = StringResources.YEAR;
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown view type!");
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public CalendarViewType getView() {
        return this.calendarViewType;
    }

    public String toString() {
        return this.viewName;
    }

    public String getViewName() {
        return this.viewName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertiesViewListItem that = (PropertiesViewListItem)o;
        if (this.calendarViewType != that.calendarViewType) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        return this.viewName.equals(that.viewName);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.viewName.hashCode();
        result = 31 * result + this.calendarViewType.hashCode();
        return result;
    }
}

