/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar;

import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.application.controls.gwcalendar.ActiveItemLabel;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.ColorConstants;
import com.novell.gw.jclient.bl.om.items.ItemAndItemListInfo;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public abstract class TypedActiveItemLabel
extends ActiveItemLabel {
    private static Logger logger = Logger.getLogger(TypedActiveItemLabel.class);
    private ImageIcon typeIcon = null;

    protected TypedActiveItemLabel(boolean isMultiLine, ItemAndItemListInfo itemAndItemListInfo, Color backColor, MVCController theParentController, boolean doCheckAlignIcons) {
        super(isMultiLine, itemAndItemListInfo, backColor, theParentController, doCheckAlignIcons);
    }

    public ImageIcon getTypeIcon() {
        return this.typeIcon;
    }

    public void setTypeIcon(ImageIcon typeIcon) {
        this.typeIcon = typeIcon;
    }

    public int getTypeIconWidth() {
        return this.typeIcon != null ? this.typeIcon.getIconWidth() : 0;
    }

    public int getTypeIconHeight() {
        return this.typeIcon != null ? this.typeIcon.getIconHeight() : 0;
    }

    protected void paintIcons(Graphics g) {
        if (this.typeIcon != null) {
            this.typeIcon.paintIcon(this, g, this.getIconX(this.iconXOffset, this.getTypeIconWidth()), this.iconYOffset);
        }
    }

    protected void paintSelection(Graphics g) {
        Color c = g.getColor();
        if (this.isSelected()) {
            g.setColor(this.getSelectedColor());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(ColorConstants.SELECTED_BORDER_COLOR);
            g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        }
        g.setColor(c);
    }

    protected int getTextStartX() {
        return this.insets.left + this.getTypeIconWidth() + this.iconTextGap;
    }

    public Dimension getPreferredSize() {
        if (this.isMultiLine) {
            return new Dimension(this.getWidth(), this.getPreferredHeight(this.getWidth()));
        }
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int textWidth = SwingUtilities.computeStringWidth(fm, this.text);
        int height = this.insets.top + fm.getHeight() + this.insets.bottom;
        int width = this.insets.left + this.getTypeIconWidth() + this.iconTextGap + textWidth + this.insets.right;
        return new Dimension(width, height);
    }
}

