/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar.calendarpanel;

import com.appframework.components.customizedbutton.ToolBarButton;
import com.appframework.components.customizedbutton.ToolBarToggleButton;
import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.appframework.utils.OS;
import com.novell.gw.jclient.api.enums.CalendarViewType;
import com.novell.gw.jclient.api.interfaces.IItem;
import com.novell.gw.jclient.api.interfaces.IViewDisplaySettings;
import com.novell.gw.jclient.application.GWMainAppFrame;
import com.novell.gw.jclient.application.commands.AttributeKey;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.CalendarRefreshEvent;
import com.novell.gw.jclient.application.controls.gwcalendar.CalendarStateEvent;
import com.novell.gw.jclient.application.controls.gwcalendar.CalendarStateListener;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendar;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarController;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.ToolBarProperties.CalendarViewPropertiesDialog;
import com.novell.gw.jclient.application.controls.gwcalendar.ToolBarProperties.PropertiesViewList;
import com.novell.gw.jclient.application.controls.gwcalendar.ToolBarProperties.PropertiesViewListItem;
import com.novell.gw.jclient.application.controls.gwcalendar.TypesToggle;
import com.novell.gw.jclient.application.controls.gwcalendar.ViewsToggle;
import com.novell.gw.jclient.application.controls.gwcalendar.calendarpanel.CalendarToolBarController;
import com.novell.gw.jclient.application.controls.gwcalendar.calendarpanel.ToolbarSingleDateSelector;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DateChangeEvent;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DateValueChangeListener;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.SingleDateSelector;
import com.novell.gw.jclient.application.controls.gwcomponent.GWMouseAdapter;
import com.novell.gw.jclient.application.controls.gwcomponent.GWPopupMenu;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.toolbars.GWToolBar;
import com.novell.gw.jclient.application.options.ApplicationOptions;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.items.ItemAndItemListInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.Calendar;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalendarToolBar
extends OrientablePanel
implements MVCView<CalendarToolBarController, Object>,
CalendarStateListener {
    private static final Logger logger = Logger.getLogger(CalendarToolBar.class);
    private CalendarToolBarController controller;
    private MVCController theParentController;
    private SingleDateSelector singleDateSelector;
    private Calendar currentDay;
    private TypesToggle typesToggle;
    private ViewsToggle viewsToggle;
    private TypesToggle typesToggleDaily;
    private TypesToggle typesToggleWeekly;
    private TypesToggle typesToggleMonthly;
    private TypesToggle typesToggleYearly;
    private ToolBarToggleButton tbtnShowAppointments;
    private ToolBarToggleButton tbtnShowTasks;
    private ToolBarToggleButton tbtnShowNotes;
    private static final int MNEMONIC_APPOINTMENT = 80;
    private static final int MNEMONIC_TASK = 83;
    private static final int MNEMONIC_REMINDER = 82;
    private ToolBarButton btnPlus;
    private ToolBarButton btnMinus;
    private ToolBarToggleButton[] btnArrayTime;
    private int countBtn = -1;
    private JPopupMenu popupMenu;
    private int view = 1;
    private PropertiesViewList itemPropertyList;
    private ChangeSelectedDay btnSimpleLeftAction;
    private ChangeSelectedDay btnSimpleRightAction;
    public static final String VIEW_NAME = "CalendarToolBar_view";
    private PopupMouseListener customizeToolbarListener;
    private boolean showViewsToggleButtons = true;
    private boolean isSimpleNavigation = false;
    private CalendarViewType calendarViewTypeType;
    private ItemAndItemListInfo itemAndItemListInfoDaylyView;
    private ItemAndItemListInfo itemAndItemListInfoWeeklyView;
    private Date date;
    private IViewDisplaySettings displaySettings;

    public CalendarToolBar(Calendar theCurrentDate, TypesToggle theTypesToggle, ViewsToggle theViewsToggle, MVCController theParentController, TypesToggle typesToggleDaily, TypesToggle typesToggleWeekly, TypesToggle typesToggleMonthly, TypesToggle typesToggleYearly, boolean showViewsToggleButtons, boolean isSimpleNavigation, IViewDisplaySettings displaySettings) {
        this.displaySettings = displaySettings;
        this.theParentController = theParentController;
        this.controller = new CalendarToolBarController(this, theParentController);
        this.showViewsToggleButtons = showViewsToggleButtons;
        this.isSimpleNavigation = isSimpleNavigation;
        this.currentDay = theCurrentDate;
        this.typesToggle = theTypesToggle;
        this.viewsToggle = theViewsToggle;
        this.typesToggleDaily = typesToggleDaily;
        this.typesToggleWeekly = typesToggleWeekly;
        this.typesToggleMonthly = typesToggleMonthly;
        this.typesToggleYearly = typesToggleYearly;
        this.loadProperties();
        this.buildUI();
        this.updateDateLabel();
    }

    public TypesToggle getTypesToggle() {
        return this.typesToggle;
    }

    public void setDisplaySettings(IViewDisplaySettings displaySettings) {
        this.displaySettings = displaySettings;
        switch (displaySettings.getCalViewType()) {
            case DAILY: {
                this.typesToggle = this.typesToggleDaily;
                break;
            }
            case WEEKLY: {
                this.typesToggle = this.typesToggleWeekly;
                break;
            }
            case MONTHLY: {
                this.typesToggle = this.typesToggleMonthly;
                break;
            }
            case YEARLY: {
                this.typesToggle = this.typesToggleYearly;
            }
        }
        this.tbtnShowAppointments.setSelected(this.typesToggle.isShowAppointments());
        this.tbtnShowTasks.setSelected(this.typesToggle.isShowTasks());
        this.tbtnShowNotes.setSelected(this.typesToggle.isShowNotes());
        if (this.btnArrayTime != null) {
            for (int i = 0; i < this.btnArrayTime.length; ++i) {
                boolean selected = i == this.viewsToggle.getSelectedIndex();
                this.btnArrayTime[i].setSelected(selected);
            }
        }
    }

    private void buildUI() {
        this.customizeToolbarListener = new PopupMouseListener();
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), BorderFactory.createEtchedBorder()));
        this.countBtn = this.itemPropertyList.size();
        JComponent leftPanel = this.buildLeftPanel();
        this.add((Component)leftPanel, "Before");
        GWToolBar toolbar = new GWToolBar(new FlowLayout());
        toolbar.setBorder(null);
        toolbar.setOpaque(true);
        toolbar.addMouseListener(this.customizeToolbarListener);
        this.add((Component)toolbar, "Center");
        this.add((Component)this.buildRightPanel(), "After");
        this.tbtnShowAppointments.setSelected(this.typesToggle.isShowAppointments());
        this.tbtnShowTasks.setSelected(this.typesToggle.isShowTasks());
        this.tbtnShowNotes.setSelected(this.typesToggle.isShowNotes());
        this.adjustToolbarRightPanelButtons(this.viewsToggle.getType());
        this.addMouseListener(this.customizeToolbarListener);
        JMenuItem menuItem = new JMenuItem(StringResources.PROPERTIES);
        menuItem.addActionListener(new ShowPropertiesDialogAction());
        this.popupMenu = new GWPopupMenu();
        this.popupMenu.add(menuItem);
        this.setOpaque(false);
    }

    public void refreshUIOptions() {
        if (this.singleDateSelector != null) {
            this.singleDateSelector.refreshUIOptions();
        }
    }

    public void adjustToolbarRightPanelButtons(CalendarViewType calendarViewTypeType) {
        this.setPlusMinusEnable(calendarViewTypeType == CalendarViewType.WEEKLY);
        this.setTypesToggleDisable(calendarViewTypeType == CalendarViewType.YEARLY);
    }

    private void loadProperties() {
        int loadedView = 5;
        this.itemPropertyList = GWCalendarUtils.getCalendarPropertiesViewList();
        try {
            Integer iView = ApplicationOptions.getInstance().getInteger(VIEW_NAME);
            if (iView != null) {
                loadedView = iView;
            }
            this.view = loadedView;
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        if (loadedView != 0 && loadedView != 1) {
            this.view = 1;
        }
    }

    private void saveProperties() {
        GWCalendarUtils.setCalendarPropertiesViewList(this.itemPropertyList);
        ApplicationOptions.getInstance().put(VIEW_NAME, this.view);
    }

    private JComponent buildLeftPanel() {
        GWToolBar pnl = new GWToolBar(new FlowLayout(1, 0, 1));
        pnl.setBorder(null);
        JPanel calendarPanel = this.buildCalendarButtonPanel();
        calendarPanel.setOpaque(false);
        pnl.add(calendarPanel);
        pnl.add(new OrientableLabel(" "));
        BtnTodayAction todayAction = new BtnTodayAction();
        ToolBarButton btn = new ToolBarButton(todayAction);
        btn.setMargin(new Insets(4, 4, 4, 4));
        btn.setToolTipText(StringResources.GO_TO_TODAY);
        pnl.add(btn);
        boolean isLeftToRight = this.getComponentOrientation().isLeftToRight();
        if (this.view == 0) {
            CalendarViewType type = this.viewsToggle.getType();
            if (type == CalendarViewType.MONTHLY) {
                this.addLessMoreButtons(pnl, 31, isLeftToRight);
            } else if (type == CalendarViewType.WEEKLY) {
                this.addLessMoreButtons(pnl, 7, isLeftToRight);
            } else if (type == CalendarViewType.YEARLY) {
                this.addLessMoreButtons(pnl, 365, isLeftToRight);
            } else if (type == CalendarViewType.DAILY) {
                this.addLessMoreButtons(pnl, 1, isLeftToRight);
            }
        } else {
            this.addLessMoreButtons(pnl, 1, isLeftToRight);
            this.addLessMoreButtons(pnl, 7, isLeftToRight);
            this.addLessMoreButtons(pnl, 31, isLeftToRight);
            this.addLessMoreButtons(pnl, 365, isLeftToRight);
        }
        pnl.setOpaque(true);
        return pnl;
    }

    private void addLessMoreButtons(JComponent theParent, int step, boolean reverse) {
        String moveForward;
        String moveBackward;
        Insets in = this.view == 0 ? new Insets(4, 4, 4, 4) : new Insets(4, 2, 4, 2);
        GWToolBar panel = new GWToolBar();
        panel.setBorder(null);
        ((Container)panel).setLayout(new BorderLayout());
        ToolBarButton btn = new ToolBarButton(ImageResources.ACT_LESS_BLACK);
        switch (step) {
            case 1: {
                moveBackward = StringResources.MOVE_BACKWARD_ONE_DAY;
                moveForward = StringResources.MOVE_FORWARD_ONE_DAY;
                break;
            }
            case 7: {
                moveBackward = StringResources.MOVE_BACKWARD_ONE_WEEK;
                moveForward = StringResources.MOVE_FORWARD_ONE_WEEK;
                break;
            }
            case 31: {
                moveBackward = StringResources.MOVE_BACKWARD_ONE_MONTH;
                moveForward = StringResources.MOVE_FORWARD_ONE_MONTH;
                break;
            }
            case 365: {
                moveBackward = StringResources.MOVE_BACKWARD_ONE_YEAR;
                moveForward = StringResources.MOVE_FORWARD_ONE_YEAR;
                break;
            }
            default: {
                moveBackward = "";
                moveForward = "";
            }
        }
        btn.setMargin(in);
        ChangeSelectedDay action = new ChangeSelectedDay((reverse ? -1 : 1) * step);
        btn.addActionListener(action);
        panel.add((Component)btn, "West");
        if (this.view == 0) {
            this.btnSimpleLeftAction = action;
        }
        if (this.view == 1) {
            panel.add((Component)new OrientableLabel(String.valueOf(step)), "Center");
            btn.setToolTipText(moveBackward);
        } else {
            JPanel pnl = new JPanel(new BorderLayout());
            pnl.add((Component)new JSeparator(1), "Center");
            pnl.setBorder(new EmptyBorder(0, 2, 0, 2));
            panel.add(pnl);
        }
        btn = new ToolBarButton(ImageResources.ACT_MORE_BLACK);
        if (this.view == 1) {
            btn.setToolTipText(moveForward);
        }
        btn.setMargin(in);
        action = new ChangeSelectedDay((reverse ? 1 : -1) * step);
        btn.addActionListener(action);
        panel.add((Component)btn, "East");
        if (this.view == 0) {
            this.btnSimpleRightAction = action;
        }
        theParent.add(panel);
    }

    private JPanel buildCalendarButtonPanel() {
        this.singleDateSelector = new ToolbarSingleDateSelector();
        this.singleDateSelector.setName("CalendarToolBar_dateSelector");
        DateSelectorListener dateSelectorListener = new DateSelectorListener();
        this.singleDateSelector.addDateChangeListener(dateSelectorListener);
        OrientablePanel pnl = new OrientablePanel(new BorderLayout());
        pnl.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(this.getBackground(), 1), BorderFactory.createEtchedBorder()));
        pnl.add((Component)this.singleDateSelector, "Center");
        return pnl;
    }

    private JComponent buildRightPanel() {
        GWToolBar pnl = new GWToolBar(new FlowLayout(3, 0, 0));
        pnl.setOpaque(true);
        pnl.addMouseListener(this.customizeToolbarListener);
        if (this.showViewsToggleButtons) {
            this.buildViewsToggleButtons(pnl);
        }
        this.tbtnShowAppointments = CalendarToolBar.createToggleButton(ImageResources.ACT_SHOW_APPOINTMENTS, 80);
        this.tbtnShowAppointments.setToolTipText(StringResources.SHOW_HIDE_APPOINTMENTS);
        this.tbtnShowTasks = CalendarToolBar.createToggleButton(ImageResources.ACT_SHOW_TASKS, 83);
        this.tbtnShowTasks.setToolTipText(StringResources.SHOW_HIDE_TASKS);
        this.tbtnShowNotes = CalendarToolBar.createToggleButton(ImageResources.ACT_SHOW_NOTES, 82);
        this.tbtnShowNotes.setToolTipText(StringResources.SHOW_HIDE_NOTES);
        this.btnPlus = new ToolBarButton(new BtnPlusAction());
        this.btnPlus.setToolTipText(StringResources.ADD_A_COLUMN_TO_THE_CALENDAR_VIEW);
        this.btnPlus.setMargin(new Insets(3, 3, 3, 3));
        this.btnMinus = new ToolBarButton(new BtnMinusAction());
        this.btnMinus.setToolTipText(StringResources.REMOVE_A_COLUMN_FROM_THE_CALENDAR_VIEW);
        this.btnMinus.setMargin(new Insets(3, 3, 3, 3));
        this.addListenersToItemsToggle();
        CalendarViewType type = this.viewsToggle.getType();
        if (!this.isSimpleNavigation || type != CalendarViewType.YEARLY) {
            pnl.add(this.tbtnShowAppointments);
            pnl.add(this.tbtnShowTasks);
            pnl.add(this.tbtnShowNotes);
        }
        if (!this.isSimpleNavigation || type == CalendarViewType.WEEKLY) {
            ((JToolBar)pnl).addSeparator();
            pnl.add(this.btnPlus);
            pnl.add(this.btnMinus);
        }
        return pnl;
    }

    private void buildViewsToggleButtons(JToolBar pnl) {
        Color buttonForeground = (Color)UIManager.getDefaults().get("Button.foreground");
        if (buttonForeground == null) {
            buttonForeground = Color.BLACK;
        }
        this.btnArrayTime = new ToolBarToggleButton[this.countBtn];
        ButtonGroup bg = new ButtonGroup();
        for (int i = 0; i < this.countBtn; ++i) {
            if (this.itemPropertyList.getView(i) == CalendarViewType.DAILY) {
                this.btnArrayTime[i] = new ToolBarToggleButton(ImageResources.ACT_CALENDAR_DAILY);
                this.btnArrayTime[i].setName("CalendarToolBar_btnDaily");
            }
            if (this.itemPropertyList.getView(i) == CalendarViewType.WEEKLY) {
                this.btnArrayTime[i] = new ToolBarToggleButton(ImageResources.ACT_CALENDAR_WEEKLY);
                this.btnArrayTime[i].setName("CalendarToolBar_btnWeekly");
            }
            if (this.itemPropertyList.getView(i) == CalendarViewType.MONTHLY) {
                this.btnArrayTime[i] = new ToolBarToggleButton(ImageResources.ACT_CALENDAR_MONTHLY);
                this.btnArrayTime[i].setName("CalendarToolBar_btnMonthly");
            }
            if (this.itemPropertyList.getView(i) == CalendarViewType.YEARLY) {
                this.btnArrayTime[i] = new ToolBarToggleButton(ImageResources.ACT_CALENDAR_YEARLY);
                this.btnArrayTime[i].setName("CalendarToolBar_btnYearly");
            }
            this.btnArrayTime[i].addActionListener(new BtnCalendarType(this.itemPropertyList.getListItem(i)));
            this.btnArrayTime[i].setSelected(i == this.viewsToggle.getSelectedIndex());
            this.btnArrayTime[i].setText(this.itemPropertyList.getName(i));
            this.btnArrayTime[i].clearPropertyBindings();
            this.btnArrayTime[i].setForeground(buttonForeground);
            bg.add(this.btnArrayTime[i]);
            pnl.add(this.btnArrayTime[i]);
        }
    }

    private static ToolBarToggleButton createToggleButton(ImageIcon theImageIcon, int theMnemonic) {
        ToolBarToggleButton button = new ToolBarToggleButton(theImageIcon);
        button.setMargin(new Insets(2, 2, 2, 2));
        if (!OS.isMacOS()) {
            button.setMnemonic(theMnemonic);
        }
        return button;
    }

    private void addListenersToItemsToggle() {
        this.tbtnShowAppointments.addActionListener(new TbtnViewItems(this.tbtnShowTasks, this.tbtnShowNotes));
        this.tbtnShowTasks.addActionListener(new TbtnViewItems(this.tbtnShowAppointments, this.tbtnShowNotes));
        this.tbtnShowNotes.addActionListener(new TbtnViewItems(this.tbtnShowAppointments, this.tbtnShowTasks));
    }

    protected void updateDateLabel() {
        this.singleDateSelector.setDate(this.currentDay);
    }

    public CalendarViewType getViewType() {
        return this.calendarViewTypeType;
    }

    public void setViewType(CalendarViewType calendarViewTypeType) {
        this.calendarViewTypeType = calendarViewTypeType;
    }

    public void setItemInfoForWeeklyView(ItemAndItemListInfo itemAndItemListInfoWeeklyView) {
        this.itemAndItemListInfoWeeklyView = itemAndItemListInfoWeeklyView;
    }

    public void setItemInfoForDaylyView(ItemAndItemListInfo itemAndItemListInfo) {
        this.itemAndItemListInfoDaylyView = itemAndItemListInfo;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public void setPlusMinusEnable(boolean b) {
        this.btnPlus.setEnabled(b);
        this.btnMinus.setEnabled(b);
    }

    private void setTypesToggleDisable(boolean b) {
        this.tbtnShowAppointments.setEnabled(!b);
        this.tbtnShowTasks.setEnabled(!b);
        this.tbtnShowNotes.setEnabled(!b);
    }

    @Override
    public void setController(CalendarToolBarController theController) {
        this.controller = theController;
    }

    @Override
    public CalendarToolBarController getController() {
        return this.controller;
    }

    @Override
    public void setMVCModel(Object model) {
        if (model instanceof Date) {
            this.currentDay.setTime((Date)model);
            this.updateDateLabel();
        } else if (model instanceof Calendar) {
            this.currentDay = (Calendar)((Calendar)model).clone();
            this.updateDateLabel();
        } else if (this.viewsToggle.getType() == CalendarViewType.WEEKLY && model instanceof Integer) {
            int x = (Integer)model;
            switch (x) {
                case 0: {
                    this.setEnablePlusBtn(false);
                    this.setEnableMinusBtn(true);
                    break;
                }
                case 1: {
                    this.setEnablePlusBtn(true);
                    this.setEnableMinusBtn(true);
                    break;
                }
                case 2: {
                    this.setEnableMinusBtn(false);
                    break;
                }
                case 3: {
                    this.setEnableMinusBtn(true);
                }
            }
        }
    }

    private boolean isPopupMenuEnabled() {
        return SwingUtilities.getWindowAncestor(this) instanceof GWMainAppFrame;
    }

    private void setEnablePlusBtn(boolean enable) {
        this.btnPlus.setEnabled(enable);
    }

    private void setEnableMinusBtn(boolean enable) {
        this.btnMinus.setEnabled(enable);
    }

    @Override
    public Object getMVCModel() {
        return null;
    }

    @Override
    public void change(CalendarStateEvent theEvent) {
        this.adjustToolbarRightPanelButtons(theEvent.getViewType());
    }

    @Override
    public void refresh(CalendarRefreshEvent theEvent) {
    }

    public void refresh() {
        if (this.btnArrayTime != null) {
            for (int i = 0; i < this.itemPropertyList.size(); ++i) {
                if (this.viewsToggle.getSelectedIndex() != i) continue;
                this.btnArrayTime[i].setSelected(true);
                break;
            }
        }
    }

    public void fireRebuild(PropertiesViewList propertiesViewList) {
        this.itemPropertyList = propertiesViewList;
        this.viewsToggle.firePropertiesListChanged(propertiesViewList);
        this.removeAll();
        this.buildUI();
        this.setSelectedBtn();
        this.revalidate();
    }

    private void setSelectedBtn() {
        boolean isSelected = false;
        for (ToolBarToggleButton aBtnArrayTime : this.btnArrayTime) {
            if (!aBtnArrayTime.isSelected()) continue;
            isSelected = true;
            break;
        }
        if (!isSelected && this.btnArrayTime[0] != null && this.btnArrayTime[0].getActionListeners()[0] != null) {
            this.btnArrayTime[0].setSelected(true);
            this.btnArrayTime[0].getActionListeners()[0].actionPerformed(null);
        }
    }

    public void changeSimpleButtons() {
        int i = 0;
        CalendarViewType calendarType = this.viewsToggle.getType();
        switch (calendarType) {
            case DAILY: {
                i = 1;
                break;
            }
            case WEEKLY: {
                i = 7;
                break;
            }
            case MONTHLY: {
                i = 31;
                break;
            }
            case YEARLY: {
                i = 365;
            }
        }
        this.btnSimpleLeftAction.setDayShift(-i);
        this.btnSimpleRightAction.setDayShift(i);
    }

    private class ShowPropertiesDialogAction
    extends AbstractAction {
        private ShowPropertiesDialogAction() {
        }

        public void actionPerformed(ActionEvent e) {
            Window windowAncestor = SwingUtilities.getWindowAncestor(CalendarToolBar.this);
            CalendarViewPropertiesDialog dialog = windowAncestor instanceof JFrame ? new CalendarViewPropertiesDialog((JFrame)windowAncestor, CalendarToolBar.this.itemPropertyList, CalendarToolBar.this.view) : new CalendarViewPropertiesDialog((JDialog)windowAncestor, CalendarToolBar.this.itemPropertyList, CalendarToolBar.this.view);
            if (dialog.showDialog()) {
                CalendarToolBar.this.view = dialog.getView();
                CalendarToolBar.this.getController().processCommand(new Command(81, dialog.getButtonList()));
                CalendarToolBar.this.itemPropertyList = dialog.getButtonList();
                CalendarToolBar.this.updateDateLabel();
                if (CalendarToolBar.this.view == 0) {
                    CalendarToolBar.this.changeSimpleButtons();
                }
                CalendarToolBar.this.saveProperties();
            }
            dialog.dispose();
        }
    }

    private class PopupMouseListener
    extends GWMouseAdapter {
        private PopupMouseListener() {
        }

        public void showPopup(MouseEvent e) {
            if (CalendarToolBar.this.isPopupMenuEnabled()) {
                CalendarToolBar.this.popupMenu.show((JComponent)e.getSource(), e.getX(), e.getY());
            }
        }
    }

    private class DateSelectorListener
    implements DateValueChangeListener {
        private DateSelectorListener() {
        }

        public void valueChanged(DateChangeEvent e) {
            Command command = new Command(70, e.getDate());
            command.setAttribute((Object)AttributeKey.CALENDAR, ControlsUtils.getParentGWCalendarController(CalendarToolBar.this.getController()));
            CalendarToolBar.this.getController().processCommand(command);
        }
    }

    private class BtnMinusAction
    extends AbstractAction {
        public BtnMinusAction() {
            this.putValue("SmallIcon", ImageResources.ICON_MINUS);
        }

        public void actionPerformed(ActionEvent e) {
            Command command = new Command(90, -1);
            command.setAttribute((Object)AttributeKey.CALENDAR, ControlsUtils.getParentGWCalendarController(CalendarToolBar.this.getController()));
            CalendarToolBar.this.getController().processCommand(command);
        }
    }

    private class BtnPlusAction
    extends AbstractAction {
        public BtnPlusAction() {
            this.putValue("SmallIcon", ImageResources.ICON_PLUS);
        }

        public void actionPerformed(ActionEvent e) {
            Command command = new Command(90, 1);
            command.setAttribute((Object)AttributeKey.CALENDAR, ControlsUtils.getParentGWCalendarController(CalendarToolBar.this.getController()));
            CalendarToolBar.this.getController().processCommand(command);
        }
    }

    private class BtnTodayAction
    extends AbstractAction {
        public BtnTodayAction() {
            this.putValue("SmallIcon", ImageResources.ACT_GOTO_TODAY);
        }

        public void actionPerformed(ActionEvent e) {
            Command command = new Command(70, CalendarToolBar.this.theParentController);
            command.setCommandObject(GWCalendarUtils.getToday());
            command.setAttribute((Object)AttributeKey.CALENDAR, ControlsUtils.getParentGWCalendarController(CalendarToolBar.this.getController()));
            CalendarToolBar.this.getController().processCommand(command);
        }
    }

    class TbtnViewItems
    extends AbstractAction {
        private ToolBarToggleButton another1;
        private ToolBarToggleButton another2;

        public TbtnViewItems(ToolBarToggleButton theAnother1, ToolBarToggleButton theAnother2) {
            this.another1 = theAnother1;
            this.another2 = theAnother2;
        }

        public void actionPerformed(ActionEvent e) {
            if (!(e.getSource() instanceof ToolBarToggleButton)) {
                return;
            }
            ToolBarToggleButton pressed = (ToolBarToggleButton)e.getSource();
            if (!this.another1.isSelected() && !this.another2.isSelected()) {
                pressed.setSelected(true);
                return;
            }
            CalendarToolBar.this.typesToggle.setShowAppointments(CalendarToolBar.this.tbtnShowAppointments.isSelected());
            CalendarToolBar.this.typesToggle.setShowNotes(CalendarToolBar.this.tbtnShowNotes.isSelected());
            CalendarToolBar.this.typesToggle.setShowTasks(CalendarToolBar.this.tbtnShowTasks.isSelected());
            if (CalendarToolBar.this.displaySettings != null) {
                GWCalendarUtils.setShowCalendarItems(CalendarToolBar.this.tbtnShowAppointments.isSelected(), CalendarToolBar.this.tbtnShowTasks.isSelected(), CalendarToolBar.this.tbtnShowNotes.isSelected(), CalendarToolBar.this.displaySettings);
            }
        }
    }

    private class BtnCalendarType
    extends AbstractAction {
        PropertiesViewListItem item;

        public BtnCalendarType(PropertiesViewListItem theItem) {
            this.item = theItem;
        }

        public void actionPerformed(ActionEvent e) {
            GWCalendarController gwCalendarController = ControlsUtils.getParentGWCalendarController(CalendarToolBar.this.getController());
            assert (gwCalendarController != null);
            CalendarToolBar.this.calendarViewTypeType = this.item.getView();
            if (this.item.getView() == CalendarViewType.DAILY) {
                CalendarToolBar.this.typesToggle = CalendarToolBar.this.typesToggleDaily;
                if (((GWCalendar)gwCalendarController.getMVCView()).getViewsToggleType() == CalendarViewType.DAILY) {
                    if (CalendarToolBar.this.itemAndItemListInfoDaylyView != null) {
                        gwCalendarController.itemSelected((IItem)CalendarToolBar.this.itemAndItemListInfoDaylyView.getItem().getNativeItem());
                    } else {
                        gwCalendarController.itemSelected(null);
                    }
                }
            } else if (this.item.getView() == CalendarViewType.WEEKLY) {
                CalendarToolBar.this.typesToggle = CalendarToolBar.this.typesToggleWeekly;
                if (((GWCalendar)gwCalendarController.getMVCView()).getViewsToggleType() == CalendarViewType.WEEKLY) {
                    if (CalendarToolBar.this.itemAndItemListInfoWeeklyView != null) {
                        gwCalendarController.itemSelected((IItem)CalendarToolBar.this.itemAndItemListInfoWeeklyView.getItem().getNativeItem());
                    } else {
                        gwCalendarController.itemSelected(null);
                    }
                }
            } else if (this.item.getView() == CalendarViewType.MONTHLY) {
                CalendarToolBar.this.typesToggle = CalendarToolBar.this.typesToggleMonthly;
            } else if (this.item.getView() == CalendarViewType.YEARLY) {
                CalendarToolBar.this.typesToggle = CalendarToolBar.this.typesToggleYearly;
            }
            CalendarToolBar.this.tbtnShowAppointments.setSelected(CalendarToolBar.this.typesToggle.isShowAppointments());
            CalendarToolBar.this.tbtnShowNotes.setSelected(CalendarToolBar.this.typesToggle.isShowNotes());
            CalendarToolBar.this.tbtnShowTasks.setSelected(CalendarToolBar.this.typesToggle.isShowTasks());
            CalendarToolBar.this.viewsToggle.setType(this.item);
            if (CalendarToolBar.this.view == 0) {
                CalendarToolBar.this.changeSimpleButtons();
            }
            if (this.item.getView() == CalendarViewType.MONTHLY) {
                gwCalendarController.itemSelected(null);
            } else if (this.item.getView() == CalendarViewType.YEARLY) {
                gwCalendarController.itemSelected(null);
            }
        }
    }

    private class ChangeSelectedDay
    extends AbstractAction {
        private int dayShift = 0;

        public ChangeSelectedDay(int theDayShift) {
            this.dayShift = theDayShift;
        }

        public void actionPerformed(ActionEvent e) {
            switch (this.dayShift) {
                case -1: {
                    CalendarToolBar.this.currentDay.add(5, -1);
                    break;
                }
                case 1: {
                    CalendarToolBar.this.currentDay.add(5, 1);
                    break;
                }
                case -7: {
                    CalendarToolBar.this.currentDay.add(5, -7);
                    break;
                }
                case 7: {
                    CalendarToolBar.this.currentDay.add(5, 7);
                    break;
                }
                case -31: {
                    CalendarToolBar.this.currentDay.add(2, -1);
                    break;
                }
                case 31: {
                    CalendarToolBar.this.currentDay.add(2, 1);
                    break;
                }
                case -365: {
                    CalendarToolBar.this.currentDay.add(1, -1);
                    break;
                }
                case 365: {
                    CalendarToolBar.this.currentDay.add(1, 1);
                }
            }
            Command command = new Command(70, CalendarToolBar.this.currentDay);
            command.setAttribute((Object)AttributeKey.CALENDAR, ControlsUtils.getParentGWCalendarController(CalendarToolBar.this.getController()));
            CalendarToolBar.this.getController().processCommand(command);
        }

        public void setDayShift(int theDayShift) {
            this.dayShift = theDayShift;
        }
    }
}

