/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes;

import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarPopup;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.ActiveHourLabelsPanelController;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.HourLabel;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.HourLabelsPanel;
import com.novell.gw.jclient.application.controls.gwcomponent.GWMouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.border.Border;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActiveHourLabelsPanel
extends HourLabelsPanel
implements MVCView<ActiveHourLabelsPanelController, Date> {
    private ActiveHourLabelsPanelController controller;
    private Calendar day;
    private ArrayList<HourLabel> hourLabels;

    public ActiveHourLabelsPanel(Border theBorder, MVCController theParentController, boolean alternate) {
        super(theBorder, alternate);
        this.controller = new ActiveHourLabelsPanelController(this, theParentController);
        this.adjustSelectedHours(GWCalendarUtils.getToday().getTime());
    }

    public ActiveHourLabelsPanel(Border theBorder, MVCController theParentController) {
        this(theBorder, theParentController, false);
    }

    @Override
    protected void init() {
        this.hourLabels = new ArrayList();
        this.day = GWCalendarUtils.getToday();
    }

    @Override
    public void setController(ActiveHourLabelsPanelController theController) {
        this.controller = theController;
    }

    @Override
    public ActiveHourLabelsPanelController getController() {
        return this.controller;
    }

    @Override
    public void setMVCModel(Date model) {
        Calendar gc = GWCalendarUtils.getTodayWithoutTimeFraction();
        gc.setTime(model);
        this.buildUI(gc);
        this.adjustSelectedHours(model);
    }

    @Override
    protected void buildUI(Calendar gc) {
        this.hourLabels = new ArrayList();
        super.buildUI(gc);
        this.validate();
    }

    public void reBuild() {
        this.buildUI();
    }

    private void adjustSelectedHours(Date theDate) {
        if (this.alternateTimeZoneUsed) {
            return;
        }
        this.day.setTime(theDate);
        int selectedHour = this.day.get(11);
        boolean firstHalf = this.day.get(12) < 30;
        int nSize = this.hourLabels.size();
        for (int i = 0; i < nSize; ++i) {
            HourLabel hourLabel = this.hourLabels.get(i);
            hourLabel.setSelected(i == selectedHour, firstHalf);
        }
    }

    @Override
    public Date getMVCModel() {
        return null;
    }

    @Override
    protected JComponent getLabel(Calendar gc, DateFormat theTimeFormat) {
        HourLabel hourLabel = new HourLabel(gc.getTime(), this.getBackground(), GWCalendarUtils.getTimeZone(this.alternateTimeZoneUsed));
        hourLabel.addMouseListener(new PopupHoursLabelMouseAdapter());
        this.hourLabels.add(hourLabel);
        return hourLabel;
    }

    private class PopupHoursLabelMouseAdapter
    extends GWMouseAdapter {
        private PopupHoursLabelMouseAdapter() {
        }

        public void showPopup(MouseEvent e) {
            HourLabel l = (HourLabel)e.getSource();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(l.getTime());
            calendar.add(13, -ActiveHourLabelsPanel.this.secOffset);
            GWCalendarPopup menu = new GWCalendarPopup("Appointment", calendar.getTime(), ActiveHourLabelsPanel.this.controller);
            menu.show(l, e.getX(), e.getY());
            ActiveHourLabelsPanel.this.controller.processCommand(new Command(70, calendar));
        }
    }
}

