/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes;

import com.appframework.ActionList;
import com.appframework.AppAction;
import com.appframework.level.LevelManager;
import com.appframework.mvc.MVCController;
import com.appframework.selection.SelectionManagersFactory;
import com.appframework.utils.Day;
import com.appframework.utils.OS;
import com.appframework.utils.UIUtils;
import com.novell.gw.engine.DataStoreSettings;
import com.novell.gw.jclient.api.enums.AppointmentAcceptLevel;
import com.novell.gw.jclient.api.interfaces.IItem;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.api.interfaces.message.IAppointment;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.ActionNewPostedAppointment;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.ActiveItemLabel;
import com.novell.gw.jclient.application.controls.gwcalendar.AppointmentItemStatusLabel;
import com.novell.gw.jclient.application.controls.gwcalendar.DateAndTimeFormattingUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendar;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarController;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarPopup;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.TypingWindow;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.AcceptsDroppedCalendarItems;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.AppointmentParam;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.CalendarItemDragGestureListener;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.CalendarItemDropTargetListener;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.ColorConstants;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.DateWatchPanel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.plaf.PLAFChanger;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.items.AbstractCalendarItem;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.AppointmentItem;
import com.novell.gw.jclient.bl.om.items.ItemAndItemListInfo;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.peer.ComponentPeer;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppointmentPanel
extends DateWatchPanel
implements AcceptsDroppedCalendarItems {
    private static Logger logger = Logger.getLogger(AppointmentPanel.class);
    private static final int DEFAULT_TYPING_CONTROL_HEIGHT = 40;
    private static final int HEIGHT = 96;
    public static final int MAX_HOURS = 24;
    private static final int TIME_STEP = 15;
    public static final int QUARTER_LABEL_HEIGHT = PLAFChanger.getFontSize() - 3;
    public static final float PX_PER_MINUTE = (float)(QUARTER_LABEL_HEIGHT * 4) / 60.0f;
    float[] halfHourDash = new float[]{20.0f, 5.0f};
    private float[] quarterHourDash = new float[]{5.0f, 5.0f};
    public static final BasicStroke DEFAULT_LINE_STROKE = new BasicStroke(1.0f);
    private final BasicStroke CLOCK_LINE_STROKE = new BasicStroke(1.0f, 0, 0, 10.0f, this.quarterHourDash, 0.0f);
    public static final BasicStroke HOUR_LINE_STROKE = new BasicStroke(2.0f);
    private HashMap<Integer, AppointmentParam> hmApps;
    private BigInteger overlappedTimes = new BigInteger("0", 2);
    private int columnCount = 1;
    private ArrayList<ActiveItemLabel> appointments;
    private int clockPosition = -1;
    private LabelMouseClick labelClickListener;
    private Rectangle dragRect;
    private final Dimension min = new Dimension(5, QUARTER_LABEL_HEIGHT);
    private JComponent focusOwner;
    private Calendar day = GWCalendarUtils.getToday();
    private AppointmentAcceptLevel showAsLevel = AppointmentAcceptLevel.FREE;
    private int startTimeMinutes;
    private int endTimeMinutes;
    private boolean isWorkDay = false;
    private AbstractItem itemSel = null;

    public AppointmentPanel(MVCController theParentController, JComponent theFocusOwner) {
        super(theParentController);
        this.focusOwner = theFocusOwner;
        this.appointments = new ArrayList();
        this.labelClickListener = new LabelMouseClick();
        DataStoreSettings dataStoreSettings = GWCommandManager.getInstance(EngineCommandManager.getUserGuid()).getDataStoreSettings();
        this.startTimeMinutes = (Integer)dataStoreSettings.getCalendarWorkDayStartTime().getValue();
        this.endTimeMinutes = (Integer)dataStoreSettings.getCalendarWorkDayEndTime().getValue();
        if (this.endTimeMinutes == 0) {
            this.endTimeMinutes = 1440;
        }
        this.buildUI();
    }

    public void setWorkDay(boolean isWorkDay) {
        this.isWorkDay = isWorkDay;
    }

    private void buildUI() {
        this.setLayout(new GridBagLayout());
        this.setOpaque(false);
        this.setBackground(ColorConstants.clrDayBack);
        this.setPreferredSize(new Dimension(10, QUARTER_LABEL_HEIGHT * 96));
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.fill = 1;
        int i = 0;
        while (i < 96) {
            c.gridy = i++;
            OrientablePanel lbl = new OrientablePanel();
            lbl.setMinimumSize(this.min);
            lbl.setPreferredSize(this.min);
            lbl.setOpaque(false);
            this.add((Component)lbl, c);
        }
        this.hmApps = new HashMap();
        PanelMouseClick mouseListener = new PanelMouseClick();
        this.addMouseListener(mouseListener);
        this.setDropTarget(new DropTarget(this, 3, new CalendarItemDropTargetListener(this, this.getController())));
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
    }

    private void refresh(IItemList itemList) {
        this.updateAppointmentsHashMap(itemList);
        if (this.columnCount > 1) {
            this.defineAppointmentWidth();
        }
        boolean isVisible = this.isVisible();
        this.setLightVisible(false);
        this.removeAppointments();
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(0, 3, 0, 2);
        c.fill = 1;
        c.weightx = 1.0;
        Iterator<Integer> it = this.hmApps.keySet().iterator();
        boolean isViewIncorrect = false;
        while (it.hasNext()) {
            Integer key = it.next();
            AppointmentParam appointment = this.hmApps.get(key);
            c.gridx = key % 100 - 1;
            if (c.gridx > 20) {
                isViewIncorrect = true;
                continue;
            }
            c.gridy = key / 100;
            c.gridwidth = appointment.getWidth();
            AppointmentItemStatusLabel label = new AppointmentItemStatusLabel(true, new ItemAndItemListInfo(itemList, appointment.getAppointmentItem()), GWCalendarUtils.getShowAsLevelColor(appointment.getAppointmentItem().getShowAsLevel()), this.getController(), false);
            label.setMinimumSize(this.min);
            if (appointment.getAppointmentItem().equals(this.itemSel)) {
                label.setSelected(true);
                GWCalendarController gwCalendarController = ControlsUtils.getParentGWCalendarController(this.getController());
                assert (gwCalendarController != null);
                gwCalendarController.itemSelected((IItem)this.itemSel.getNativeItem());
            }
            label.setBorder(new LineBorder(Color.BLACK, 1));
            this.appointments.add(label);
            label.addMouseListener(this.labelClickListener);
            String userGuid = ControlsUtils.getUserGuid(this.getController());
            CalendarItemDragGestureListener dragListener = new CalendarItemDragGestureListener(label, userGuid);
            DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(label, 3, dragListener);
            c.gridheight = appointment.getGridHeigh();
            this.add((Component)label, c);
        }
        this.setLightVisible(isVisible);
        this.validate();
        this.repaint();
        if (isViewIncorrect) {
            String message = StringResources.TOO_MANY_APPOINTMENTS_SCHEDULED_FOR;
            JOptionPane.showMessageDialog(this, message);
        }
    }

    private void setLightVisible(boolean theVisible) {
        if (theVisible) {
            ComponentPeer peer = this.getPeer();
            if (peer != null) {
                peer.show();
            }
        } else {
            ComponentPeer peer = this.getPeer();
            if (peer != null) {
                peer.hide();
            }
        }
    }

    private void removeAppointments() {
        int size = this.appointments.size();
        for (int i = 0; i < size; ++i) {
            ActiveItemLabel label = this.appointments.get(i);
            LevelManager.release(label.getController().getLevel());
            this.remove(label);
        }
        this.appointments.clear();
    }

    private void updateAppointmentsHashMap(IItemList theItemList) {
        this.hmApps.clear();
        Calendar panelDate = GWCalendarUtils.getToday();
        panelDate.setTime(this.day.getTime());
        GWCalendarUtils.clearTime(panelDate);
        logger.debug((Object)("day to get appointments for: " + DateAndTimeFormattingUtils.calendarToLogString(this.day)));
        logger.debug((Object)("panelDate: " + DateAndTimeFormattingUtils.calendarToLogString(panelDate)));
        List<AbstractCalendarItem> appointments = GWCalendarUtils.getAppointments(theItemList, new Day(this.day));
        Vector<BigInteger> vColumnLook = new Vector<BigInteger>();
        int appointmentsCount = appointments.size();
        for (int j = 0; j < appointmentsCount; ++j) {
            AppointmentItem appointment = (AppointmentItem)appointments.get(j);
            int position = GWCalendarUtils.calculatePositionInDay(new Day(this.day), appointment.getStartGregorianCalendar(), 15);
            if (position == -2) {
                logger.warn((Object)("incorrect appt found, ignoting it: " + appointment));
            } else if (position == -1) {
                position = 0;
            }
            int end = GWCalendarUtils.calculatePositionInDay(new Day(this.day), appointment.getEndGregorianCalendar(), 15);
            if (end == -2) {
                end = 359;
            } else if (end == -1) {
                logger.warn((Object)("incorrect appt found, ignoting it: " + appointment));
            }
            int height = end - position;
            if (height == 0) {
                height = 1;
            } else if (height < 0) {
                throw new IllegalStateException("appointment '' has negative duration: " + height * 15);
            }
            this.updateColumnView(vColumnLook, position, height, appointment);
        }
        this.columnCount = vColumnLook.size();
        this.createOverlappedTimes(vColumnLook);
    }

    private void updateColumnView(Vector<BigInteger> theColumns, int theStartTimeMin, int theHeightMin, AppointmentItem theAppointment) {
        String col = "";
        for (int i = theStartTimeMin + theHeightMin; i > 0; --i) {
            col = i > theStartTimeMin ? col + "1" : col + "0";
        }
        BigInteger columnLook = new BigInteger(col, 2);
        BigInteger appLook = new BigInteger(col, 2);
        int numbers = theColumns.size();
        int x = 1;
        if (numbers == 0) {
            theColumns.add(columnLook);
        } else {
            boolean isTimeOverlapping = false;
            for (int k = 0; k < numbers; ++k) {
                BigInteger c = theColumns.get(k);
                if (columnLook.and(c).equals(BigInteger.ZERO)) {
                    theColumns.set(k, columnLook.or(c));
                    isTimeOverlapping = false;
                    x = k + 1;
                    break;
                }
                isTimeOverlapping = true;
            }
            if (isTimeOverlapping) {
                theColumns.add(columnLook);
                x = theColumns.size();
            }
        }
        AppointmentParam ap = new AppointmentParam(theAppointment, theHeightMin);
        ap.setLook(appLook);
        this.hmApps.put(theStartTimeMin * 100 + x, ap);
    }

    private void createOverlappedTimes(Vector<BigInteger> theColumnLook) {
        if (this.columnCount > 1) {
            this.overlappedTimes = BigInteger.ZERO;
            BigInteger test = BigInteger.ONE;
            for (int j = 0; j < 96; ++j) {
                int overlapCount = 0;
                for (int i = 0; i < this.columnCount; ++i) {
                    BigInteger bi = theColumnLook.get(i);
                    if (!(bi = bi.and(test)).equals(BigInteger.ZERO)) {
                        ++overlapCount;
                    }
                    if (overlapCount <= 1) continue;
                    this.overlappedTimes = this.overlappedTimes.or(test);
                    break;
                }
                test = test.shiftLeft(1);
            }
        }
    }

    private void defineAppointmentWidth() {
        for (Integer key : this.hmApps.keySet()) {
            AppointmentParam ap = this.hmApps.get(key);
            int anotherCounter = 1;
            for (Integer keyAnother : this.hmApps.keySet()) {
                if (key.intValue() == keyAnother.intValue()) continue;
                AppointmentParam apAnother = this.hmApps.get(keyAnother);
                if (ap.getLook().and(apAnother.getLook()).equals(BigInteger.ZERO)) continue;
                ++anotherCounter;
            }
            if (anotherCounter != true) continue;
            int width = this.columnCount / anotherCounter;
            ap.setWidth(width);
        }
    }

    public static Rectangle getWorkTimeRectangle() {
        DataStoreSettings dataStoreSettings = GWCommandManager.getInstance(EngineCommandManager.getUserGuid()).getDataStoreSettings();
        return new Rectangle(0, QUARTER_LABEL_HEIGHT * 4 * (Integer)dataStoreSettings.getCalendarWorkDayStartTime().getValue() / 60, 100, 300);
    }

    public HashMap<Integer, AppointmentParam> getAppointmentHashMap(IItemList theItemList) {
        this.updateAppointmentsHashMap(theItemList);
        return this.hmApps;
    }

    public int getAppointmentsColumns() {
        return this.columnCount;
    }

    public final BigInteger getOverlappedTimes() {
        return this.overlappedTimes;
    }

    public void refreshUIOptions() {
        DataStoreSettings dataStoreSettings = GWCommandManager.getInstance(EngineCommandManager.getUserGuid()).getDataStoreSettings();
        this.startTimeMinutes = (Integer)dataStoreSettings.getCalendarWorkDayStartTime().getValue();
        this.endTimeMinutes = (Integer)dataStoreSettings.getCalendarWorkDayEndTime().getValue();
        if (this.endTimeMinutes == 0) {
            this.endTimeMinutes = 1440;
        }
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)UIUtils.enableAntialiasing(g);
        this.drawDayColors(g2);
        this.drawHoursLines(g2);
        if (this.clockPosition >= 0) {
            g2.setStroke(this.CLOCK_LINE_STROKE);
            g2.setColor(Color.black);
            g2.drawLine(0, this.clockPosition, this.getWidth(), this.clockPosition);
            g2.setStroke(DEFAULT_LINE_STROKE);
        }
        this.drawHighlightedHourRow(g2);
        this.drawDragRect(g2);
        super.paint(g);
    }

    private void drawDayColors(Graphics2D g2) {
        int height = QUARTER_LABEL_HEIGHT * 4 * 24;
        g2.setColor(ColorConstants.clrDayBack);
        g2.fillRect(0, 0, this.getWidth(), height);
        if (this.isWorkDay) {
            int y = this.startTimeMinutes / 15 * QUARTER_LABEL_HEIGHT;
            height = QUARTER_LABEL_HEIGHT * (this.endTimeMinutes - this.startTimeMinutes) / 15;
            g2.setColor(GWCalendarUtils.getShowAsLevelColor(this.showAsLevel));
            g2.fillRect(0, y, this.getWidth(), height);
        }
    }

    private void drawHoursLines(Graphics2D g2) {
        for (int i = 0; i < 24; ++i) {
            this.drawHourLine(g2, i);
            this.drawHalfHourLine(g2, i);
        }
        this.drawHourLine(g2, 24);
        g2.setStroke(DEFAULT_LINE_STROKE);
    }

    private void drawHalfHourLine(Graphics2D g2, int theHour) {
        g2.setColor(ColorConstants.clrHalfHourBorder);
        g2.setStroke(DEFAULT_LINE_STROKE);
        g2.drawLine(0, QUARTER_LABEL_HEIGHT * (2 + 4 * theHour), this.getWidth(), QUARTER_LABEL_HEIGHT * (2 + 4 * theHour));
    }

    private void drawHourLine(Graphics2D g2, int theHour) {
        g2.setColor(ColorConstants.HEADER_BORDER_COLOR);
        g2.setStroke(HOUR_LINE_STROKE);
        g2.drawLine(0, QUARTER_LABEL_HEIGHT * 4 * theHour, this.getWidth(), QUARTER_LABEL_HEIGHT * 4 * theHour);
    }

    public void loadItemsForDate(Calendar date, IItemList theItemList) {
        if (theItemList != null) {
            this.showAsLevel = AppointmentPanel.getShowAsLevel(theItemList.getAllDayEvents(date.getTime()));
        }
        this.day = (Calendar)date.clone();
        this.adjustClock(-1);
        this.refresh(theItemList);
    }

    public void setItemSel(AbstractItem itemSel) {
        this.itemSel = itemSel;
    }

    private static AppointmentAcceptLevel getShowAsLevel(IItem[] allDayEvents) {
        AppointmentAcceptLevel result = AppointmentAcceptLevel.FREE;
        int nCount = allDayEvents.length;
        for (int i = 0; i < nCount; ++i) {
            IAppointment allDayEvent = (IAppointment)allDayEvents[i];
            AppointmentAcceptLevel showAsLevel = allDayEvent.getShowAsLevel();
            if (showAsLevel == AppointmentAcceptLevel.FREE || showAsLevel == AppointmentAcceptLevel.NONE) continue;
            result = showAsLevel;
        }
        return result;
    }

    public final Calendar getDay() {
        return this.day;
    }

    public void adjustClock(int theClockPosition) {
        this.clockPosition = theClockPosition;
        this.repaint();
    }

    public AppointmentItem getSelectedItem() {
        int nSize = this.appointments.size();
        for (int i = 0; i < nSize; ++i) {
            ActiveItemLabel label = this.appointments.get(i);
            if (!label.isSelected()) continue;
            return (AppointmentItem)label.getItem();
        }
        return null;
    }

    private void drawHighlightedHourRow(Graphics2D g2) {
        if (!GWCalendarUtils.isSameDate(this.day, this.getCurrentDate())) {
            return;
        }
        Rectangle hourRect = this.getCurrentHourRect();
        g2.setColor(Color.BLACK);
        g2.setStroke(HOUR_LINE_STROKE);
        g2.drawRect(hourRect.x, hourRect.y, hourRect.width, hourRect.height);
        g2.setStroke(DEFAULT_LINE_STROKE);
    }

    private Rectangle getCurrentHourRect() {
        Calendar date = this.getCurrentDate();
        int time = date.get(11) * 60 + date.get(12);
        int y = (int)((float)time * PX_PER_MINUTE);
        int nQLblHeight = QUARTER_LABEL_HEIGHT * 2;
        int qy = y / nQLblHeight;
        return new Rectangle(2, qy * nQLblHeight, this.getWidth() - 4, nQLblHeight - 2);
    }

    @Override
    public void setCurrentDate(Calendar date) {
        super.setCurrentDate(date);
        logger.debug((Object)("date: " + DateAndTimeFormattingUtils.calendarToLogString(date)));
        this.validateCurrentSelection();
        this.scrollRectToVisible(this.getCurrentHourRect());
        this.repaint();
    }

    private boolean needAdjustCurrentSelection() {
        if (!GWCalendarUtils.isSameDate(this.day, this.getCurrentDate()) || !this.focusOwner.isFocusOwner()) {
            return false;
        }
        AbstractItem currentItem = SelectionManagersFactory.getInstance().getManager(this.getController()).getItem();
        if (currentItem == null || !(currentItem instanceof AppointmentItem)) {
            return true;
        }
        AppointmentItem item = (AppointmentItem)currentItem;
        return !this.isInsideCurrentRect(item);
    }

    private boolean isInsideCurrentRect(AppointmentItem item) {
        long itemStartTime = item.getStartDate().getTime();
        long itemEndTime = item.getEndDate().getTime();
        long currentStartTime = this.getCurrentDate().getTimeInMillis();
        long currentEndTime = currentStartTime + 1800000L;
        return currentStartTime >= itemStartTime && currentStartTime <= itemEndTime || currentEndTime <= itemEndTime && currentEndTime >= itemStartTime;
    }

    private void validateCurrentSelection() {
        if (!this.needAdjustCurrentSelection()) {
            return;
        }
        int nSize = this.appointments.size();
        for (int i = 0; i < nSize; ++i) {
            ActiveItemLabel label = this.appointments.get(i);
            AbstractCalendarItem item = (AbstractCalendarItem)label.getItem();
            if (!this.isInsideCurrentRect((AppointmentItem)item)) continue;
            label.select();
            return;
        }
    }

    private void drawDragRect(Graphics2D g2) {
        if (this.dragRect == null) {
            return;
        }
        g2.setColor(Color.BLUE);
        g2.setStroke(HOUR_LINE_STROKE);
        g2.drawRect(this.dragRect.x, this.dragRect.y, this.dragRect.width, this.dragRect.height);
        g2.setStroke(DEFAULT_LINE_STROKE);
        g2.setColor(Color.BLACK);
    }

    private Calendar getDateAtPoint(Point thePoint) {
        int y = thePoint.y / (QUARTER_LABEL_HEIGHT * 2);
        if (y < 0) {
            return null;
        }
        Calendar gc = GWCalendarUtils.getToday();
        gc.setTime(this.day.getTime());
        GWCalendarUtils.clearTime(gc);
        gc.set(11, (y *= 1800000) / 3600000);
        gc.add(14, y % 3600000);
        return gc;
    }

    @Override
    public void highlightDragHours(Point theLocation, long theDurationInMinutes) {
        int x = 2;
        int y = theLocation.y;
        int w = this.getWidth() - 4;
        long dh = theDurationInMinutes / 15L * (long)QUARTER_LABEL_HEIGHT;
        int h = (int)dh - 2;
        this.dragRect = new Rectangle(x, y, w, h);
        Rectangle rect = new Rectangle(x, y - 20, w, h + 40);
        this.scrollRectToVisible(rect);
        this.repaint();
    }

    @Override
    public void clearHighlightDragHours() {
        this.dragRect = null;
        this.repaint();
    }

    @Override
    public boolean acceptsDraggableItem(AbstractItem item) {
        return item != null;
    }

    private void handleClick(Point point) {
        Calendar date = this.getDateAtPoint(point);
        this.adjustCurrentTime(date);
    }

    private JComponent getFocusOwner() {
        return this.focusOwner;
    }

    public void navigate(int field, int shift) {
        GWCalendarController gwCalendarController = ControlsUtils.getParentGWCalendarController(this.getController());
        assert (gwCalendarController != null);
        gwCalendarController.itemSelected(null);
        this.getCurrentDate().add(field, shift);
        this.adjustCurrentTime(this.getCurrentDate());
        this.scrollRectToVisible(this.getCurrentHourRect());
    }

    public void createItem() {
        ActionList aList = this.getController().getActionList();
        AppAction action = aList.getAction(ActionKey.NEW_POSTED_APPOINTMENT);
        ((ActionNewPostedAppointment)action).setSelectedDate(this.getCurrentDate().getTime());
        ((ActionNewPostedAppointment)action).setCalendarView(true);
        action.actionPerformed(null);
    }

    public void handleQuickCreateItem(char keyChar) {
        Rectangle currentHourRect = this.getCurrentHourRect();
        Point newLocation = new Point(currentHourRect.x, currentHourRect.y);
        SwingUtilities.convertPointToScreen(newLocation, this);
        Dimension newSize = new Dimension(currentHourRect.width, 40);
        TypingWindow.getInstance(SwingUtilities.windowForComponent(this)).show("Appointment", (Calendar)this.getCurrentDate().clone(), String.valueOf(keyChar), newLocation, newSize, this.getController());
    }

    @Override
    public final Date getDragDate() {
        if (this.dragRect != null) {
            return this.getDateAtPoint(new Point(this.dragRect.x, this.dragRect.y)).getTime();
        }
        return null;
    }

    private class PanelMouseClick
    extends MouseAdapter {
        private PanelMouseClick() {
        }

        public void mouseClicked(MouseEvent e) {
            if (OS.isDoubleClick(e)) {
                Date date = AppointmentPanel.this.getDateAtPoint(e.getPoint()).getTime();
                if (date == null) {
                    return;
                }
                GWCalendar.createNewCalendarItem("Appointment", date, AppointmentPanel.this.getController(), true);
            }
        }

        public void mouseReleased(MouseEvent e) {
            this.doPopup(e);
        }

        public void mousePressed(MouseEvent e) {
            if (!AppointmentPanel.this.getFocusOwner().isFocusOwner()) {
                AppointmentPanel.this.getFocusOwner().grabFocus();
            }
            GWCalendarController gwCalendarController = ControlsUtils.getParentGWCalendarController(AppointmentPanel.this.getController());
            assert (gwCalendarController != null);
            gwCalendarController.itemSelected(null);
            Point point = e.getPoint();
            AppointmentPanel.this.handleClick(point);
            this.doPopup(e);
        }

        private void doPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                Date date = AppointmentPanel.this.getDateAtPoint(e.getPoint()).getTime();
                if (date == null) {
                    return;
                }
                MVCController controller = AppointmentPanel.this.getController();
                GWCalendarPopup pop = new GWCalendarPopup("Appointment", date, controller);
                pop.show((Component)e.getSource(), e.getX(), e.getY());
            }
        }
    }

    private final class LabelMouseClick
    extends MouseAdapter {
        private LabelMouseClick() {
        }

        public void mousePressed(MouseEvent e) {
            if (!AppointmentPanel.this.isFocusOwner()) {
                AppointmentPanel.this.grabFocus();
            }
            Point point = e.getPoint();
            SwingUtilities.convertPointToScreen(point, (Component)e.getSource());
            SwingUtilities.convertPointFromScreen(point, AppointmentPanel.this);
            if (!AppointmentPanel.this.getFocusOwner().isFocusOwner()) {
                AppointmentPanel.this.getFocusOwner().grabFocus();
            }
            AppointmentPanel.this.handleClick(point);
        }
    }
}

