/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes;

import com.appframework.level.LevelManager;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.novell.gw.engine.DataStoreSettings;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.application.controls.gwcalendar.DateAndTimeFormattingUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.NavigateCreateItem;
import com.novell.gw.jclient.application.controls.gwcalendar.NavigationCreateItemKeyboardListener;
import com.novell.gw.jclient.application.controls.gwcalendar.daily.dailyview.DailyView;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.AppointmentPanel;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.ColorConstants;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.DateWatchPanel;
import com.novell.gw.jclient.application.controls.gwcalendar.weekly.weeklyview.WeeklyView;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.TimeInterval;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.Calendar;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import org.apache.log4j.Logger;

public class AppointmentsPanel
extends DateWatchPanel
implements NavigateCreateItem {
    public static final Logger logger = Logger.getLogger(AppointmentsPanel.class);
    private Point clockPosistion = new Point(-1, -1);
    private ArrayList<AppointmentPanel> appointments = new ArrayList();
    private ArrayList<Integer> workDays;
    private AbstractItem itemSel;

    public AppointmentsPanel(int size, MVCController theParentController, Calendar theCurrentDate) {
        super(theParentController);
        this.setLayout(new GridLayout(1, 0, 0, 0));
        logger.debug((Object)("theCurrentDate: " + DateAndTimeFormattingUtils.calendarToLogString(theCurrentDate)));
        this.setCurrentDate(theCurrentDate);
        this.setFocusable(true);
        this.addKeyListener(new NavigationCreateItemKeyboardListener(this));
        this.addComponentListener(new ClockAdjustmentListener());
        this.setWorkDays();
        for (int i = 0; i < size; ++i) {
            this.addPanel();
        }
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                if (AppointmentsPanel.this.getController().getParentController() != null) {
                    MVCView mvcView = AppointmentsPanel.this.getController().getParentController().getMVCView();
                    if (mvcView instanceof DailyView) {
                        ((DailyView)mvcView).setFocusedPanel(AppointmentsPanel.this);
                    } else if (mvcView instanceof WeeklyView) {
                        ((WeeklyView)mvcView).setFocusedPanel(AppointmentsPanel.this);
                    }
                }
            }
        });
    }

    private void setWorkDays() {
        DataStoreSettings dataStoreSettings = GWCommandManager.getInstance(EngineCommandManager.getUserGuid()).getDataStoreSettings();
        int mask = (Integer)dataStoreSettings.getCalendarWorkDays().getValue();
        this.workDays = new ArrayList();
        int m = 64;
        for (int i = 7; i > 0; --i) {
            if (mask / m == 1) {
                this.workDays.add(i);
                mask -= m;
            }
            m /= 2;
        }
    }

    public void addBox(IItemList theItemList) {
        IItemList itemList = theItemList;
        AppointmentPanel lastPanel = this.appointments.get(this.appointments.size() - 1);
        Calendar newDay = (Calendar)lastPanel.getDay().clone();
        newDay.add(5, 1);
        AppointmentPanel appPanel = this.addPanel();
        appPanel.loadItemsForDate(newDay, theItemList);
        appPanel.setWorkDay(this.workDays.contains(newDay.get(7)));
        this.validate();
        this.adjustClock();
    }

    private AppointmentPanel addPanel() {
        AppointmentPanel appPanel = new AppointmentPanel(this.getController(), this);
        appPanel.setBorder(new LineBorder(ColorConstants.HEADER_BORDER_COLOR, 1));
        this.appointments.add(appPanel);
        this.add(appPanel);
        return appPanel;
    }

    public void setItemSel(AbstractItem itemSel) {
        this.itemSel = itemSel;
    }

    public void removeBox() {
        if (this.appointments.size() >= 1) {
            AppointmentPanel panel = this.appointments.get(this.appointments.size() - 1);
            this.remove(panel);
            this.appointments.remove(panel);
            LevelManager.release(panel.getController().getLevel());
            this.validate();
            this.adjustClock();
        }
    }

    public AppointmentPanel getBox(Calendar theDate) {
        for (AppointmentPanel panel : this.appointments) {
            if (!GWCalendarUtils.isSameDate(panel.getDay(), theDate)) continue;
            return panel;
        }
        return null;
    }

    public void adjustClock() {
        AppointmentPanel panel = this.getBox(GWCalendarUtils.getToday());
        if (panel != null) {
            int y = GWCalendarUtils.getClockPosition();
            panel.adjustClock(y);
            this.clockPosistion.x = panel.getX();
            this.clockPosistion.y = y;
        } else {
            this.clockPosistion.x = -1;
            this.clockPosistion.y = -1;
        }
        this.repaint();
    }

    private void loadItemsForDate(Calendar gcStartDay, IItemList theItemList) {
        Calendar day = (Calendar)gcStartDay.clone();
        logger.debug((Object)("gcStartDay: " + DateAndTimeFormattingUtils.calendarToLogString(gcStartDay)));
        for (int i = 0; i < this.appointments.size(); ++i) {
            AppointmentPanel panel = this.appointments.get(i);
            panel.setItemSel(this.itemSel);
            panel.loadItemsForDate(day, theItemList);
            panel.setWorkDay(this.workDays.contains(day.get(7)));
            day.add(5, 1);
            panel.repaint();
        }
    }

    public void loadItemsForDate(Calendar gcStartDay, IItemList theItemList, TimeInterval theChangedInterval) {
        if (theChangedInterval == null) {
            this.loadItemsForDate(gcStartDay, theItemList);
        } else {
            Calendar day = (Calendar)gcStartDay.clone();
            int nSize = this.appointments.size();
            for (int i = 0; i < nSize; ++i) {
                AppointmentPanel panel = this.appointments.get(i);
                if (theChangedInterval.contains(day)) {
                    panel.setItemSel(this.itemSel);
                    panel.loadItemsForDate(day, theItemList);
                }
                panel.setWorkDay(this.workDays.contains(day.get(7)));
                day.add(5, 1);
            }
        }
    }

    public void refreshUIOptions() {
        this.setWorkDays();
        for (AppointmentPanel a : this.appointments) {
            a.refreshUIOptions();
            a.setWorkDay(this.workDays.contains(a.getDay().get(7)));
        }
    }

    public Rectangle getWorkTimeRectangle() {
        Rectangle rect = AppointmentPanel.getWorkTimeRectangle();
        return SwingUtilities.convertRectangle(this.appointments.get(0), rect, this);
    }

    private void navigate(int field, int shift) {
        Calendar date = this.getCurrentDate();
        AppointmentPanel appointmentPanel = this.getBox(date);
        if (appointmentPanel == null) {
            appointmentPanel = field == 1 || shift == 30 ? this.appointments.get(this.appointments.size() - 1) : this.appointments.get(0);
        }
        appointmentPanel.navigate(field, shift);
    }

    public void navigateUP() {
        this.navigate(12, -30);
    }

    public void navigateDOWN() {
        this.navigate(12, 30);
    }

    public void navigateLEFT() {
        this.navigate(5, -1);
    }

    public void navigateRIGHT() {
        this.navigate(5, 1);
    }

    public void createItem() {
        this.getBox(this.getCurrentDate()).createItem();
    }

    public void quickCreateItem(char thePressedChar) {
        this.getBox(this.getCurrentDate()).handleQuickCreateItem(thePressedChar);
    }

    private class ClockAdjustmentListener
    extends ComponentAdapter {
        private ClockAdjustmentListener() {
        }

        public void componentResized(ComponentEvent e) {
            AppointmentsPanel.this.adjustClock();
        }
    }
}

