/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes;

import com.novell.gw.jclient.application.controls.gwcalendar.DateAndTimeFormattingUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.ColorConstants;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.text.DateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class HourLabel
extends OrientablePanel {
    private Date time;
    private Color background;
    private TimeLabel lbHour;
    private TimeLabel lbAMPM;
    private TimeLabel min00;
    private TimeLabel min30;
    private TimeZone timeZone;
    private boolean showAmpmMarker = DateAndTimeFormattingUtils.isAmpmMarkerShown();

    public HourLabel(Date theTime, Color theBackground, TimeZone timeZone) {
        this.time = theTime;
        this.background = theBackground;
        this.timeZone = timeZone;
        this.buildUI();
    }

    Date getTime() {
        return this.time;
    }

    private void buildUI() {
        this.removeAll();
        this.setLayout(new GridLayout(0, 2));
        this.setBackground(this.background);
        JPanel hourPanel = new JPanel();
        hourPanel.setLayout(new BorderLayout());
        DateFormat hoursFormat = DateAndTimeFormattingUtils.getHoursFormat();
        hoursFormat.setTimeZone(this.timeZone);
        this.lbHour = new TimeLabel(hoursFormat.format(this.time));
        Font font = this.lbHour.getFont();
        this.lbHour.setFont(font.deriveFont(1, font.getSize() + 3));
        hourPanel.add((Component)this.lbHour, "Center");
        if (this.showAmpmMarker) {
            DateFormat dateFormat = DateAndTimeFormattingUtils.getDateFormat("aa");
            dateFormat.setTimeZone(this.timeZone);
            this.lbAMPM = new TimeLabel(dateFormat.format(this.time));
            font = this.lbAMPM.getFont();
            this.lbAMPM.setFont(font.deriveFont((float)(font.getSize() - 2)));
            hourPanel.add((Component)this.lbAMPM, "South");
        }
        this.add(hourPanel);
        JPanel minutesPanel = new JPanel();
        minutesPanel.setBorder(BorderFactory.createEmptyBorder());
        minutesPanel.setLayout(new GridLayout(2, 1));
        this.min00 = new TimeLabel(StringResources.ZERO_ZERO);
        minutesPanel.add(this.min00);
        this.min30 = new TimeLabel(StringResources.THREE_ZERO);
        minutesPanel.add(this.min30);
        this.add(minutesPanel);
    }

    public void setSelected(boolean selected, boolean firstHalf) {
        if (selected) {
            this.setBackground(ColorConstants.CURRENT_DAY_COLOR);
        } else {
            this.setBackground(this.background);
        }
        this.min00.setSelected(selected && firstHalf);
        this.min30.setSelected(selected && !firstHalf);
        this.lbHour.setSelected(selected);
        if (this.showAmpmMarker) {
            this.lbAMPM.setSelected(selected);
        }
    }

    private class TimeLabel
    extends OrientableLabel {
        public TimeLabel(String text) {
            super(text);
            this.setHorizontalAlignment(0);
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setBackground(HourLabel.this.background);
            this.setOpaque(true);
        }

        public void setSelected(boolean isSelected) {
            if (isSelected) {
                this.setBackground(ColorConstants.CURRENT_DAY_COLOR);
                this.setForeground(Color.WHITE);
            } else {
                this.setBackground(HourLabel.this.background);
                this.setForeground(Color.BLACK);
            }
        }
    }
}

