/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar.monthly.monthlyview;

import com.appframework.mvc.Command;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.BorderedCalendarItemPanel;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.CalendarItemPanelPopup;
import com.novell.gw.jclient.application.controls.gwcalendar.monthly.monthlyview.Glass;
import com.novell.gw.jclient.application.controls.gwcalendar.monthly.monthlyview.GlassPanelLayout;
import com.novell.gw.jclient.application.controls.gwcalendar.monthly.monthlyview.MonthlyView;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Calendar;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class GlassPanel
extends JLayeredPane {
    private JPanel panel;
    private Glass glass;
    private Calendar calendar = GWCalendarUtils.getToday();
    private CalendarItemPanelPopup popup;
    private MonthlyView view;
    private boolean isFocusListenerAdded = false;

    public GlassPanel(JPanel thePanel, CalendarItemPanelPopup thePopup, MonthlyView theView) {
        this.setFocusable(true);
        this.popup = thePopup;
        this.view = theView;
        this.setLayout(new GlassPanelLayout());
        this.panel = thePanel;
        this.add((Component)this.panel, "Center");
        this.setLayer(this.panel, DEFAULT_LAYER, 0);
        this.glass = new Glass();
        this.add((Component)this.glass, "Glass");
        this.setLayer(this.glass, MODAL_LAYER, 0);
        this.glass.addMouseMotionListener(new GlassPanelMouseHandler());
        this.popup.setFocusOwner(this);
        this.addKeyListener(new NavigationListener());
    }

    private void navigate(int field, int shift) {
        this.calendar.setTime(this.view.getCurrentDate());
        this.calendar.add(field, shift);
        this.view.getController().processCommand(new Command(70, this.calendar));
    }

    private BorderedCalendarItemPanel getPanel(MouseEvent e) {
        Point containerPoint = SwingUtilities.convertPoint(this.glass, e.getPoint(), this.panel);
        Component component = this.panel.getComponentAt(containerPoint);
        if (component instanceof BorderedCalendarItemPanel) {
            return (BorderedCalendarItemPanel)component;
        }
        return null;
    }

    private void setWindowDeactivateListener() {
        Window window;
        if (!this.isFocusListenerAdded && (window = SwingUtilities.getWindowAncestor(this)) instanceof JFrame) {
            JFrame frame = (JFrame)window;
            frame.addWindowListener(new CurrentWindowListener());
            this.isFocusListenerAdded = true;
        }
    }

    private class CurrentWindowListener
    extends WindowAdapter {
        private CurrentWindowListener() {
        }

        public void windowDeactivated(WindowEvent windowEvent) {
            GlassPanel.this.popup.close();
        }
    }

    private class NavigationListener
    extends KeyAdapter {
        private NavigationListener() {
        }

        public void keyPressed(KeyEvent e) {
            int keyCode = e.getKeyCode();
            switch (keyCode) {
                case 38: {
                    GlassPanel.this.navigate(5, -7);
                    break;
                }
                case 40: {
                    GlassPanel.this.navigate(5, 7);
                    break;
                }
                case 37: {
                    GlassPanel.this.navigate(5, -1);
                    break;
                }
                case 39: {
                    GlassPanel.this.navigate(5, 1);
                }
            }
        }
    }

    private class GlassPanelMouseHandler
    extends MouseMotionAdapter {
        private GlassPanelMouseHandler() {
        }

        public void mouseMoved(MouseEvent e) {
            BorderedCalendarItemPanel panel = GlassPanel.this.getPanel(e);
            if (panel == null) {
                return;
            }
            if (GlassPanel.this.popup.contens(panel)) {
                return;
            }
            GlassPanel.this.popup.close();
            Border border = panel.getBorder();
            int height = panel.getHeight();
            int width = panel.getWidth();
            Dimension dim = new Dimension(panel.getPreferredSize());
            if (dim.height < height) {
                dim.height = height;
            }
            if (dim.width < width) {
                dim.width = width;
            }
            BorderedCalendarItemPanel popupPanel = panel.getClone();
            popupPanel.setBorder(border);
            GlassPanel.this.setWindowDeactivateListener();
            GlassPanel.this.popup.setContentPanel(popupPanel);
            GlassPanel.this.popup.setMinimumSize(dim);
            GlassPanel.this.popup.setPreferredSize(dim);
            GlassPanel.this.popup.setSize(dim);
            if (SwingUtilities.getWindowAncestor(panel).isFocused()) {
                GlassPanel.this.popup.show(panel, 0, 0);
            }
        }
    }
}

