/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar;

import com.appframework.utils.Utils;
import com.novell.gw.jclient.application.controls.gwcalendar.DateAndTimeFormattingUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.ColorConstants;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.CalendarEvent;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.CalendarEventType;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.CalendarModelListener;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.DateVerifier;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.DayCell;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Calendar;
import org.apache.log4j.Logger;

public class CalendarModel {
    Logger logger = Logger.getLogger(CalendarModel.class);
    protected Calendar data;
    protected DayCell[] dayCells = new DayCell[42];
    private DayCell[] labelCells = new DayCell[7];
    private DayCell[] weekNumberCell = new DayCell[6];
    protected int firstDayOfWeek = CalendarModel.getFirstDayOfWeek();
    protected boolean highlightDays = CalendarModel.getHighlightDays();
    protected int numberOfWeekToDisplay;
    private ArrayList<CalendarModelListener> listeners = new ArrayList();
    protected String userGuid = null;
    private DateVerifier dateVerifier = null;
    private static int nextInstanceId = 0;
    private int instanceId = nextInstanceId++;

    public CalendarModel(Calendar date) {
        this(date, null);
    }

    public CalendarModel(Calendar date, String userGuid) {
        this.userGuid = userGuid;
        this.numberOfWeekToDisplay = CalendarModel.getNumberOfWeekToDisplay(date, this.firstDayOfWeek);
        this.setDate(date);
    }

    public void refreshUIOptions() {
        this.highlightDays = CalendarModel.getHighlightDays();
        this.firstDayOfWeek = CalendarModel.getFirstDayOfWeek();
        Calendar month = GWCalendarUtils.initCalendar(this.data);
        for (DayCell dayCell : this.dayCells) {
            month.add(5, 1);
            if (month.get(2) != this.data.get(2)) continue;
            if ((month.get(7) == 1 || month.get(7) == 7) && this.highlightDays) {
                dayCell.setForeground(ColorConstants.clrDaysHoly);
                continue;
            }
            dayCell.setForeground(ColorConstants.clrDaysWork);
        }
        month = GWCalendarUtils.initCalendar(this.data);
        for (DayCell labelCell : this.labelCells) {
            month.add(5, 1);
            labelCell.setForeground(ColorConstants.clrDaysWork);
            if (month.get(7) != 1 && month.get(7) != 7 || !this.highlightDays) continue;
            labelCell.setForeground(ColorConstants.clrDaysHoly);
        }
        this.numberOfWeekToDisplay = CalendarModel.getNumberOfWeekToDisplay(this.data, this.firstDayOfWeek);
        this.init();
    }

    protected void init() {
        Calendar calendar = (Calendar)this.data.clone();
        this.initLabelCells();
        this.initDayCells();
        this.initWeekNumberCells();
        assert (calendar.equals(this.data)) : "Calendar changed from " + DateAndTimeFormattingUtils.calendarToLogString(calendar) + " to " + DateAndTimeFormattingUtils.calendarToLogString(this.data);
    }

    private static int getNumberOfWeekToDisplay(Calendar calendar, int firstDayOfWeek) {
        int lastDays;
        Calendar cal = (Calendar)calendar.clone();
        cal.set(5, 1);
        int last = cal.getActualMaximum(5);
        int firstMonthDay = cal.get(7);
        int numberInFirstRow = (7 + (firstDayOfWeek + 1) - firstMonthDay) % 7;
        if (numberInFirstRow == 0) {
            numberInFirstRow = 7;
        }
        if ((lastDays = last - 21 - numberInFirstRow) == 0) {
            return 4;
        }
        if (lastDays <= 7 && lastDays > 0) {
            return 5;
        }
        if (lastDays <= 9 && lastDays >= 8) {
            return 6;
        }
        throw new IllegalArgumentException("incorrect data: " + lastDays);
    }

    private void initWeekNumberCells() {
        Calendar cal = (Calendar)this.data.clone();
        cal.set(5, 1);
        cal.setFirstDayOfWeek(this.firstDayOfWeek + 1);
        int minimalDaysInFirstWeek = this.firstDayOfWeek != 4 ? (this.firstDayOfWeek + 3) % 7 : this.firstDayOfWeek + 3;
        cal.setMinimalDaysInFirstWeek(minimalDaysInFirstWeek);
        for (int i = 0; i < this.getNumberOfWeekToDisplay(); ++i) {
            DayCell dayCell = new DayCell();
            dayCell.setText(String.valueOf(cal.get(3)));
            dayCell.setBold(false);
            this.weekNumberCell[i] = dayCell;
            this.data.getMaximum(3);
            cal.add(5, 7);
        }
    }

    int getNumberOfWeekToDisplay() {
        return this.numberOfWeekToDisplay;
    }

    protected void initDayCells() {
        Calendar month = GWCalendarUtils.initCalendar(this.data);
        int nSize = this.dayCells.length;
        int value = -1;
        for (int i = 0; i < nSize; ++i) {
            DayCell cell = new DayCell();
            cell.setIndex(i);
            this.dayCells[i] = cell;
            month.add(5, 1);
            if (month.get(2) != this.data.get(2)) continue;
            if (value == -1) {
                value = 1;
            }
            if ((month.get(7) == 1 || month.get(7) == 7) && this.highlightDays) {
                cell.setForeground(ColorConstants.clrDaysHoly);
            } else {
                cell.setForeground(ColorConstants.clrDaysWork);
            }
            String title = String.valueOf(month.get(5));
            cell.setText(title);
            cell.setTime(month);
        }
    }

    public static int getFirstDayOfWeek() {
        return (Integer)GWCommandManager.getInstance(EngineCommandManager.getUserGuid()).getDataStoreSettings().getMonthCalendarFirstDay().getValue();
    }

    public static boolean getHighlightDays() {
        return (Integer)GWCommandManager.getInstance(EngineCommandManager.getUserGuid()).getDataStoreSettings().getMonthCalendarHighlightDays().getValue() == 1;
    }

    private void initLabelCells() {
        int i;
        int nSize = this.labelCells.length;
        int firstDayOfWeekl = CalendarModel.getFirstDayOfWeek();
        DayCell[] labelCells = new DayCell[nSize];
        for (i = 0; i < nSize; ++i) {
            int x = i;
            if (x >= 7) {
                x %= 7;
            }
            DayCell cell = new DayCell();
            cell.setIndex(i);
            cell.setText(GWCalendarUtils.dayShortestNames[x]);
            cell.setForeground(ColorConstants.clrDaysWork);
            if (this.highlightDays && (i == 0 || i == 6)) {
                cell.setForeground(ColorConstants.clrDaysHoly);
            }
            labelCells[i] = cell;
        }
        for (i = 0; i < nSize; ++i) {
            this.labelCells[i] = labelCells[firstDayOfWeekl];
            if (firstDayOfWeekl == 6) {
                firstDayOfWeekl = 0;
                continue;
            }
            ++firstDayOfWeekl;
        }
    }

    DayCell getLabelCell(int index) {
        return this.labelCells[index];
    }

    DayCell getDayCell(int index) {
        return this.dayCells[index];
    }

    DayCell getWeekNumberCell(int index) {
        return this.weekNumberCell[index];
    }

    DayCell getDayCell(Point point) {
        for (DayCell cell : this.dayCells) {
            if (!cell.contains(point)) continue;
            return cell;
        }
        return null;
    }

    int size() {
        return this.dayCells.length;
    }

    DayCell getFirstCell() {
        int i = 0;
        DayCell cell = this.dayCells[i];
        while (cell.getTime() == null) {
            cell = this.dayCells[++i];
        }
        return cell;
    }

    DayCell getLastCell() {
        int i = this.dayCells.length - 1;
        DayCell cell = this.dayCells[i];
        while (cell.getTime() == null) {
            cell = this.dayCells[--i];
        }
        return cell;
    }

    DayCell getCurrentCell() {
        for (DayCell cell : this.dayCells) {
            Calendar cellTime = cell.getTime();
            if (cellTime == null || !GWCalendarUtils.isSameDate(this.data, cellTime)) continue;
            return cell;
        }
        return null;
    }

    void removeModelListener(CalendarModelListener listener) {
        this.listeners.remove(listener);
    }

    void addModelListener(CalendarModelListener listener) {
        this.listeners.add(listener);
    }

    protected void fireModelChenged(CalendarEvent e) {
        for (CalendarModelListener listener : this.listeners) {
            listener.modelChanged(e);
        }
    }

    Calendar getDate() {
        return (Calendar)this.data.clone();
    }

    public DateVerifier getDateVerifier() {
        return this.dateVerifier;
    }

    public void setDateVerifier(DateVerifier dateVerifier) {
        this.dateVerifier = dateVerifier;
    }

    protected void setDate(Calendar date) {
        this.setDate(date, null);
    }

    protected void setDate(Calendar date, CalendarEventType eventType) {
        assert (date != null) : "date is null";
        if (Utils.areObjectsNullsOrEqual(this.data, date) && !CalendarEventType.SELECT.equals((Object)eventType)) {
            this.logger.debug((Object)("same data and non-SELECT type, suppressing event (" + this + ')'));
            return;
        }
        if (this.dateVerifier != null) {
            date = this.dateVerifier.verify(date);
        }
        int changeMask = GWCalendarUtils.getChangeMask(this.data, date);
        if (this.data == null) {
            this.data = (Calendar)date.clone();
        } else {
            this.data.setTime(date.getTime());
        }
        CalendarEvent e = new CalendarEvent(changeMask, date, eventType);
        if (e.isMonthChanged() || e.isYearChanged()) {
            this.init();
        }
        this.fireModelChenged(e);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append('[');
        builder.append("instanceId=");
        builder.append(this.instanceId);
        builder.append(']');
        return builder.toString();
    }
}

