/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar;

import com.appframework.mvc.GlobalCommand;
import com.appframework.mvc.MVCController;
import com.novell.gw.engine.DataStoreSettings;
import com.novell.gw.jclient.application.controls.gwcalendar.ActiveTypesToggle;
import com.novell.gw.jclient.application.controls.gwcalendar.CalendarScrollPane;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarPopup;
import com.novell.gw.jclient.application.controls.gwcalendar.LabelFocusListener;
import com.novell.gw.jclient.application.controls.gwcalendar.ToolBarProperties.PropertiesViewList;
import com.novell.gw.jclient.application.controls.gwcalendar.ToolBarProperties.PropertiesViewListItem;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.HourLabelsPanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.frames.calendar.FrameCalendar;
import com.novell.gw.jclient.application.frames.calendar.FrameCalendarActionList;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.options.DateTimeOptions;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalendarUtils {
    public static JComponent createLeftCaptionAndScrollPane(JComponent component, ImageIcon theImageIcon, MVCController controller, String theItemType, boolean showTimeZonelabels) {
        return CalendarUtils.createLeftCaptionAndScrollPane(component, theImageIcon, null, controller, theItemType, showTimeZonelabels);
    }

    public static JComponent createLeftCaptionAndScrollPane(JComponent component, ImageIcon theImageIcon, Border theLeftCaptionBorder, MVCController controller, String theItemType, boolean showTimeZonelabels) {
        OrientablePanel result = new OrientablePanel(new BorderLayout());
        result.setBorder(BorderFactory.createEmptyBorder());
        CalendarScrollPane sp = new CalendarScrollPane(component, 22, 31);
        sp.setMinimumSize(new Dimension(10, 10));
        sp.setBorder(BorderFactory.createEmptyBorder());
        result.add((Component)sp, "Center");
        OrientableLabel lbl = new OrientableLabel(theImageIcon);
        lbl.setBorder(theLeftCaptionBorder != null ? theLeftCaptionBorder : BorderFactory.createEmptyBorder());
        DateTimeOptions dateTimeOptions = OptionManager.getInstance().getDateTimeOptions();
        int width = HourLabelsPanel.getPanelWidth();
        if (ActiveTypesToggle.getInstance() != null && ActiveTypesToggle.getInstance().isShowAlternateTimeZone()) {
            width += width;
            if (showTimeZonelabels) {
                JPanel pnlTitle = new JPanel(new GridLayout(1, 2));
                OrientableLabel lblTitle = new OrientableLabel(dateTimeOptions.getAlternateTimeZoneLabel());
                lblTitle.setHorizontalAlignment(0);
                pnlTitle.add(lblTitle);
                lblTitle = new OrientableLabel(dateTimeOptions.getWorkstationTimeZoneLabel());
                lblTitle.setHorizontalAlignment(0);
                pnlTitle.add(lblTitle);
                lbl.setLayout(new BorderLayout());
                lbl.add((Component)pnlTitle, "South");
                lbl.setVerticalAlignment(1);
                lbl.setBorder(BorderFactory.createCompoundBorder(lbl.getBorder(), new EmptyBorder(5, 0, 0, 0)));
            }
        } else if (showTimeZonelabels) {
            OrientableLabel lblTitle = new OrientableLabel(dateTimeOptions.getWorkstationTimeZoneLabel());
            lblTitle.setHorizontalAlignment(0);
            lbl.setLayout(new BorderLayout());
            lbl.add((Component)lblTitle, "South");
            lbl.setVerticalAlignment(1);
            lbl.setBorder(BorderFactory.createCompoundBorder(lbl.getBorder(), new EmptyBorder(5, 0, 0, 0)));
        }
        lbl.setMinimumSize(new Dimension(width, 0));
        lbl.setPreferredSize(new Dimension(width, 30));
        result.add((Component)lbl, "Before");
        component.addFocusListener(new LabelFocusListener(lbl));
        result.setBackground(lbl.getBackground());
        result.addMouseListener(new CalendarPopupAdapter(theItemType, controller));
        return result;
    }

    public static ArrayList<Integer> getHighlightDays() {
        DataStoreSettings dataStoreSettings = GWCommandManager.getInstance(EngineCommandManager.getUserGuid()).getDataStoreSettings();
        ArrayList<Integer> highlightDays = new ArrayList<Integer>();
        int mask = (Integer)dataStoreSettings.getMonthCalendarHighlightDays().getValue();
        int m = 64;
        for (int i = 0; i < 7; ++i) {
            if (mask / m == 1) {
                mask -= m;
                highlightDays.add(CalendarUtils.getDayOfWeek(m));
            }
            m /= 2;
        }
        return highlightDays;
    }

    public static void showCalendarFrame(String userGUID, Date date) throws GWCommandException {
        PropertiesViewListItem calendarType = PropertiesViewList.getItemTypesList().get(0);
        FrameCalendar frame = new FrameCalendar(date, (AbstractFolder)GWCommandManager.getInstance(userGUID).getCalendarFolder(), userGUID, calendarType);
        frame.showMe();
        GlobalCommand command = new GlobalCommand(480, frame);
        ((FrameCalendarActionList)frame.getController()).processCommand(command);
    }

    private static int getDayOfWeek(int mask) {
        int dayOfWeek = -1;
        if (mask == 1) {
            dayOfWeek = 1;
        } else if (mask == 2) {
            dayOfWeek = 2;
        } else if (mask == 4) {
            dayOfWeek = 3;
        } else if (mask == 8) {
            dayOfWeek = 4;
        } else if (mask == 16) {
            dayOfWeek = 5;
        } else if (mask == 32) {
            dayOfWeek = 6;
        } else if (mask == 64) {
            dayOfWeek = 7;
        }
        return dayOfWeek;
    }

    public static int getFirstDayOfWeek() {
        DataStoreSettings dataStoreSettings = GWCommandManager.getInstance(EngineCommandManager.getUserGuid()).getDataStoreSettings();
        return (Integer)dataStoreSettings.getMonthCalendarFirstDay().getValue();
    }

    private static class CalendarPopupAdapter
    extends MouseAdapter {
        private String itemType;
        private MVCController controller;

        public CalendarPopupAdapter(String theItemType, MVCController theController) {
            this.itemType = theItemType;
            this.controller = theController;
        }

        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.showPopup(e);
            }
        }

        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.showPopup(e);
            }
        }

        private void showPopup(MouseEvent e) {
            GWCalendarPopup menu = new GWCalendarPopup(this.itemType, this.controller);
            menu.show((Component)e.getSource(), e.getX(), e.getY());
        }
    }
}

