/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar.weekly.weeklyview;

import com.novell.gw.jclient.application.controls.gwcalendar.CalendarView;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.ColorConstants;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.DayLabelsPanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.options.OptionManager;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.util.Calendar;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.border.Border;
import org.apache.log4j.Logger;

public class DayHeaderPanel
extends OrientablePanel {
    private static Logger logger = Logger.getLogger(DayLabelsPanel.class);
    protected Border labelBorder;
    private Calendar gcCurrentDay = GWCalendarUtils.getToday();
    private Calendar gcStartDay = GWCalendarUtils.getToday();
    private DayLabelContainerAdapter dayLabelContainerAdapter;
    private boolean highlightDays;

    public DayHeaderPanel(int theDaysCount, boolean highlightDays) {
        super(new GridLayout(1, 0, 0, 0));
        this.highlightDays = highlightDays;
        this.init();
        this.dayLabelContainerAdapter = new DayLabelContainerAdapter();
        this.setDaysCount(theDaysCount);
        this.setPreferredSize(CalendarView.HEADER_LABEL_SIZE);
        this.addComponentListener(new DayLabelComponentAdapter());
    }

    protected void init() {
        this.labelBorder = BorderFactory.createLineBorder(ColorConstants.HEADER_BORDER_COLOR);
    }

    public void setPreferredSize(Dimension preferredSize) {
        super.setPreferredSize(preferredSize);
        super.setMinimumSize(preferredSize);
    }

    public void setTitles(Date theStartDay, Date theCurrentDay) {
        this.gcStartDay.setTime(theStartDay);
        if (theCurrentDay == null) {
            this.gcCurrentDay.setTime(new Date(0L));
        } else {
            this.gcCurrentDay.setTime(theCurrentDay);
        }
        Calendar day = GWCalendarUtils.getToday();
        day.setTime(theStartDay);
        boolean isShort = this.isShortTitle();
        int nCount = this.getComponentCount();
        for (int i = 0; i < nCount; ++i) {
            JLabel lbl = this.getLabel(i);
            if (lbl == null) {
                return;
            }
            this.setTextToLabel(lbl, day, isShort);
            day.add(5, 1);
        }
    }

    public void setHighlightDays(boolean highlightDays) {
        this.highlightDays = highlightDays;
        this.setTitles(this.gcStartDay.getTime(), this.gcCurrentDay.getTime());
    }

    protected JLabel getLabel(int i) {
        return (JLabel)this.getComponent(i);
    }

    private boolean isShortTitle() {
        boolean isShort = false;
        StringBuilder str = new StringBuilder("Mon 23/12/04");
        Graphics g = this.getGraphics();
        if (g != null && g.getFontMetrics().getStringBounds(str.toString(), g).getWidth() > (double)(this.getWidth() / this.getComponentCount() - 10)) {
            isShort = true;
        }
        return isShort;
    }

    protected void setTextToLabel(JLabel lbl, Calendar day, boolean isShortText) {
        if (GWCalendarUtils.isSameDate(day, this.gcCurrentDay)) {
            lbl.setBackground(ColorConstants.CURRENT_DAY_COLOR);
            lbl.setForeground(Color.white);
        } else {
            if (GWCalendarUtils.isSameDate(day, GWCalendarUtils.getToday())) {
                lbl.setBackground(ColorConstants.TODAY_COLOR);
            } else {
                lbl.setBackground(this.getBackground());
            }
            lbl.setForeground(Color.black);
        }
        if ((day.get(7) == 1 || day.get(7) == 7) && this.highlightDays) {
            lbl.setForeground(ColorConstants.clrDaysHoly);
        }
        lbl.setText(OptionManager.getInstance().getDateTimeOptions().getDayHeaderPanelString(day.getTime()));
    }

    public void addLabel() {
        OrientableLabel lblDay = new OrientableLabel(" ");
        lblDay.setHorizontalAlignment(0);
        lblDay.setBorder(this.labelBorder);
        lblDay.setOpaque(true);
        this.add(lblDay);
    }

    public void removeLabel() {
        if (this.getComponentCount() < 1) {
            return;
        }
        this.remove(this.getComponentCount() - 1);
        this.validate();
    }

    public void setDaysCount(int theDaysCount) {
        this.removeContainerListener(this.dayLabelContainerAdapter);
        this.removeAll();
        for (int i = 0; i < theDaysCount; ++i) {
            this.addLabel();
        }
        this.addContainerListener(this.dayLabelContainerAdapter);
    }

    private class DayLabelComponentAdapter
    extends ComponentAdapter {
        private DayLabelComponentAdapter() {
        }

        public void componentResized(ComponentEvent e) {
            DayHeaderPanel.this.setTitles(DayHeaderPanel.this.gcStartDay.getTime(), DayHeaderPanel.this.gcCurrentDay.getTime());
        }
    }

    private class DayLabelContainerAdapter
    extends ContainerAdapter {
        private DayLabelContainerAdapter() {
        }

        public void componentAdded(ContainerEvent e) {
            DayHeaderPanel.this.setTitles(DayHeaderPanel.this.gcStartDay.getTime(), DayHeaderPanel.this.gcCurrentDay.getTime());
        }

        public void componentRemoved(ContainerEvent e) {
            DayHeaderPanel.this.setTitles(DayHeaderPanel.this.gcStartDay.getTime(), DayHeaderPanel.this.gcCurrentDay.getTime());
        }
    }
}

