/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar.yearlycalendar;

import com.appframework.utils.Utils;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.ColorConstants;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.CalendarEvent;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.CalendarModel;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.DayCell;
import java.util.Calendar;
import java.util.HashMap;

class StaticCalendarModel
extends CalendarModel {
    private HashMap<String, Calendar> busyDates;
    private IItemList itemList = null;

    StaticCalendarModel(Calendar theDate, String userGuid, IItemList itemList) {
        super(theDate, userGuid);
        this.itemList = itemList;
    }

    protected void setDate(Calendar theDate) {
        int changeMask = GWCalendarUtils.getChangeMask(this.data, theDate);
        if (this.data == null) {
            this.data = (Calendar)theDate.clone();
            this.init();
        } else {
            this.data.setTime(theDate.getTime());
        }
        CalendarEvent e = new CalendarEvent(changeMask, theDate);
        this.fireModelChenged(e);
    }

    void forceInitBusyDays() {
        this.busyDates = null;
        this.initBusyDates();
    }

    private void initBusyDates() {
        if (this.itemList == null) {
            return;
        }
        int monthSize = this.data.getActualMaximum(5);
        this.busyDates = new HashMap(monthSize);
        int iBusyDays = this.itemList.getMonthBusyDays(null, this.data.get(1), this.data.get(2));
        if (iBusyDays == 0) {
            return;
        }
        Calendar gc = GWCalendarUtils.getToday();
        gc.setTime(this.data.getTime());
        gc.set(5, 1);
        gc.set(11, 0);
        gc.set(12, 0);
        int iBit = 1;
        for (int i = 0; i < monthSize; ++i) {
            if ((iBit & iBusyDays) != 0) {
                this.busyDates.put(GWCalendarUtils.calendarToString(gc), gc);
            }
            gc.add(5, 1);
            iBit <<= 1;
        }
    }

    protected void initDayCells() {
        this.initBusyDates();
        int currentMONTH = this.data.get(2);
        Calendar month = GWCalendarUtils.initCalendar(this.data);
        for (int i = 0; i < this.dayCells.length; ++i) {
            DayCell cell = new DayCell();
            cell.setIndex(i);
            this.dayCells[i] = cell;
            month.add(5, 1);
            if (month.get(2) != currentMONTH) continue;
            if ((month.get(7) == 1 || month.get(7) == 7) && this.highlightDays) {
                cell.setForeground(ColorConstants.clrDaysHoly);
            } else {
                cell.setForeground(ColorConstants.clrDaysWork);
            }
            String title = String.valueOf(month.get(5));
            cell.setText(title);
            cell.setTime(month);
            if (this.busyDates == null) continue;
            cell.setBold(this.busyDates.containsKey(GWCalendarUtils.calendarToString(month)));
        }
    }

    void validateBusyDays(IItemList itemList) {
        if (this.busyDates == null || !Utils.areObjectsNullsOrEqual(itemList, this.itemList)) {
            this.itemList = itemList;
            this.initBusyDates();
        }
        for (DayCell cell : this.dayCells) {
            Calendar time = cell.getTime();
            if (time == null) continue;
            cell.setBold(this.busyDates.containsKey(GWCalendarUtils.calendarToString(time)));
        }
    }
}

