/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcomponent;

import com.novell.gw.jclient.application.controls.gwcomponent.GWComponentClipboardAdapter;
import com.novell.gw.jclient.application.controls.gwcomponent.GWCutCopyPasteUndoable;
import com.novell.gw.jclient.application.controls.gwcomponent.GWPopupMenu;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.text.JTextComponent;

public class GWCutCopyPasteUndoPopup
extends GWPopupMenu {
    private GWCutCopyPasteUndoable cutCopyPasteUndoable;
    private AbstractAction actionUndo;
    private AbstractAction actionCut;
    private AbstractAction actionCopy;
    private AbstractAction actionPaste;
    private AbstractAction actionDelete;
    private AbstractAction actionSelectAll;
    private static GWCutCopyPasteUndoPopup popupMenu;

    public GWCutCopyPasteUndoPopup() {
        this.init();
    }

    private void init() {
        this.actionUndo = new ActionUndo();
        this.actionCut = new ActionCut();
        this.actionCopy = new ActionCopy();
        this.actionPaste = new ActionPaste();
        this.actionDelete = new ActionDelete();
        this.actionSelectAll = new ActionSelectAll();
        this.add(new JMenuItem(this.actionUndo));
        this.add(new JMenuItem(this.actionCut));
        this.add(new JMenuItem(this.actionCopy));
        this.add(new JMenuItem(this.actionPaste));
        this.add(new JMenuItem(this.actionDelete));
        this.add(new JMenuItem(this.actionSelectAll));
    }

    public static GWCutCopyPasteUndoPopup getInstance() {
        if (popupMenu == null) {
            popupMenu = new GWCutCopyPasteUndoPopup();
        }
        return popupMenu;
    }

    private void updateTextComponent(JTextComponent textComponent) {
        if (!textComponent.hasFocus()) {
            textComponent.requestFocus();
            String text = textComponent.getText();
            textComponent.setCaretPosition(text == null ? 0 : text.length());
        }
    }

    public void show(JTextComponent textComponent, int x, int y) {
        this.cutCopyPasteUndoable = (GWCutCopyPasteUndoable)((Object)textComponent);
        this.updateTextComponent(textComponent);
        this.updateActions(this.cutCopyPasteUndoable);
        super.show(textComponent, x, y);
    }

    public void show(GWComponentClipboardAdapter adapter, int x, int y) {
        this.cutCopyPasteUndoable = adapter;
        this.updateTextComponent((JTextComponent)adapter.getTextComponent());
        this.updateActions(adapter);
        super.show((Component)adapter.getTextComponent(), x, y);
    }

    public GWCutCopyPasteUndoable getCutCopyPasteUndoable() {
        return this.cutCopyPasteUndoable;
    }

    private void updateActions(GWCutCopyPasteUndoable cutCopyPasteUndoable) {
        this.actionCut.setEnabled(cutCopyPasteUndoable.canCut());
        this.actionCopy.setEnabled(cutCopyPasteUndoable.canCopy());
        this.actionPaste.setEnabled(cutCopyPasteUndoable.canPaste());
        this.actionUndo.setEnabled(cutCopyPasteUndoable.canUndo());
        this.actionDelete.setEnabled(cutCopyPasteUndoable.canDelete());
    }

    public void copy() {
        if (this.cutCopyPasteUndoable != null) {
            this.cutCopyPasteUndoable.copy();
        }
    }

    public void paste() {
        if (this.cutCopyPasteUndoable != null) {
            this.cutCopyPasteUndoable.paste();
        }
    }

    public void cut() {
        if (this.cutCopyPasteUndoable != null) {
            this.cutCopyPasteUndoable.cut();
        }
    }

    public void selectAll() {
        this.cutCopyPasteUndoable.selectAll();
    }

    public void delete() {
        if (this.cutCopyPasteUndoable.canDelete()) {
            this.cutCopyPasteUndoable.delete();
        }
    }

    private class ActionSelectAll
    extends AbstractAction {
        public ActionSelectAll() {
            super(StringResources.SELECT_ALL);
        }

        public void actionPerformed(ActionEvent e) {
            GWCutCopyPasteUndoPopup.this.selectAll();
        }
    }

    private class ActionDelete
    extends AbstractAction {
        public ActionDelete() {
            super(StringResources.DELETE);
        }

        public void actionPerformed(ActionEvent e) {
            GWCutCopyPasteUndoPopup.this.delete();
        }
    }

    private class ActionUndo
    extends AbstractAction {
        public ActionUndo() {
            super(StringResources.UNDO);
        }

        public void actionPerformed(ActionEvent e) {
            GWCutCopyPasteUndoPopup.this.cutCopyPasteUndoable.undo();
        }
    }

    private class ActionPaste
    extends AbstractAction {
        public ActionPaste() {
            super(StringResources.PASTE);
        }

        public void actionPerformed(ActionEvent e) {
            GWCutCopyPasteUndoPopup.this.cutCopyPasteUndoable.paste();
        }
    }

    private class ActionCopy
    extends AbstractAction {
        public ActionCopy() {
            super(StringResources.COPY);
        }

        public void actionPerformed(ActionEvent e) {
            GWCutCopyPasteUndoPopup.this.cutCopyPasteUndoable.copy();
        }
    }

    private class ActionCut
    extends AbstractAction {
        public ActionCut() {
            super(StringResources.CUT);
        }

        public void actionPerformed(ActionEvent e) {
            GWCutCopyPasteUndoPopup.this.cutCopyPasteUndoable.cut();
        }
    }
}

