/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwtooltips;

import com.novell.gw.jclient.application.controls.gwcalendar.StaticItemLabel;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.UnfocusablePopupMenu;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.apache.log4j.Logger;

public class GWToolTipManager
extends MouseAdapter
implements MouseMotionListener {
    private static Logger logger = Logger.getLogger(GWToolTipManager.class);
    private static final GWToolTipManager instance = new GWToolTipManager();
    protected Timer enterTimer = new Timer(750, new insideTimerAction());
    protected Timer exitTimer;
    protected Timer insideTimer;
    String toolTipText;
    Point preferredLocation;
    JComponent insideComponent;
    MouseEvent mouseEvent;
    boolean showImmediately;
    transient Popup tipWindow;
    private Window window;
    JToolTip tip;
    private Rectangle popupRect = null;
    private Rectangle popupFrameRect = null;
    boolean enabled = true;
    private boolean tipShowing = false;
    private KeyStroke postTip;
    private KeyStroke hideTip;
    private Action postTipAction;
    private Action hideTipAction;
    private FocusListener focusChangeListener = null;
    private MouseMotionListener moveBeforeEnterListener = null;
    protected boolean lightWeightPopupEnabled = true;
    protected boolean heavyWeightPopupEnabled = false;

    public GWToolTipManager() {
        this.enterTimer.setRepeats(false);
        this.exitTimer = new Timer(500, new outsideTimerAction());
        this.exitTimer.setRepeats(false);
        this.insideTimer = new Timer(4000, new stillInsideTimerAction());
        this.insideTimer.setRepeats(false);
        this.postTip = KeyStroke.getKeyStroke(112, 2);
        this.postTipAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (GWToolTipManager.this.tipWindow != null) {
                    GWToolTipManager.this.hideTipWindow();
                    GWToolTipManager.this.insideComponent = null;
                } else {
                    GWToolTipManager.this.hideTipWindow();
                    GWToolTipManager.this.enterTimer.stop();
                    GWToolTipManager.this.exitTimer.stop();
                    GWToolTipManager.this.insideTimer.stop();
                    GWToolTipManager.this.insideComponent = (JComponent)e.getSource();
                    if (GWToolTipManager.this.insideComponent != null) {
                        GWToolTipManager.this.toolTipText = GWToolTipManager.this.insideComponent.getToolTipText();
                        GWToolTipManager.this.preferredLocation = new Point(10, GWToolTipManager.this.insideComponent.getHeight() + 10);
                        GWToolTipManager.this.showTipWindow();
                        if (GWToolTipManager.this.focusChangeListener == null) {
                            GWToolTipManager.this.focusChangeListener = GWToolTipManager.this.createFocusChangeListener();
                        }
                        GWToolTipManager.this.insideComponent.addFocusListener(GWToolTipManager.this.focusChangeListener);
                    }
                }
            }
        };
        this.hideTip = KeyStroke.getKeyStroke(27, 0);
        this.hideTipAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                GWToolTipManager.this.hideTipWindow();
                JComponent jc = (JComponent)e.getSource();
                jc.removeFocusListener(GWToolTipManager.this.focusChangeListener);
                GWToolTipManager.this.preferredLocation = null;
                GWToolTipManager.this.insideComponent = null;
            }

            public boolean isEnabled() {
                return GWToolTipManager.this.tipShowing;
            }
        };
        this.moveBeforeEnterListener = new MoveBeforeEnterListener();
    }

    public static GWToolTipManager getInstance() {
        return instance;
    }

    void showTipWindow() {
        logger.debug((Object)">>--- SHOW TOOLTIP ---<<<");
        if (this.insideComponent == null || !this.insideComponent.isShowing()) {
            return;
        }
        if (this.enabled) {
            Point screenLocation = this.insideComponent.getLocationOnScreen();
            Point location = new Point();
            Rectangle sBounds = this.insideComponent.getGraphicsConfiguration().getBounds();
            boolean leftToRight = true;
            this.hideTipWindow();
            this.tip = this.insideComponent.createToolTip();
            this.tip.setTipText(this.getToolTipText());
            Dimension size = this.tip.getPreferredSize();
            if (this.preferredLocation != null) {
                location.x = screenLocation.x + this.preferredLocation.x;
                location.y = screenLocation.y + this.preferredLocation.y;
            } else {
                location.x = screenLocation.x + this.mouseEvent.getX() + 1;
                location.y = screenLocation.y + this.mouseEvent.getY() + 20;
            }
            if (!this.heavyWeightPopupEnabled) {
                if (this.popupRect == null) {
                    this.popupRect = new Rectangle();
                }
                this.popupRect.setBounds(location.x, location.y, size.width, size.height);
                int y = this.getPopupFitHeight(this.popupRect, this.insideComponent);
                int x = this.getPopupFitWidth(this.popupRect, this.insideComponent);
                if (y > 0) {
                    location.y -= y;
                }
                if (x > 0) {
                    location.x -= x;
                }
                if (x > 0 && y > 0) {
                    location.x = screenLocation.x + this.mouseEvent.getX() - size.width - 2;
                    location.y = screenLocation.y + this.mouseEvent.getY() - size.height - 2;
                }
            }
            if (location.x < sBounds.x) {
                location.x = sBounds.x;
            } else if (location.x - sBounds.x + size.width > sBounds.width) {
                location.x = sBounds.x + Math.max(0, sBounds.width - size.width);
            }
            if (location.y < sBounds.y) {
                location.y = sBounds.y;
            } else if (location.y - sBounds.y + size.height > sBounds.height) {
                location.y = sBounds.y + Math.max(0, sBounds.height - size.height);
            }
            PopupFactory popupFactory = PopupFactory.getSharedInstance();
            this.tipWindow = this.insideComponent.getParent() instanceof UnfocusablePopupMenu ? popupFactory.getPopup(this.insideComponent.getParent(), this.tip, location.x, location.y) : popupFactory.getPopup(this.insideComponent, this.tip, location.x, location.y);
            this.tipWindow.show();
            Window componentWindow = SwingUtilities.windowForComponent(this.insideComponent);
            this.window = SwingUtilities.windowForComponent(this.tip);
            if (this.window != null && this.window != componentWindow) {
                this.window.addMouseListener(this);
            }
            this.insideTimer.start();
            this.tipShowing = true;
        }
    }

    public void hideTipWindow() {
        if (this.tipWindow != null) {
            if (this.window != null) {
                this.window.removeMouseListener(this);
                this.window = null;
            }
            this.tipWindow.hide();
            this.tipWindow = null;
            this.tipShowing = false;
            this.tip.getUI().uninstallUI(this.tip);
            this.tip = null;
            this.insideTimer.stop();
        }
    }

    public void mouseEntered(MouseEvent event) {
        this.initiateToolTip(event);
    }

    private String getToolTipText() {
        if (this.mouseEvent.getSource() instanceof StaticItemLabel) {
            StaticItemLabel label = (StaticItemLabel)this.mouseEvent.getSource();
            return label.getItem().getToolTipText();
        }
        return this.toolTipText;
    }

    private void initiateToolTip(MouseEvent event) {
        if (event.getSource() == this.window) {
            return;
        }
        JComponent component = (JComponent)event.getSource();
        component.removeMouseMotionListener(this.moveBeforeEnterListener);
        this.exitTimer.stop();
        Point location = event.getPoint();
        if (location.x < 0 || location.x >= component.getWidth() || location.y < 0 || location.y >= component.getHeight()) {
            return;
        }
        if (this.insideComponent != null) {
            this.enterTimer.stop();
        }
        component.addMouseMotionListener(this);
        boolean sameComponent = this.insideComponent == component;
        this.insideComponent = component;
        if (this.tipWindow != null) {
            this.mouseEvent = event;
            this.enterTimer.start();
        }
    }

    public void mouseExited(MouseEvent event) {
        Window win;
        boolean shouldHide = true;
        if (this.insideComponent == null) {
            // empty if block
        }
        if (this.window != null && event.getSource() == this.window) {
            Container insideComponentWindow = this.insideComponent.getTopLevelAncestor();
            Point location = event.getPoint();
            SwingUtilities.convertPointToScreen(location, this.window);
            if (insideComponentWindow != null) {
                location.x -= insideComponentWindow.getX();
                location.y -= insideComponentWindow.getY();
                location = SwingUtilities.convertPoint(null, location, this.insideComponent);
            }
            shouldHide = location.x < 0 || location.x >= this.insideComponent.getWidth() || location.y < 0 || location.y >= this.insideComponent.getHeight();
        } else if (event.getSource() == this.insideComponent && this.tipWindow != null && (win = SwingUtilities.getWindowAncestor(this.insideComponent)) != null) {
            Point location = SwingUtilities.convertPoint(this.insideComponent, event.getPoint(), win);
            Rectangle bounds = this.insideComponent.getTopLevelAncestor().getBounds();
            location.x += bounds.x;
            location.y += bounds.y;
            Point loc = new Point(0, 0);
            SwingUtilities.convertPointToScreen(loc, this.tip);
            bounds.x = loc.x;
            bounds.y = loc.y;
            bounds.width = this.tip.getWidth();
            bounds.height = this.tip.getHeight();
            shouldHide = location.x < bounds.x || location.x >= bounds.x + bounds.width || location.y < bounds.y || location.y >= bounds.y + bounds.height;
        }
        if (shouldHide) {
            this.enterTimer.stop();
            if (this.insideComponent != null) {
                this.insideComponent.removeMouseMotionListener(this);
            }
            this.insideComponent = null;
            this.toolTipText = null;
            this.mouseEvent = null;
            this.hideTipWindow();
            this.exitTimer.restart();
        }
    }

    public void stopToolTip() {
        this.hideTipWindow();
        this.enterTimer.stop();
        this.showImmediately = false;
        this.insideComponent = null;
        this.mouseEvent = null;
    }

    public void mousePressed(MouseEvent event) {
        this.hideTipWindow();
        this.enterTimer.stop();
        this.showImmediately = false;
        this.insideComponent = null;
        this.mouseEvent = null;
    }

    public void mouseDragged(MouseEvent event) {
    }

    public void mouseMoved(MouseEvent event) {
        if (this.tipShowing) {
            this.checkForTipChange(event);
        } else if (this.showImmediately) {
            JComponent component = (JComponent)event.getSource();
            this.toolTipText = component.getToolTipText(event);
            if (this.toolTipText != null) {
                this.preferredLocation = component.getToolTipLocation(event);
                this.mouseEvent = event;
                this.insideComponent = component;
                this.exitTimer.stop();
                this.showTipWindow();
            }
        } else {
            this.insideComponent = (JComponent)event.getSource();
            this.mouseEvent = event;
            this.toolTipText = null;
            this.enterTimer.restart();
        }
    }

    private void checkForTipChange(MouseEvent event) {
        JComponent component = (JComponent)event.getSource();
        String newText = component.getToolTipText(event);
        Point newPreferredLocation = component.getToolTipLocation(event);
        if (newText != null || newPreferredLocation != null) {
            this.mouseEvent = event;
            if ((newText != null && newText.equals(this.toolTipText) || newText == null) && (newPreferredLocation != null && newPreferredLocation.equals(this.preferredLocation) || newPreferredLocation == null)) {
                if (this.tipWindow != null) {
                    this.insideTimer.restart();
                } else {
                    this.enterTimer.restart();
                }
            } else {
                this.toolTipText = newText;
                this.preferredLocation = newPreferredLocation;
                if (this.showImmediately) {
                    this.hideTipWindow();
                    this.showTipWindow();
                    this.exitTimer.stop();
                } else {
                    this.enterTimer.restart();
                }
            }
        } else {
            this.toolTipText = null;
            this.preferredLocation = null;
            this.mouseEvent = null;
            this.insideComponent = null;
            this.hideTipWindow();
            this.enterTimer.stop();
            this.exitTimer.restart();
        }
    }

    static Frame frameForComponent(Component component) {
        while (!(component instanceof Frame)) {
            component = component.getParent();
        }
        return (Frame)component;
    }

    private FocusListener createFocusChangeListener() {
        return new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                GWToolTipManager.this.hideTipWindow();
                GWToolTipManager.this.insideComponent = null;
                JComponent c = (JComponent)evt.getSource();
                c.removeFocusListener(GWToolTipManager.this.focusChangeListener);
            }
        };
    }

    private int getPopupFitWidth(Rectangle popupRectInScreen, Component invoker) {
        if (invoker != null) {
            for (Container parent = invoker.getParent(); parent != null; parent = parent.getParent()) {
                if (parent instanceof JFrame || parent instanceof JDialog) {
                    return GWToolTipManager.getWidthAdjust(parent.getBounds(), popupRectInScreen);
                }
                if (!(parent instanceof JApplet) && !(parent instanceof JInternalFrame)) continue;
                if (this.popupFrameRect == null) {
                    this.popupFrameRect = new Rectangle();
                }
                Point p = parent.getLocationOnScreen();
                this.popupFrameRect.setBounds(p.x, p.y, parent.getBounds().width, parent.getBounds().height);
                return GWToolTipManager.getWidthAdjust(this.popupFrameRect, popupRectInScreen);
            }
        }
        return 0;
    }

    private int getPopupFitHeight(Rectangle popupRectInScreen, Component invoker) {
        if (invoker != null) {
            for (Container parent = invoker.getParent(); parent != null; parent = parent.getParent()) {
                if (parent instanceof JFrame || parent instanceof JDialog) {
                    return GWToolTipManager.getHeightAdjust(parent.getBounds(), popupRectInScreen);
                }
                if (!(parent instanceof JApplet) && !(parent instanceof JInternalFrame)) continue;
                if (this.popupFrameRect == null) {
                    this.popupFrameRect = new Rectangle();
                }
                Point p = parent.getLocationOnScreen();
                this.popupFrameRect.setBounds(p.x, p.y, parent.getBounds().width, parent.getBounds().height);
                return GWToolTipManager.getHeightAdjust(this.popupFrameRect, popupRectInScreen);
            }
        }
        return 0;
    }

    private static int getHeightAdjust(Rectangle a, Rectangle b) {
        if (b.y >= a.y && b.y + b.height <= a.y + a.height) {
            return 0;
        }
        return b.y + b.height - (a.y + a.height) + 5;
    }

    private static int getWidthAdjust(Rectangle a, Rectangle b) {
        if (b.x >= a.x && b.x + b.width <= a.x + a.width) {
            return 0;
        }
        return b.x + b.width - (a.x + a.width) + 5;
    }

    public void registerComponent(JComponent component) {
        component.removeMouseListener(this);
        component.addMouseListener(this);
        component.removeMouseMotionListener(this.moveBeforeEnterListener);
        component.addMouseMotionListener(this.moveBeforeEnterListener);
        InputMap inputMap = component.getInputMap(0);
        ActionMap actionMap = component.getActionMap();
        if (inputMap != null && actionMap != null) {
            inputMap.put(this.postTip, "postTip");
            inputMap.put(this.hideTip, "hideTip");
            actionMap.put("postTip", this.postTipAction);
            actionMap.put("hideTip", this.hideTipAction);
        }
    }

    public void unregisterComponent(JComponent component) {
        component.removeMouseListener(this);
        component.removeMouseMotionListener(this.moveBeforeEnterListener);
        InputMap inputMap = component.getInputMap(0);
        ActionMap actionMap = component.getActionMap();
        if (inputMap != null && actionMap != null) {
            inputMap.remove(this.postTip);
            inputMap.remove(this.hideTip);
            actionMap.remove("postTip");
            actionMap.remove("hideTip");
        }
    }

    public static void setToolTipText(JComponent theComponent, String text) {
        String oldText = theComponent.getToolTipText();
        theComponent.putClientProperty("ToolTipText", text);
        if (text != null) {
            if (oldText == null) {
                instance.registerComponent(theComponent);
            }
        } else {
            instance.unregisterComponent(theComponent);
        }
    }

    private class MoveBeforeEnterListener
    extends MouseMotionAdapter {
        private MoveBeforeEnterListener() {
        }

        public void mouseMoved(MouseEvent e) {
            GWToolTipManager.this.initiateToolTip(e);
        }
    }

    protected class stillInsideTimerAction
    implements ActionListener {
        protected stillInsideTimerAction() {
        }

        public void actionPerformed(ActionEvent e) {
            GWToolTipManager.this.hideTipWindow();
            GWToolTipManager.this.enterTimer.stop();
            GWToolTipManager.this.showImmediately = false;
            GWToolTipManager.this.insideComponent = null;
            GWToolTipManager.this.mouseEvent = null;
        }
    }

    protected class outsideTimerAction
    implements ActionListener {
        protected outsideTimerAction() {
        }

        public void actionPerformed(ActionEvent e) {
            GWToolTipManager.this.showImmediately = false;
        }
    }

    protected class insideTimerAction
    implements ActionListener {
        protected insideTimerAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (GWToolTipManager.this.insideComponent != null && GWToolTipManager.this.insideComponent.isShowing()) {
                if (GWToolTipManager.this.toolTipText == null && GWToolTipManager.this.mouseEvent != null) {
                    GWToolTipManager.this.toolTipText = GWToolTipManager.this.insideComponent.getToolTipText(GWToolTipManager.this.mouseEvent);
                    GWToolTipManager.this.preferredLocation = GWToolTipManager.this.insideComponent.getToolTipLocation(GWToolTipManager.this.mouseEvent);
                }
                if (GWToolTipManager.this.toolTipText != null) {
                    GWToolTipManager.this.showImmediately = false;
                    GWToolTipManager.this.showTipWindow();
                } else {
                    GWToolTipManager.this.insideComponent = null;
                    GWToolTipManager.this.toolTipText = null;
                    GWToolTipManager.this.preferredLocation = null;
                    GWToolTipManager.this.mouseEvent = null;
                    GWToolTipManager.this.hideTipWindow();
                }
            }
        }
    }
}

