/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwtooltips;

import com.appframework.utils.UIUtils;
import com.appframework.utils.Utils;
import com.novell.gw.jclient.application.controls.gwtooltips.GWToolTip;
import com.novell.gw.jclient.application.controls.gwtooltips.GWToolTipSet;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ToolTipUI;

public class GWToolTipUI
extends ToolTipUI {
    static GWToolTipUI SINGLETON = new GWToolTipUI();
    int inset = 1;
    private Font plainF;
    private FontMetrics plainFM;
    private Font boldF;
    private FontMetrics boldFM;
    private int fontH = 0;
    private int leftMargin = 0;
    private Dimension dimPreferred = new Dimension(200, 200);
    private int maxW = 0;

    private GWToolTipUI() {
    }

    public static void initialize() {
        String key = "ToolTipUI";
        Class<?> cls = SINGLETON.getClass();
        String name = cls.getName();
        UIManager.put(key, name);
        UIManager.put(name, cls);
    }

    public static ComponentUI createUI(JComponent c) {
        return SINGLETON;
    }

    public void installUI(JComponent c) {
        LookAndFeel.installColorsAndFont(c, "ToolTip.background", "ToolTip.foreground", "ToolTip.font");
        LookAndFeel.installBorder(c, "ToolTip.border");
    }

    public void uninstallUI(JComponent c) {
        LookAndFeel.uninstallBorder(c);
    }

    public Dimension getPreferredSize(JComponent c) {
        this.plainF = c.getFont();
        BufferedImage bi = new BufferedImage(100, 100, 6);
        Graphics g = bi.getGraphics();
        g.setFont(this.plainF);
        this.plainFM = g.getFontMetrics();
        this.boldF = Utils.deriveFont(this.plainF, 1);
        g.setFont(this.boldF);
        this.boldFM = g.getFontMetrics();
        this.fontH = this.plainFM.getHeight();
        this.maxW = 0;
        if (this.isMultiLine(c)) {
            return this.getMultilineSize(c);
        }
        String tipText = ((JToolTip)c).getTipText();
        if (tipText == null) {
            tipText = "";
        }
        int width = this.plainFM.stringWidth(tipText);
        this.dimPreferred = new Dimension(width + this.inset * 2, this.fontH + this.inset * 2);
        return this.dimPreferred;
    }

    public Dimension getMinimumSize(JComponent c) {
        return this.dimPreferred;
    }

    public Dimension getMaximumSize(JComponent c) {
        return this.dimPreferred;
    }

    private Dimension getMultilineSize(JComponent c) {
        int screenW = Toolkit.getDefaultToolkit().getScreenSize().width;
        String tipText = ((JToolTip)c).getTipText();
        if (tipText == null) {
            tipText = "";
        }
        int keyW = 0;
        int keyWMax = 0;
        int valueW = 0;
        int valueWMax = 0;
        ArrayList al = GWToolTipUI.getArrayList(c);
        int nSize = al.size();
        for (int i = 0; i < nSize; ++i) {
            GWToolTipSet set = (GWToolTipSet)al.get(i);
            keyW = this.boldFM.stringWidth(set.getKey());
            if (keyW > keyWMax) {
                keyWMax = keyW;
            }
            if ((valueW = this.plainFM.stringWidth(set.getValue())) <= valueWMax) continue;
            valueWMax = valueW;
        }
        int width = 0;
        int height = 0;
        width = keyWMax + valueWMax + this.inset * 4;
        if (width > screenW / 2) {
            width = screenW / 2;
        }
        this.leftMargin = keyWMax + this.inset * 3;
        BufferedImage bi = new BufferedImage(width - this.leftMargin - this.inset, 2000, 2);
        Graphics g = bi.getGraphics();
        g.setFont(this.plainF);
        nSize = al.size();
        for (int i = 0; i < nSize; ++i) {
            GWToolTipSet set = (GWToolTipSet)al.get(i);
            int y = this.drawStringIntoRect(g, set.getValue(), this.plainFM.getAscent() + this.inset, width, c.getBounds().width) + this.inset;
            height += y;
        }
        this.maxW += this.inset;
        this.dimPreferred = new Dimension(this.maxW, (height += this.inset) + 1);
        return this.dimPreferred;
    }

    public void paint(Graphics g, JComponent c) {
        int fontAscent = this.plainFM.getAscent();
        g.setFont(this.plainF);
        if (this.isMultiLine(c)) {
            g.setColor(Color.black);
            int h = fontAscent + this.inset;
            int y = 0;
            ArrayList al = GWToolTipUI.getArrayList(c);
            int nSize = al.size();
            for (int i = 0; i < nSize; ++i) {
                GWToolTipSet set = (GWToolTipSet)al.get(i);
                int x = this.inset;
                if (!UIUtils.getComponentOrientation().isLeftToRight()) {
                    x = c.getBounds().width - this.inset - SwingUtilities.computeStringWidth(this.boldFM, set.getKey());
                }
                g.drawString(set.getKey(), x, h);
                y = this.drawStringIntoRect(g, set.getValue(), h, this.maxW, c.getBounds().width);
                h = y + this.plainFM.getAscent() + this.inset * 2;
            }
        } else {
            String tipText = ((JToolTip)c).getTipText();
            if (tipText != null) {
                g.setColor(Color.black);
                g.drawString(tipText, this.inset, fontAscent + this.inset);
            }
        }
    }

    private int drawStringIntoRect(Graphics g, String theString, int theUpperMargin, int theWidth, int width) {
        int h = theUpperMargin;
        int w = this.leftMargin;
        int charW = this.plainFM.charWidth(' ');
        int strW = 0;
        StringTokenizer st = new StringTokenizer(theString);
        while (st.hasMoreTokens()) {
            String str = st.nextToken();
            strW = this.plainFM.stringWidth(str);
            if (w + strW >= theWidth) {
                h += this.plainFM.getHeight();
                w = this.leftMargin;
            }
            int x = UIUtils.getComponentOrientation().isLeftToRight() ? w : width - w - strW;
            g.drawString(str, x, h);
            if ((w += strW + charW) <= this.maxW) continue;
            this.maxW = w;
        }
        return h;
    }

    private static ArrayList getArrayList(JComponent c) {
        String tipText = ((JToolTip)c).getTipText();
        ArrayList al = GWToolTip.getArrayList(tipText);
        return al;
    }

    private boolean isMultiLine(JComponent c) {
        return !GWToolTipUI.getArrayList(c).isEmpty();
    }
}

