/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.inputverification;

import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.Toolkit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class TcpIpPortInputVerifier
extends InputVerifier {
    public static final int MAX_PORT_VALUE = 65536;
    public static final int MIN_PORT_VALUE = 0;
    public static final int DEFAULT_PORT_VALUE = 0;
    private static final Pattern PORT_PATTERN = Pattern.compile("\\d\\d?\\d?\\d?\\d?");

    public boolean verify(JComponent input) {
        int value;
        if (!(input instanceof JTextField)) {
            throw new IllegalArgumentException("unsupported component: " + (input == null ? "null" : input.getClass().getName()));
        }
        String text = ((JTextField)input).getText();
        Matcher matcher = PORT_PATTERN.matcher(text);
        boolean valid = matcher.matches();
        if (valid && ((value = Integer.parseInt(text)) < 0 || value > 65536)) {
            valid = false;
        }
        return valid;
    }

    public boolean shouldYieldFocus(JComponent input) {
        boolean valid = this.verify(input);
        if (!valid) {
            Toolkit.getDefaultToolkit().beep();
            if (input instanceof JTextField) {
                ((JTextField)input).setText(Integer.toString(0));
            }
            String message = StringResources.formatString(StringResources.ILLEGAL_TCP_IP_PORT_MESSAGE, Integer.toString(0), Integer.toString(65536));
            JOptionPane.showMessageDialog(input, message, StringResources.GROUPWISE, 2);
        }
        return true;
    }
}

