/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.itemedit;

import com.appframework.mvc.MVCController;
import com.appframework.utils.UIUtils;
import com.novell.gw.folder.FolderSharedEntry;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.itemedit.ComposeMode;
import com.novell.gw.jclient.application.controls.itemedit.FromComponent;
import com.novell.gw.jclient.application.controls.itemedit.ItemEditPanel;
import com.novell.gw.jclient.application.controls.itemedit.ItemEditPanelController;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.FocusManager;
import javax.swing.border.EmptyBorder;
import org.apache.log4j.Logger;

public class MailEditPanel
extends ItemEditPanel {
    private static Logger logger = Logger.getLogger(MailEditPanel.class);

    public MailEditPanel(MVCController theController, ComposeMode composeMode, boolean isModify) {
        super(theController, "ATTACHLIST_SPLITPOS", composeMode, isModify);
        this.focusTraversalPolicy = new MailFocusPolicy();
    }

    protected ItemEditPanelController createController(MVCController parentController) {
        return new ItemEditPanelController<MailEditPanel>(this, parentController);
    }

    public void setAccessRights(FolderSharedEntry sharedEntry, boolean itemExists) {
        boolean hasEditAccess = sharedEntry.getAccessRights().hasEditAccess();
        if (itemExists) {
            this.tfSubject.setEditable(hasEditAccess);
            this.messageEditor.setEditable(hasEditAccess);
        }
    }

    public AbstractItem getGWItemComposition() {
        this.newItem.setSubject(this.tfSubject.getText());
        return super.getGWItemComposition();
    }

    public void setGWItemComposition(AbstractItem theNewItem) {
        super.setGWItemComposition(theNewItem);
        this.setRecipients(this.newItem);
        this.tfSubject.setText(this.newItem.getSubject());
    }

    protected void build() {
        super.build();
        this.contentPanel.setLayout(new BorderLayout());
        this.compFrom = new FromComponent(this);
        this.lbTo = new JMnemonicLabel(StringResources.TO_C, this.tfTo);
        this.lbCC = new JMnemonicLabel(StringResources.CC_C, this.tfCC);
        this.lbBC = new JMnemonicLabel(StringResources.BC_C, this.tfBC);
        this.lbSubject = new JMnemonicLabel(StringResources.SUBJECT_C, this.tfSubject);
        OrientablePanel messagePanel = new OrientablePanel(new BorderLayout());
        messagePanel.setBorder(new EmptyBorder(10, 10, 0, 10));
        messagePanel.add((Component)this.messageEditor, "Center");
        OrientablePanel attachmentsPanel = new OrientablePanel(new BorderLayout());
        attachmentsPanel.setBorder(new EmptyBorder(0, 10, 0, 10));
        attachmentsPanel.add((Component)this.attachmentList, "Center");
        this.messageSplit.setBottomComponent(attachmentsPanel);
        this.messageSplit.setTopComponent(messagePanel);
        this.buildAddressPane();
        this.contentPanel.add((Component)this.messageSplit, "Center");
        this.contentPanel.add((Component)this.addressPane, "North");
    }

    private void buildAddressPane() {
        this.addressPane = new OrientablePanel(new GridBagLayout());
        this.addressPane.setBorder(new EmptyBorder(10, 10, 0, 10));
        this.addressPane.setComponentOrientation(UIUtils.getComponentOrientation());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 21;
        c.fill = 0;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(0, 0, 8, 10);
        this.addressPane.add((Component)this.compFrom, c);
        c.anchor = 10;
        c.fill = 2;
        c.gridx = 1;
        c.gridy = 0;
        c.insets = new Insets(0, 0, 8, 0);
        c.weightx = 1.0;
        this.addressPane.add((Component)this.tfFrom, c);
        c.gridx = 2;
        c.gridy = 0;
        c.insets = new Insets(0, 15, 8, 25);
        c.weightx = 0.0;
        this.addressPane.add((Component)this.lbCC, c);
        c.gridx = 3;
        c.gridy = 0;
        c.insets = new Insets(0, 0, 8, 0);
        c.weightx = 1.0;
        this.addressPane.add((Component)this.etcCC, c);
        c.anchor = 21;
        c.fill = 0;
        c.gridx = 0;
        c.gridy = 1;
        c.insets = new Insets(0, 0, 8, 10);
        c.weightx = 0.0;
        this.addressPane.add((Component)this.lbTo, c);
        c.anchor = 10;
        c.fill = 2;
        c.gridx = 1;
        c.gridy = 1;
        c.insets = new Insets(0, 0, 8, 0);
        c.weightx = 1.0;
        this.addressPane.add((Component)this.etcTo, c);
        c.gridx = 2;
        c.gridy = 1;
        c.insets = new Insets(0, 15, 8, 25);
        c.weightx = 0.0;
        this.addressPane.add((Component)this.lbBC, c);
        c.gridx = 3;
        c.gridy = 1;
        c.insets = new Insets(0, 0, 8, 0);
        c.weightx = 1.0;
        this.addressPane.add((Component)this.etcBC, c);
        c.anchor = 21;
        c.fill = 0;
        c.gridx = 0;
        c.gridy = 2;
        c.insets = new Insets(0, 0, 0, 10);
        c.ipadx = 0;
        c.weightx = 0.0;
        this.addressPane.add((Component)this.lbSubject, c);
        c.anchor = 10;
        c.fill = 2;
        c.gridx = 1;
        c.gridy = 2;
        c.gridwidth = 0;
        c.insets = new Insets(0, 0, 0, 0);
        c.weightx = 3.5;
        this.addressPane.add((Component)this.createEditableTextComponent(this.tfSubject), c);
    }

    private class MailFocusPolicy
    extends ItemEditPanel.ItemComposerTraversalPolicy {
        private MailFocusPolicy() {
        }

        public Component getComponentAfter(Container focusCycleRoot, Component component) {
            MailEditPanel view = MailEditPanel.this;
            Component focusOwner = FocusManager.getCurrentManager().getPermanentFocusOwner();
            if (!component.hasFocus()) {
                return focusOwner;
            }
            if (component.equals(view.tfTo) || component.equals(view.tfTo.getRecipientList())) {
                return view.tfSubject;
            }
            if (component.equals(view.tfSubject)) {
                return view.messageEditor.getComponent();
            }
            if (component.equals(MailEditPanel.this.messageEditor.getComponent())) {
                return view.attachmentList.getListContent();
            }
            if (component.equals(view.tfCC) || component.equals(view.tfCC.getRecipientList())) {
                return view.tfBC;
            }
            if (component.equals(view.tfBC) || component.equals(view.tfBC.getRecipientList())) {
                return view.tfTo;
            }
            return super.getComponentAfter(focusCycleRoot, component);
        }

        public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
            MailEditPanel view = MailEditPanel.this;
            if (aComponent.equals(view.tfTo)) {
                return view.tfBC;
            }
            if (aComponent.equals(view.tfBC)) {
                return view.tfCC;
            }
            if (ControlsUtils.isComponentInContainer(view.attachmentList, aComponent)) {
                return view.messageEditor.getComponent();
            }
            if (aComponent.equals(view.messageEditor.getComponent())) {
                return view.tfSubject;
            }
            if (aComponent.equals(view.tfSubject)) {
                return this.isPostedCompose ? view.attachmentList.getListContent() : view.tfTo;
            }
            return super.getComponentBefore(focusCycleRoot, aComponent);
        }

        public Component getDefaultComponent(Container focusCycleRoot) {
            return MailEditPanel.this.getComponentForFocus();
        }
    }
}

