/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.itemedit;

import com.appframework.mvc.MVCController;
import com.novell.gw.folder.FolderSharedEntry;
import com.novell.gw.jclient.api.interfaces.ab.IRecipient;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextField;
import com.novell.gw.jclient.application.controls.itemedit.ComposeMode;
import com.novell.gw.jclient.application.controls.itemedit.FromComponent;
import com.novell.gw.jclient.application.controls.itemedit.ItemEditPanel;
import com.novell.gw.jclient.application.controls.itemedit.ItemEditPanelController;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicCheckBox;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.PhoneItem;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.FocusManager;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class PhoneEditPanel
extends ItemEditPanel {
    private JCheckBox cbTelephoned;
    private JCheckBox cbWillCallAgain;
    private JCheckBox cbWantsToSeeYou;
    private JCheckBox cbUrgent;
    private JCheckBox cbPleaseCall;
    private JCheckBox cbReturnedYourCall;
    private JCheckBox cbCameToSeeYou;
    protected JLabel lbCaller;
    protected JLabel lbCompany;
    protected JLabel lbPhone;
    protected GWTextField tfCaller;
    protected GWTextField tfCompany;
    protected GWTextField tfPhone;
    private JPanel pnlWithCheckBoxes;

    public PhoneEditPanel(MVCController theParentController, ComposeMode composeMode, boolean isModify) {
        super(theParentController, "ATTACHLIST_SPLITPOS_PHONE_EDIT", composeMode, isModify);
        this.focusTraversalPolicy = new PhoneFocusPolicy();
    }

    protected ItemEditPanelController createController(MVCController parentController) {
        return new ItemEditPanelController<PhoneEditPanel>(this, parentController);
    }

    public AbstractItem getGWItemComposition() {
        PhoneItem phone = (PhoneItem)this.newItem;
        String sCaller = this.tfCaller.getText();
        String sPhone = this.tfPhone.getText();
        sCaller = sCaller == null ? "" : sCaller;
        sPhone = sPhone == null ? "" : sPhone;
        String sSubject = sCaller + ' ' + sPhone;
        if ((sSubject = sSubject.trim()).length() != 0) {
            phone.setSubject(sSubject);
        }
        phone.setCaller(sCaller);
        phone.setPhone(sPhone);
        phone.setCompany(this.tfCompany.getText());
        phone.setWantsToSeeYou(true);
        phone.setTelephoned(this.cbTelephoned.isSelected());
        phone.setWillCallAgain(this.cbWillCallAgain.isSelected());
        phone.setWantsToSeeYou(this.cbWantsToSeeYou.isSelected());
        phone.setUrgent(this.cbUrgent.isSelected());
        phone.setPleaseCall(this.cbPleaseCall.isSelected());
        phone.setReturnedYourCall(this.cbReturnedYourCall.isSelected());
        phone.setCameToSeeYou(this.cbCameToSeeYou.isSelected());
        return super.getGWItemComposition();
    }

    public void setGWItemComposition(AbstractItem newItem) {
        super.setGWItemComposition(newItem);
        PhoneItem phone = (PhoneItem)this.newItem;
        this.setRecipients(newItem);
        this.tfCaller.setText(phone.getCaller());
        this.tfCompany.setText(phone.getCompany());
        this.tfPhone.setText(phone.getPhone());
        this.cbTelephoned.setSelected(phone.isTelephoned());
        this.cbWillCallAgain.setSelected(phone.isWillCallAgain());
        this.cbWantsToSeeYou.setSelected(phone.isWantsToSeeYou());
        this.cbUrgent.setSelected(phone.isUrgent());
        this.cbPleaseCall.setSelected(phone.isPleaseCall());
        this.cbReturnedYourCall.setSelected(phone.isReturnedYourCall());
        this.cbCameToSeeYou.setSelected(phone.isCameToSeeYou());
    }

    public List getRecipientsList() {
        return this.tfTo.getRecipients();
    }

    public void setRecipients(AbstractItem newItem) {
        ArrayList<IRecipient> allRecipients = new ArrayList<IRecipient>();
        allRecipients.addAll(newItem.getToRecipients());
        allRecipients.addAll(newItem.getCcRecipients());
        allRecipients.addAll(newItem.getBcRecipients());
        this.tfTo.setRecipients(allRecipients);
    }

    protected void build() {
        super.build();
        this.contentPanel.setLayout(new BorderLayout());
        this.tfCaller = new GWTextField();
        this.tfCompany = new GWTextField();
        this.tfPhone = new GWTextField();
        this.compFrom = new FromComponent(this);
        this.lbTo = new JMnemonicLabel(StringResources.TO_C, this.tfTo);
        this.lbCaller = new JMnemonicLabel(StringResources.CALLER_C, this.tfCaller);
        this.lbCompany = new JMnemonicLabel(StringResources.COMPANY_C, this.tfCompany);
        this.lbPhone = new JMnemonicLabel(StringResources.PHONE_C, this.tfPhone);
        OrientablePanel messagePanel = new OrientablePanel();
        messagePanel.setLayout(new BorderLayout());
        messagePanel.setBorder(new EmptyBorder(10, 10, 0, 10));
        messagePanel.add((Component)this.messageEditor, "Center");
        OrientablePanel attachmentsPanel = new OrientablePanel();
        attachmentsPanel.setLayout(new BorderLayout());
        attachmentsPanel.setBorder(new EmptyBorder(0, 10, 0, 10));
        attachmentsPanel.add((Component)this.attachmentList, "Center");
        this.messageSplit.setBottomComponent(attachmentsPanel);
        this.messageSplit.setTopComponent(messagePanel);
        this.createAddressPanel();
        this.contentPanel.add((Component)this.messageSplit, "Center");
        this.contentPanel.add((Component)this.addressPane, "North");
    }

    private void createAddressPanel() {
        this.addressPane = new OrientablePanel(new GridBagLayout());
        this.addressPane.setBorder(new EmptyBorder(10, 10, 10, 10));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 21;
        c.gridy = 0;
        c.fill = 0;
        c.gridx = 0;
        c.insets = new Insets(0, 0, 8, 10);
        this.addressPane.add((Component)this.compFrom, c);
        c.fill = 2;
        c.gridx = 1;
        c.insets.right = 0;
        c.weightx = 1.0;
        this.addressPane.add((Component)this.tfFrom, c);
        ++c.gridy;
        c.fill = 0;
        c.gridx = 0;
        c.insets = new Insets(0, 0, 8, 10);
        c.weightx = 0.0;
        this.addressPane.add((Component)this.lbTo, c);
        c.fill = 2;
        c.gridx = 1;
        c.insets.right = 0;
        c.weightx = 1.0;
        this.addressPane.add((Component)this.etcTo, c);
        ++c.gridy;
        c.fill = 0;
        c.gridx = 0;
        c.insets = new Insets(0, 0, 8, 10);
        c.weightx = 0.0;
        this.addressPane.add((Component)this.lbCaller, c);
        c.fill = 2;
        c.gridx = 1;
        c.gridy = 2;
        c.insets = new Insets(0, 0, 8, 0);
        c.weightx = 1.0;
        this.addressPane.add((Component)this.createEditableTextComponent(this.tfCaller), c);
        ++c.gridy;
        c.fill = 0;
        c.gridx = 0;
        c.insets = new Insets(0, 0, 8, 10);
        c.weightx = 0.0;
        this.addressPane.add((Component)this.lbCompany, c);
        c.fill = 2;
        c.gridx = 1;
        c.insets = new Insets(0, 0, 8, 0);
        c.weightx = 1.0;
        this.addressPane.add((Component)this.createEditableTextComponent(this.tfCompany), c);
        ++c.gridy;
        c.fill = 0;
        c.gridx = 0;
        c.insets = new Insets(0, 0, 8, 10);
        c.weightx = 0.0;
        this.addressPane.add((Component)this.lbPhone, c);
        c.fill = 2;
        c.gridx = 1;
        c.insets = new Insets(0, 0, 8, 0);
        c.weightx = 1.0;
        this.addressPane.add((Component)this.createEditableTextComponent(this.tfPhone), c);
        this.createCheckBoxesPanel();
        c.fill = 2;
        c.gridx = 1;
        c.gridy = 5;
        c.insets = new Insets(0, 0, 0, 10);
        this.addressPane.add((Component)this.pnlWithCheckBoxes, c);
    }

    private void createCheckBoxesPanel() {
        this.cbTelephoned = new JMnemonicCheckBox(StringResources.TELEPHONED);
        this.cbPleaseCall = new JMnemonicCheckBox(StringResources.PLEASE_CALL);
        this.cbWillCallAgain = new JMnemonicCheckBox(StringResources.WILL_CALL_AGAIN);
        this.cbReturnedYourCall = new JMnemonicCheckBox(StringResources.RETURNED_YOUR_CALL);
        this.cbWantsToSeeYou = new JMnemonicCheckBox(StringResources.WANTS_TO_SEE_YOU);
        this.cbCameToSeeYou = new JMnemonicCheckBox(StringResources.CAME_TO_SEE_YOU);
        this.cbUrgent = new JMnemonicCheckBox(StringResources.URGENT);
        this.pnlWithCheckBoxes = new OrientablePanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.anchor = 21;
        c.gridx = 0;
        c.gridy = 0;
        this.pnlWithCheckBoxes.add((Component)this.cbTelephoned, c);
        c.gridx = 1;
        c.gridy = 0;
        this.pnlWithCheckBoxes.add((Component)this.cbPleaseCall, c);
        c.gridx = 2;
        c.gridy = 0;
        this.pnlWithCheckBoxes.add((Component)this.cbUrgent, c);
        c.gridx = 0;
        c.gridy = 1;
        this.pnlWithCheckBoxes.add((Component)this.cbWillCallAgain, c);
        c.gridx = 1;
        c.gridy = 1;
        this.pnlWithCheckBoxes.add((Component)this.cbReturnedYourCall, c);
        c.gridx = 0;
        c.gridy = 2;
        this.pnlWithCheckBoxes.add((Component)this.cbWantsToSeeYou, c);
        c.gridx = 1;
        c.gridy = 2;
        this.pnlWithCheckBoxes.add((Component)this.cbCameToSeeYou, c);
    }

    public void setAccessRights(FolderSharedEntry sharedEntry, boolean itemExists) {
        boolean hasEditAccess = sharedEntry.getAccessRights().hasEditAccess();
        if (itemExists) {
            this.tfSubject.setEditable(hasEditAccess);
            this.messageEditor.setEditable(hasEditAccess);
            this.tfCaller.setEditable(hasEditAccess);
            this.tfCompany.setEditable(hasEditAccess);
            this.tfPhone.setEditable(hasEditAccess);
            this.cbTelephoned.setEnabled(hasEditAccess);
            this.cbPleaseCall.setEnabled(hasEditAccess);
            this.cbWillCallAgain.setEnabled(hasEditAccess);
            this.cbReturnedYourCall.setEnabled(hasEditAccess);
            this.cbWantsToSeeYou.setEnabled(hasEditAccess);
            this.cbCameToSeeYou.setEnabled(hasEditAccess);
            this.cbUrgent.setEnabled(hasEditAccess);
        }
    }

    private class PhoneFocusPolicy
    extends ItemEditPanel.ItemComposerTraversalPolicy {
        private PhoneFocusPolicy() {
        }

        public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
            PhoneEditPanel view = PhoneEditPanel.this;
            Component focusOwner = FocusManager.getCurrentManager().getPermanentFocusOwner();
            if (!aComponent.hasFocus()) {
                return focusOwner;
            }
            if (aComponent.equals(view.cbCameToSeeYou)) {
                return view.messageEditor.getComponent();
            }
            if (aComponent.equals(PhoneEditPanel.this.messageEditor.getComponent())) {
                return view.attachmentList.getListContent();
            }
            return super.getComponentAfter(focusCycleRoot, aComponent);
        }

        public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
            if (ControlsUtils.isComponentInContainer(PhoneEditPanel.this.attachmentList, aComponent)) {
                return PhoneEditPanel.this.messageEditor.getComponent();
            }
            return super.getComponentBefore(focusCycleRoot, aComponent);
        }

        public Component getDefaultComponent(Container focusCycleRoot) {
            return PhoneEditPanel.this.getComponentForFocus();
        }
    }
}

