/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.itemlisttable;

import com.novell.gw.ab.AddressBookManager;
import com.novell.gw.jclient.api.interfaces.IColumnFieldInfo;
import com.novell.gw.jclient.api.interfaces.IViewDisplaySettings;
import com.novell.gw.jclient.api.interfaces.folder.IFolder;
import com.novell.gw.jclient.application.controls.itemlisttable.TableColumnType;
import com.novell.gw.jclient.application.controls.itemlisttable.level04.ItemListTableEmptyColumn;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableColumnsUtils {
    private static final Logger logger = Logger.getLogger(TableColumnsUtils.class);
    public static final int GROUP_HEADER_COLUMN_POSITION = 2;

    public static ItemListTableEmptyColumn createTableColumn(TableColumnType type) {
        ItemListTableEmptyColumn tableColumn = new ItemListTableEmptyColumn();
        tableColumn.setMaxWidth(type.getDefaultWidth());
        tableColumn.setPreferredWidth(type.getDefaultWidth());
        tableColumn.setColumnType(type);
        return tableColumn;
    }

    public static List<TableColumnType> getEmptyColumnsTypes(IFolder folder, IViewDisplaySettings viewDisplaySettings) {
        ArrayList<TableColumnType> columnTypes = new ArrayList<TableColumnType>();
        if (viewDisplaySettings != null && folder != null) {
            int viewMode = viewDisplaySettings.getViewMode();
            if (viewMode == 7) {
                columnTypes.add(TableColumnType.COLUMN_TASK_LIST);
            }
            columnTypes.add(TableColumnType.COLUMN_EMPTY);
            if (viewDisplaySettings.showGroupHeaders() && viewMode == 1) {
                columnTypes.add(TableColumnType.COLUMN_GROUP_HEADER);
            }
            columnTypes.add(TableColumnType.COLUMN_THREAD_CONTROL);
            columnTypes.add(TableColumnType.COLUMN_MAIN_ICON);
            if (folder.isContactsFolder()) {
                columnTypes.add(TableColumnType.COLUMN_EMPTY);
            } else {
                columnTypes.add(TableColumnType.COLUMN_ADDITIONAL_ICONS);
            }
        }
        return columnTypes;
    }

    public static int getColumnFieldID(IColumnFieldInfo columnFieldInfo, boolean isContacts) {
        int fieldID = columnFieldInfo.getFieldID();
        if (isContacts) {
            int value = 200;
            String column = columnFieldInfo.getName();
            for (int i = 0; i < value; ++i) {
                if (!AddressBookManager.getPropertyLabel((int)i).equals(column)) continue;
                fieldID = i;
                break;
            }
        }
        return fieldID;
    }
}

