/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.itemlisttable.lastlevel;

import com.novell.gw.jclient.api.interfaces.IColumnFieldInfo;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.api.interfaces.IViewDisplaySettings;
import com.novell.gw.jclient.api.interfaces.folder.IFolder;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.gwcomponent.GWPopupMenu;
import com.novell.gw.jclient.application.controls.itemlisttable.lastlevel.ItemListTable;
import com.novell.gw.jclient.application.controls.itemlisttable.lastlevel.ItemListTableController;
import com.novell.gw.jclient.application.controls.orientable.MenuItemFactory;
import com.novell.gw.jclient.application.dialogs.folderproperties.ColumnsDialog;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeaderPopupMenu
extends GWPopupMenu {
    private static Logger logger = Logger.getLogger(HeaderPopupMenu.class);
    private static HeaderPopupMenu headerPopupMenu;
    private static final int[] DEFAULT_ITEMS_COLUMNS;
    private static final int[] DEFAULT_CONTACTS_COLUMNS;
    private JMenuItem miSortAscending = MenuItemFactory.createCkeckBoxMenuItem(new ChangeSortingMenuItemAction(StringResources.SORT_ASCENDING));
    private JMenuItem miSortDescending = MenuItemFactory.createCkeckBoxMenuItem(new ChangeSortingMenuItemAction(StringResources.SORT_DESCENDING));
    private JMenuItem miSortTasklistAscending = MenuItemFactory.createMenuItem(new SortTasklistAction(StringResources.SORT_TASKLIST_ASCENDING));
    private JMenuItem miSortTasklistDescending = MenuItemFactory.createMenuItem(new SortTasklistAction(StringResources.SORT_TASKLIST_DESCENDING));
    private JMenuItem miMoreColumns = MenuItemFactory.createMenuItem(new MoreColumnsMenuItemAction(StringResources.MORE_COLUMNS));
    private JMenuItem miDeleteColumn = MenuItemFactory.createMenuItem(new DeleteColumnMenuItemAction(StringResources.DELETE));
    private IColumnFieldInfo[] allColumnFieldInfos;
    private int[] quickColumnsFildIDs;
    private List<IColumnFieldInfo> columnFieldInfos;
    private IColumnFieldInfo selectedColumnFieldInfo;
    private ItemListTable table;

    public IViewDisplaySettings getViewDisplaySettings() {
        return this.table.getViewDisplaySettings();
    }

    public ItemListTableController getController() {
        return this.table.getController();
    }

    public IFolder getFolder() {
        return this.table.getFolder();
    }

    public IItemList getItemList() {
        return this.table.getItemList();
    }

    public List<IColumnFieldInfo> getColumnFieldInfos() {
        if (this.columnFieldInfos == null) {
            this.columnFieldInfos = new ArrayList<IColumnFieldInfo>();
            this.columnFieldInfos.addAll(Arrays.asList(this.getViewDisplaySettings().getColumnAndSortInfo().getVisibleColumns()));
        }
        return this.columnFieldInfos;
    }

    public void show(Component invoker, Point location, ItemListTable table, int columnIndex) {
        this.columnFieldInfos = null;
        this.table = table;
        this.selectedColumnFieldInfo = table.getColumnModel().getColumnFieldInfoForColumn(columnIndex);
        this.initAllColumnsInfo(ControlsUtils.getUserGuid(table.getController()));
        this.rebuildMenu();
        this.setLocation(location);
        this.show(invoker, location.x, location.y);
    }

    private void initAllColumnsInfo(String userGuid) {
        boolean isContactsFolder = this.getFolder().isContactsFolder();
        this.allColumnFieldInfos = GWCommandManager.getInstance(userGuid).getCurrentDataStore().getDisplayColumnFields(isContactsFolder);
        this.quickColumnsFildIDs = isContactsFolder ? DEFAULT_CONTACTS_COLUMNS : DEFAULT_ITEMS_COLUMNS;
    }

    private IColumnFieldInfo[] getAllColumnFieldInfos() {
        return this.allColumnFieldInfos;
    }

    private void rebuildMenu() {
        this.removeAll();
        if (this.selectedColumnFieldInfo != null) {
            this.selectSortingMenuItems();
            if (this.getViewDisplaySettings().getViewMode() == 7) {
                if (!this.getItemList().hasTaskListItemsOnly()) {
                    this.add(this.miSortAscending);
                    this.add(this.miSortDescending);
                }
                this.add(this.miSortTasklistAscending);
                this.add(this.miSortTasklistDescending);
            } else {
                this.add(this.miSortAscending);
                this.add(this.miSortDescending);
            }
            this.addSeparator();
            if (this.getColumnFieldInfos().size() > 1) {
                this.add(this.miDeleteColumn);
                this.addSeparator();
            }
        }
        if (this.quickColumnsFildIDs.length > 0) {
            for (int quickColumnFieldID : this.quickColumnsFildIDs) {
                List<IColumnFieldInfo> columnFieldInfos = this.getColumnFieldInfos();
                boolean columnExist = HeaderPopupMenu.findColumnFieldInfoByID(columnFieldInfos.toArray(new IColumnFieldInfo[columnFieldInfos.size()]), quickColumnFieldID) != null;
                IColumnFieldInfo columnFieldInfo = HeaderPopupMenu.findColumnFieldInfoByID(this.getAllColumnFieldInfos(), quickColumnFieldID);
                if (columnExist || columnFieldInfo == null) continue;
                this.add(MenuItemFactory.createMenuItem(new QuickAddColumnMenuItemAction(columnFieldInfo)));
            }
            this.addSeparator();
        }
        this.add(this.miMoreColumns);
    }

    public static IColumnFieldInfo findColumnFieldInfoByID(IColumnFieldInfo[] columnFieldInfos, int fieldID) {
        for (IColumnFieldInfo columnFieldInfo : columnFieldInfos) {
            if (columnFieldInfo.getFieldID() != fieldID) continue;
            return columnFieldInfo;
        }
        return null;
    }

    private void selectSortingMenuItems() {
        if (this.selectedColumnFieldInfo != null) {
            this.miSortAscending.setSelected(this.selectedColumnFieldInfo.getSortOption() == 16);
            this.miSortDescending.setSelected(this.selectedColumnFieldInfo.getSortOption() == 17);
        }
    }

    public static HeaderPopupMenu getInstance() {
        if (headerPopupMenu == null) {
            headerPopupMenu = new HeaderPopupMenu();
        }
        return headerPopupMenu;
    }

    static {
        DEFAULT_ITEMS_COLUMNS = new int[]{44, 34, 220, 21, 61, 885, 88, 27, 35, 116, 97};
        DEFAULT_CONTACTS_COLUMNS = new int[]{422, 816, 50, 278, 279, 429, 88, 38, 355, 31};
    }

    private class DeleteColumnMenuItemAction
    extends AbstractAction {
        public DeleteColumnMenuItemAction(String theName) {
            super(theName);
        }

        public void actionPerformed(ActionEvent e) {
            if (HeaderPopupMenu.this.selectedColumnFieldInfo != null) {
                IViewDisplaySettings viewDisplaySettings = HeaderPopupMenu.this.getViewDisplaySettings();
                List<IColumnFieldInfo> columnFieldInfos = HeaderPopupMenu.this.getColumnFieldInfos();
                columnFieldInfos.remove(HeaderPopupMenu.this.selectedColumnFieldInfo);
                viewDisplaySettings.setColumnAndSortInfo(columnFieldInfos.toArray(new IColumnFieldInfo[columnFieldInfos.size()]), viewDisplaySettings.getColumnAndSortInfo().getSortField());
                HeaderPopupMenu.this.table.refreshColumns();
            }
        }
    }

    private class QuickAddColumnMenuItemAction
    extends AbstractAction {
        private IColumnFieldInfo columnFieldInfo;

        public QuickAddColumnMenuItemAction(IColumnFieldInfo columnFieldInfo) {
            super(columnFieldInfo.getName());
            this.columnFieldInfo = columnFieldInfo;
        }

        public void actionPerformed(ActionEvent e) {
            IViewDisplaySettings viewDisplaySettings = HeaderPopupMenu.this.getViewDisplaySettings();
            List<IColumnFieldInfo> newColumnFieldInfos = HeaderPopupMenu.this.getColumnFieldInfos();
            if (HeaderPopupMenu.this.selectedColumnFieldInfo != null) {
                int index = newColumnFieldInfos.indexOf(HeaderPopupMenu.this.selectedColumnFieldInfo);
                newColumnFieldInfos.add(index + 1, this.columnFieldInfo);
            } else {
                newColumnFieldInfos.add(this.columnFieldInfo);
            }
            viewDisplaySettings.setColumnAndSortInfo(newColumnFieldInfos.toArray(new IColumnFieldInfo[newColumnFieldInfos.size()]), viewDisplaySettings.getColumnAndSortInfo().getSortField());
            HeaderPopupMenu.this.table.refreshColumns(viewDisplaySettings);
        }
    }

    private class MoreColumnsMenuItemAction
    extends AbstractAction {
        public MoreColumnsMenuItemAction(String name) {
            super(name);
        }

        public void actionPerformed(ActionEvent e) {
            IViewDisplaySettings viewDisplaySettings = HeaderPopupMenu.this.getViewDisplaySettings();
            boolean isContacts = HeaderPopupMenu.this.getFolder().isContactsFolder();
            ColumnsDialog dlg = new ColumnsDialog((JFrame)SwingUtilities.windowForComponent(HeaderPopupMenu.this.getInvoker()), viewDisplaySettings, isContacts);
            dlg.showMe();
            if (dlg.isActionCompleteSuccessfully()) {
                HeaderPopupMenu.this.table.refreshColumns();
            }
        }
    }

    private class SortTasklistAction
    extends AbstractAction {
        private SortTasklistAction(String name) {
            super(name);
        }

        public void actionPerformed(ActionEvent e) {
            int fieldID = HeaderPopupMenu.this.selectedColumnFieldInfo.getFieldID();
            if (HeaderPopupMenu.this.miSortTasklistAscending == e.getSource()) {
                HeaderPopupMenu.this.getItemList().sort(fieldID, true, true);
            } else if (HeaderPopupMenu.this.miSortTasklistDescending == e.getSource()) {
                HeaderPopupMenu.this.getItemList().sort(fieldID, false, true);
            }
        }
    }

    private class ChangeSortingMenuItemAction
    extends AbstractAction {
        public ChangeSortingMenuItemAction(String name) {
            super(name);
        }

        public void actionPerformed(ActionEvent e) {
            int sortOption;
            if (HeaderPopupMenu.this.miSortAscending == e.getSource()) {
                sortOption = 16;
            } else if (HeaderPopupMenu.this.miSortDescending == e.getSource()) {
                sortOption = 17;
            } else {
                throw new IllegalArgumentException();
            }
            IViewDisplaySettings viewDisplaySettings = HeaderPopupMenu.this.getViewDisplaySettings();
            if (!HeaderPopupMenu.this.selectedColumnFieldInfo.equals(viewDisplaySettings.getColumnAndSortInfo().getSortField()) || HeaderPopupMenu.this.selectedColumnFieldInfo.getSortOption() != sortOption) {
                HeaderPopupMenu.this.selectedColumnFieldInfo.setSortOption(sortOption);
                viewDisplaySettings.setColumnAndSortInfo(viewDisplaySettings.getColumnAndSortInfo().getVisibleColumns(), HeaderPopupMenu.this.selectedColumnFieldInfo);
                HeaderPopupMenu.this.table.refreshColumns();
            }
        }
    }
}

