/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.itemlisttable.lastlevel;

import com.appframework.ActionList;
import com.appframework.ApplicationFrameActionList;
import com.appframework.level.LevelManager;
import com.appframework.listener.ListenerType;
import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.appframework.utils.InstanceCounter;
import com.appframework.utils.OS;
import com.novell.gw.jclient.api.interfaces.IItem;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.api.interfaces.IViewDisplaySettings;
import com.novell.gw.jclient.api.interfaces.ab.IAddressBookItemList;
import com.novell.gw.jclient.api.interfaces.ab.IAddressable;
import com.novell.gw.jclient.api.interfaces.ab.IContact;
import com.novell.gw.jclient.api.interfaces.folder.IFolder;
import com.novell.gw.jclient.api.interfaces.message.IMessage;
import com.novell.gw.jclient.application.ContactTablePopupMenu;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.folder.ActionRenameFolder;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.ContactDetailsDialog;
import com.novell.gw.jclient.application.controls.components.SelectAllAble;
import com.novell.gw.jclient.application.controls.gwcomponent.GWMouseAdapter;
import com.novell.gw.jclient.application.controls.itemlisttable.lastlevel.ItemListTableController;
import com.novell.gw.jclient.application.controls.itemlisttable.lastlevel.ItemListTableHeader;
import com.novell.gw.jclient.application.controls.itemlisttable.level10.ItemListTable_Level10;
import com.novell.gw.jclient.application.controls.itemlistview.ItemListComponent;
import com.novell.gw.jclient.application.controls.itemlistview.ItemListSelectionListener;
import com.novell.gw.jclient.application.controls.itemlistview.ItemListView;
import com.novell.gw.jclient.application.controls.itemlistview.ItemSelectionChangedEvent;
import com.novell.gw.jclient.application.controls.menus.AbstractActionsPopupMenu;
import com.novell.gw.jclient.application.controls.menus.ItemListFolderPopupMenu;
import com.novell.gw.jclient.application.controls.menus.ItemListMultipleItemsAndSubfoldersPopupMenu;
import com.novell.gw.jclient.application.controls.menus.ItemListMultipleSubfoldersPopupMenu;
import com.novell.gw.jclient.application.controls.menus.ItemListSubfolderPopupMenu;
import com.novell.gw.jclient.application.controls.menus.PopupMenuFactory;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.eng_impl.utils.ColumnInfos;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.categories.CategoryUtils;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.ContactItemDescription;
import com.novell.gw.jclient.bl.om.items.MessageUtils;
import com.novell.gw.jclient.bl.om.items.TableItem;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.FocusManager;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemListTable
extends ItemListTable_Level10
implements MVCView<ItemListTableController, Object>,
ItemListComponent,
SelectAllAble,
FocusListener {
    private static final Logger logger = Logger.getLogger(ItemListTable.class);
    private InstanceCounter instanceCounter = new InstanceCounter(this);
    private ItemListTableController controller;
    private List<ItemListSelectionListener> selectionListeners = new ArrayList<ItemListSelectionListener>();

    public ItemListTable(IFolder folder, IViewDisplaySettings viewDisplaySettings, IItemList itemList, MVCController parentController) {
        super(folder, viewDisplaySettings, itemList);
        this.addMouseListener(new ILTMouseListener());
        this.getSelectionModel().addListSelectionListener(new ILTSelectionListener());
        this.setController(this.createController(parentController));
        ControlsUtils.getListenerManager(this.getController()).addListener(this, this, ListenerType.FOCUS_LISTENER);
    }

    @Override
    protected com.novell.gw.jclient.application.controls.itemlisttable.level01.ItemListTableHeader createDefaultTableHeader() {
        return new ItemListTableHeader<ItemListTable>(this);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10 && !e.isConsumed() && e.getModifiers() == 0 && !this.isCreatingQuickTask()) {
            this.openItem();
        }
        super.keyPressed(e);
    }

    @Override
    public void dispose() {
        super.dispose();
        logger.debug((Object)("disposing table " + this.instanceCounter.toString()));
        this.removeEditor();
        LevelManager.release(this.controller.getLevel());
    }

    public void selectFirstUnreadItem(boolean quickViewerVisible) {
        logger.debug((Object)"selectFirstUnreadItem");
        IItemList itemList = this.getItemList();
        if (itemList.getSize() == 0) {
            this.getSelectionModel().clearSelection();
        } else {
            int index = itemList.getFirstUnreadItemIndex(quickViewerVisible);
            if (index < 0 || index >= itemList.getSize()) {
                index = 0;
            }
            ListSelectionModel selectionModel = this.getSelectionModel();
            selectionModel.setSelectionInterval(index, index);
        }
        this.scrollToSelection();
    }

    public void selectFirstItem() {
        logger.debug((Object)"selectFirstItem");
        IItemList itemList = this.getItemList();
        if (itemList.getSize() == 0) {
            this.getSelectionModel().clearSelection();
        } else {
            for (int i = 0; i < itemList.getSize(); ++i) {
                IItem item = itemList.getItemAt(i);
                if (!this.isDataItem(item) || item instanceof IFolder) continue;
                this.selectItems(item);
                break;
            }
        }
        this.scrollToSelection();
    }

    public ItemListTableController createController(MVCController parentController) {
        return new ItemListTableController<ItemListTable>(this, parentController);
    }

    @Override
    public void setController(ItemListTableController controller) {
        this.controller = controller;
    }

    @Override
    public ItemListTableController getController() {
        return this.controller;
    }

    @Override
    public void setMVCModel(Object model) {
    }

    @Override
    public Object getMVCModel() {
        return null;
    }

    @Override
    public void showCategoryPopup(MouseEvent event) {
        if (this.getItemList().canSetCategoriesOnSelection()) {
            JPopupMenu popup = CategoryUtils.createEditCategoryPopupMenu(this.getController(), this.getItemList(), this.getSelectedItems(), this.isContacts());
            Point point = SwingUtilities.convertPoint((Component)event.getSource(), event.getPoint(), this);
            popup.show(this, point.x, point.y);
        }
        super.showCategoryPopup(event);
    }

    @Override
    public void addItemListSelectionListener(ItemListSelectionListener listener) {
        this.selectionListeners.add(listener);
    }

    @Override
    public void removeItemListSelectionListener(ItemListSelectionListener listener) {
        this.selectionListeners.remove(listener);
    }

    @Override
    public AbstractFolder getAbstractFolder() {
        return EngineCommandManager.getInstance(ControlsUtils.getUserGuid(this.getController())).getGWFolder(this.getFolder());
    }

    @Override
    public void setData(AbstractFolder folder, IViewDisplaySettings viewDisplaySettings, IItemList itemList) {
        if (!this.getAbstractFolder().equals(folder) || !this.getViewDisplaySettings().equals(viewDisplaySettings)) {
            throw new IllegalArgumentException();
        }
        this.setData(itemList);
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    private void processItemSelectionChangedEvent() {
        ItemSelectionChangedEvent event;
        int[] selectedRows = this.getSelectedRows();
        if (selectedRows.length > 0) {
            ArrayList<IItem> selectedItems = new ArrayList<IItem>();
            for (int row : selectedRows) {
                IItem item;
                if (row < 0 || row >= this.getItemList().getSize() || !this.isDataItem(item = this.getItemList().getItemAt(row))) continue;
                selectedItems.add(item);
            }
            event = new ItemSelectionChangedEvent(selectedItems.toArray(new IItem[selectedItems.size()]), this);
        } else {
            event = new ItemSelectionChangedEvent(new IItem[0], this);
        }
        for (ItemListSelectionListener listener : this.selectionListeners.toArray(new ItemListSelectionListener[this.selectionListeners.size()])) {
            listener.itemSelectionChanged(event);
        }
    }

    public void processPopupEvent(MouseEvent event) {
        boolean showViewPopup;
        int columnAtPoint = this.columnAtPointNotRelatedToRow(event.getPoint());
        int firstColumn = this.getFirstColumn();
        Integer selectedRow = this.rowAtPoint(event.getPoint());
        boolean bl = showViewPopup = columnAtPoint > firstColumn || selectedRow < 0;
        if (this.isSummaryView()) {
            int position = this.getWidth() / 2;
            boolean isLeftToRight = this.getComponentOrientation().isLeftToRight();
            boolean bl2 = (!isLeftToRight ? event.getX() <= position : event.getX() > position) || selectedRow < 0 ? true : (showViewPopup = false);
        }
        if (showViewPopup) {
            this.showViewPopup(event);
        } else if (selectedRow != -1) {
            boolean changeSelection = true;
            for (int row : this.getSelectedRows()) {
                if (row != selectedRow) continue;
                changeSelection = false;
                break;
            }
            if (changeSelection) {
                this.getSelectionModel().setSelectionInterval(selectedRow, selectedRow);
            }
            this.showContentPopup(event);
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        logger.debug((Object)("focus gained: " + this.instanceCounter));
        this.getController().processCommand(new Command(1160, this));
        ArrayList<IItem> lastSelectedItems = new ArrayList<IItem>();
        if (this.getModel().hasItemList()) {
            for (int i : this.getSelectedRows()) {
                IItemList itemList = this.getItemList();
                if (0 > i || i >= itemList.getSize()) continue;
                lastSelectedItems.add(itemList.getItemAt(i));
            }
            this.setLastSelectedItems(lastSelectedItems.toArray(new IItem[lastSelectedItems.size()]));
            this.processItemSelectionChangedEvent();
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (FocusManager.getCurrentManager().getPermanentFocusOwner() == null) {
            if (this.getController().isReleased()) {
                return;
            }
            this.getController().processCommand(new Command(1170, this));
        }
    }

    private void openItem() {
        boolean isContactsCollection;
        IItem[] items = this.getSelectedItems();
        ArrayList<AbstractItem> abstractItems = new ArrayList<AbstractItem>();
        ArrayList<AbstractFolder> abstractFolders = new ArrayList<AbstractFolder>();
        ArrayList<IContact> contacts = new ArrayList<IContact>();
        GWCommandManager commandManager = EngineCommandManager.getInstance(ControlsUtils.getUserGuid(this.getController()));
        for (IItem item : items) {
            if (item instanceof IFolder) {
                abstractFolders.add(commandManager.getGWFolder((IFolder)item));
                continue;
            }
            if (item instanceof IMessage) {
                IMessage message = (IMessage)item;
                try {
                    abstractItems.add(commandManager.getItem(this.getItemList(), message));
                }
                catch (GWCommandException e) {
                    logger.error((Object)e);
                }
                continue;
            }
            if (!(item instanceof IContact)) continue;
            contacts.add((IContact)item);
        }
        boolean isFoldersCollection = abstractItems.isEmpty() && contacts.isEmpty() && !abstractFolders.isEmpty();
        boolean bl = isContactsCollection = abstractItems.isEmpty() && !contacts.isEmpty() && abstractFolders.isEmpty();
        if (isFoldersCollection && abstractFolders.size() == 1) {
            Command command = new Command(40, abstractFolders.get(0));
            this.controller.processCommand(command);
        } else if (isContactsCollection) {
            Window parent = SwingUtilities.getWindowAncestor(this);
            ContactDetailsDialog dialog = ContactDetailsDialog.createContactDetailsDialog(parent, (IAddressable)contacts.get(0), (IAddressBookItemList)this.getItemList());
            dialog.pack();
            dialog.setLocationRelativeTo(parent);
            ((Dialog)dialog).setVisible(true);
        } else {
            for (AbstractItem abstractItem : abstractItems) {
                if (!abstractItem.canOpen()) continue;
                MessageUtils.doOpenItem(this.getItemList(), abstractItem, true, ControlsUtils.getUserGuid(this.getController()));
            }
        }
    }

    public void showContentPopup(MouseEvent event) {
        ActionList actionList = this.getController().getActionList();
        IItem[] items = this.getSelectedItems();
        ArrayList<AbstractItem> abstractItems = new ArrayList<AbstractItem>();
        ArrayList<AbstractFolder> abstractFolders = new ArrayList<AbstractFolder>();
        ArrayList<IContact> contacts = new ArrayList<IContact>();
        ArrayList<TableItem> allItems = new ArrayList<TableItem>();
        GWCommandManager commandManager = EngineCommandManager.getInstance(ControlsUtils.getUserGuid(this.getController()));
        for (IItem item : items) {
            if (item instanceof IFolder) {
                AbstractFolder abstractFolder = commandManager.getGWFolder((IFolder)item);
                abstractFolders.add(abstractFolder);
                allItems.add(abstractFolder);
                continue;
            }
            if (item instanceof IMessage) {
                IMessage message = (IMessage)item;
                try {
                    AbstractItem abstractItem = commandManager.getItem(this.getItemList(), message);
                    allItems.add(abstractItem);
                    abstractItems.add(abstractItem);
                }
                catch (GWCommandException e) {
                    logger.error((Object)e);
                }
                continue;
            }
            if (!(item instanceof IContact)) continue;
            contacts.add((IContact)item);
        }
        boolean isFoldersCollection = abstractItems.isEmpty() && contacts.isEmpty() && !abstractFolders.isEmpty();
        boolean isMessagesCollection = !abstractItems.isEmpty() && contacts.isEmpty() && abstractFolders.isEmpty();
        boolean isContactsCollection = abstractItems.isEmpty() && !contacts.isEmpty() && abstractFolders.isEmpty();
        AbstractActionsPopupMenu popup = null;
        String columnName = (String)this.getColumnModel().getColumn(this.columnAtPoint(event.getPoint())).getHeaderValue();
        if (isMessagesCollection) {
            popup = abstractItems.size() > 1 ? PopupMenuFactory.createMultipleItemsPopupMenu(this.getAbstractFolder(), this.getController().getActionList(), this.getItemList()) : PopupMenuFactory.createGWItemPopupMenu(this.getController().getActionList(), this.getAbstractFolder(), this.getItemList(), (AbstractItem)abstractItems.get(0), columnName);
        } else if (isFoldersCollection) {
            if (abstractFolders.size() > 1) {
                popup = new ItemListMultipleSubfoldersPopupMenu(this.getAbstractFolder(), (ApplicationFrameActionList)actionList);
                ((ActionRenameFolder)actionList.getAction(ActionKey.RENAME_FOLDER_LIGHT)).setIsClickInTree(false);
            } else {
                popup = new ItemListSubfolderPopupMenu(this.getAbstractFolder(), (ApplicationFrameActionList)actionList, (AbstractFolder)abstractFolders.get(0));
                ((ActionRenameFolder)actionList.getAction(ActionKey.RENAME_FOLDER_LIGHT)).setIsClickInTree(false);
            }
        } else if (isContactsCollection) {
            IContact contact = (IContact)contacts.get(0);
            popup = new ContactTablePopupMenu(actionList, this.getItemList());
            ColumnInfos columnInfos = new ColumnInfos(this.getViewDisplaySettings().getColumnAndSortInfo());
            ContactItemDescription description = new ContactItemDescription(contact, columnName, columnInfos);
            ((ContactTablePopupMenu)popup).rebuild(this.getItemList(), description, this.getViewDisplaySettings(), this.getAbstractFolder());
        } else if (allItems.size() > 0 && actionList instanceof ApplicationFrameActionList) {
            popup = new ItemListMultipleItemsAndSubfoldersPopupMenu(this.getAbstractFolder(), (ApplicationFrameActionList)actionList);
            ((ActionRenameFolder)actionList.getAction(ActionKey.RENAME_FOLDER_LIGHT)).setIsClickInTree(false);
        }
        if (popup != null) {
            popup.show(this, event.getX(), event.getY());
        }
    }

    public void showViewPopup(MouseEvent event) {
        ItemListView itemListView;
        AbstractItem item = null;
        IContact contact = null;
        int columnIndex = this.columnAtPoint(event.getPoint());
        String colum = (String)this.getColumnModel().getColumn(columnIndex).getHeaderValue();
        int rowIndex = this.rowAtPoint(event.getPoint());
        if (rowIndex >= 0 && rowIndex < this.getRowCount()) {
            Object value = this.getModel().getValueAt(rowIndex, columnIndex);
            if (value instanceof IMessage) {
                try {
                    item = EngineCommandManager.getInstance(ControlsUtils.getUserGuid(this.getController())).getItem(this.getItemList(), (IMessage)value);
                }
                catch (GWCommandException e) {
                    logger.error((Object)e);
                }
            } else if (value instanceof IContact) {
                contact = (IContact)value;
            }
        }
        if ((itemListView = (ItemListView)((Object)SwingUtilities.getAncestorOfClass(ItemListView.class, this))) != null) {
            ItemListFolderPopupMenu popup = contact == null ? new ItemListFolderPopupMenu((MVCController)this.getController(), itemListView, item, colum) : new ItemListFolderPopupMenu((MVCController)this.getController(), itemListView, contact, colum);
            popup.show(this, event.getX(), event.getY());
        }
    }

    private class ILTSelectionListener
    implements ListSelectionListener {
        private ILTSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (!ItemListTable.this.isValueIsAdjusting() && !e.getValueIsAdjusting()) {
                ItemListTable.this.processItemSelectionChangedEvent();
            }
        }
    }

    private class ILTMouseListener
    extends GWMouseAdapter {
        private ILTMouseListener() {
        }

        public void mouseClicked(MouseEvent event) {
            super.mouseClicked(event);
            if (OS.isDoubleClick(event)) {
                ItemListTable.this.openItem();
            }
        }

        public void showPopup(MouseEvent event) {
            if (!ItemListTable.this.isFocusOwner()) {
                ItemListTable.this.requestFocus();
            }
            ItemListTable.this.processPopupEvent(event);
        }
    }
}

