/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.itemlisttable.level02;

import com.novell.gw.jclient.api.interfaces.IItem;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.api.interfaces.IViewDisplaySettings;
import com.novell.gw.jclient.api.interfaces.folder.IFolder;
import com.novell.gw.jclient.api.interfaces.message.IMessage;
import com.novell.gw.jclient.application.controls.itemlisttable.TableColumnType;
import com.novell.gw.jclient.application.controls.itemlisttable.level01.ItemListTable_Level01;
import com.novell.gw.jclient.application.controls.itemlisttable.level02.ItemListTableDropTargetListener;
import com.novell.gw.jclient.application.controls.itemlisttable.level02.ItemListTableTransferHandler;
import com.novell.gw.jclient.application.controls.itemlisttable.level04.ItemListTable_Level04;
import com.novell.gw.jclient.application.resources.ImageResources;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import javax.swing.TransferHandler;

public class ItemListTable_Level02
extends ItemListTable_Level01 {
    private boolean paintArrow;
    private boolean subArrow;
    private Point arrowLocation;
    private Rectangle dropTargetCellRectangle;
    private boolean paintDropTargetCell;

    public ItemListTable_Level02(IFolder folder, IViewDisplaySettings viewDisplaySettings, IItemList itemList) {
        super(folder, viewDisplaySettings, itemList);
        this.setDragEnabled(true);
        new DropTarget(this, 3, new ItemListTableDropTargetListener(this));
        this.setTransferHandler(this.createDefaultTransferHandler());
    }

    public TransferHandler createDefaultTransferHandler() {
        return new ItemListTableTransferHandler<ItemListTable_Level02>(this);
    }

    public boolean isOverFolder(Point point) {
        int row = this.rowAtPoint(point);
        return row != -1 && this.getItemList().getItemAt(row) instanceof IFolder;
    }

    public boolean isOverChecklistItem(Point point) {
        int row = this.rowAtPoint(point);
        if (row != -1) {
            IItem item = this.getItemList().getItemAt(row);
            return item instanceof IMessage && ((IMessage)item).isInChecklist();
        }
        return false;
    }

    public boolean isOverMessage(Point point) {
        int row = this.rowAtPoint(point);
        return row != -1 && this.getItemList().getItemAt(row) instanceof IMessage;
    }

    private void drawArrow(Graphics2D graphics2D) {
        if (this.getViewDisplaySettings().getViewMode() == 7) {
            if (this.arrowLocation == null || !this.paintArrow) {
                return;
            }
            Image image = ImageResources.ICON_CHECKLIST_ARROW.getImage();
            if (this.subArrow) {
                image = ImageResources.ICON_CHECKLIST_ARROW_DRAG_RIGHT.getImage();
            }
            int height = image.getHeight(this);
            int y = this.arrowLocation.y;
            int index = this.getItemList().findLastUncompletedChecklistItemIndex();
            Rectangle cellRect = this.getCellRect(index, 0, false);
            int maxY = cellRect.y + cellRect.height;
            if (y > maxY) {
                y = maxY;
            }
            graphics2D.drawImage(image, this.arrowLocation.x, y - height / 2 + 1, this);
        }
    }

    public IMessage getLastUncompletedTask() {
        IItem item;
        IMessage message = null;
        for (int i = 0; !(i >= this.getRowCount() || (item = this.getItemList().getItemAt(i)) instanceof IMessage && ((IMessage)item).isCompleted()); ++i) {
        }
        return message;
    }

    public void repaintDragFolder(Point cursorPos) {
        Rectangle cellBounds;
        int row = this.rowAtPoint(cursorPos);
        Rectangle prevoiusBounds = this.dropTargetCellRectangle;
        this.dropTargetCellRectangle = cellBounds = this.getCellRect(row, this.getFirstColumn(), false);
        if (prevoiusBounds != null) {
            this.repaint(prevoiusBounds);
        }
        this.repaint(cellBounds);
    }

    private int getArrowShiftForRow(int row) {
        if (this instanceof ItemListTable_Level04) {
            ItemListTable_Level04 table_level04 = (ItemListTable_Level04)this;
            for (int i = 0; i < this.getColumnCount(); ++i) {
                if (table_level04.getColumnModel().getColumn(i).getColumnType() != TableColumnType.COLUMN_MAIN_ICON) continue;
                int x = this.getCellRect((int)row, (int)i, (boolean)false).x;
                if (!this.getComponentOrientation().isLeftToRight()) {
                    x = this.getWidth() - x;
                }
                return x;
            }
        }
        return 0;
    }

    public int getThreadShift(int row) {
        return 0;
    }

    public void repaintArrow(Point cursorPos) {
        int oldIndex = -1;
        this.subArrow = false;
        int index = this.rowAtPoint(cursorPos);
        if (index == -1) {
            return;
        }
        if (this.arrowLocation != null) {
            oldIndex = this.rowAtPoint(this.arrowLocation);
        }
        Rectangle rect = this.getCellRect(index, 0, true);
        this.arrowLocation = rect.getLocation();
        if (cursorPos.y > this.arrowLocation.y + rect.height / 3) {
            IItemList itemList = this.getItemList();
            if (cursorPos.y <= this.arrowLocation.y + rect.height * 2 / 3 || itemList.getThreadDepthAt(index) < itemList.getThreadDepthAt(index + 1)) {
                this.subArrow = true;
                this.arrowLocation.x = this.getComponentOrientation().isLeftToRight() ? (this.arrowLocation.x += this.getArrowShiftForRow(index)) : (this.arrowLocation.x -= this.getArrowShiftForRow(index));
            }
            this.arrowLocation.y += this.getRowHeight(index);
        }
        if (this.getThreadShift(index) > 0 && !this.subArrow) {
            this.arrowLocation.x = this.getComponentOrientation().isLeftToRight() ? (this.arrowLocation.x += this.getArrowShiftForRow(index)) : (this.arrowLocation.x -= this.getArrowShiftForRow(index));
        }
        this.repaint(this.getArrowRectForIndex(oldIndex));
        this.repaint(this.getArrowRectForIndex(index));
    }

    public boolean isSubDrop(Point point) {
        int row = this.rowAtPoint(point);
        if (row == -1) {
            return false;
        }
        Rectangle rect = this.getCellRect(row, 0, true);
        int height = rect.height;
        IItemList itemList = this.getItemList();
        return point.y > rect.y + height / 3 && (point.y <= rect.y + height * 2 / 3 || itemList.getThreadDepthAt(row) < itemList.getThreadDepthAt(row + 1));
    }

    public void paint(Graphics g) {
        super.paint(g);
        this.drawArrow((Graphics2D)g);
        this.drawDropTargetCell((Graphics2D)g);
    }

    private void drawDropTargetCell(Graphics2D graphics2D) {
        if (this.dropTargetCellRectangle == null || !this.paintDropTargetCell) {
            return;
        }
        graphics2D.drawRect(this.dropTargetCellRectangle.x, this.dropTargetCellRectangle.y + 1, this.dropTargetCellRectangle.width - 2, this.dropTargetCellRectangle.height - 2);
    }

    private Rectangle getArrowRectForIndex(int index) {
        Rectangle cellRect = this.getCellRect(index, 0, true);
        Image image = ImageResources.ICON_CHECKLIST_ARROW.getImage();
        int height = image.getHeight(this);
        cellRect.y -= height;
        cellRect.height += 2 * height;
        return cellRect;
    }

    public void setPaintArrow(boolean paintArrow) {
        this.paintArrow = paintArrow;
    }

    public void setPaintDropTargetCell(boolean paintDropTargetCell) {
        this.paintDropTargetCell = paintDropTargetCell;
    }
}

