/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.itemlisttable.level05;

import com.novell.gw.jclient.api.interfaces.IGroupHeader;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.api.interfaces.IViewDisplaySettings;
import com.novell.gw.jclient.api.interfaces.ab.IContact;
import com.novell.gw.jclient.api.interfaces.folder.IFolder;
import com.novell.gw.jclient.api.interfaces.message.IMessage;
import com.novell.gw.jclient.application.controls.ColorUtils;
import com.novell.gw.jclient.application.controls.itemlisttable.TableColumnType;
import com.novell.gw.jclient.application.controls.itemlisttable.level04.ItemListTable_Level04;
import com.novell.gw.jclient.application.controls.itemlisttable.level05.ItemListTableModel_Level05;
import com.novell.gw.jclient.application.controls.itemlisttable.level05.ItemListTableUI_Level05;
import com.novell.gw.jclient.application.controls.itemlisttable.renderers.AdditionalItemIconsRenderer;
import com.novell.gw.jclient.application.controls.itemlisttable.renderers.DetailsItemCellRenderer;
import com.novell.gw.jclient.application.controls.itemlisttable.renderers.EmptyCellRenderer;
import com.novell.gw.jclient.application.controls.itemlisttable.renderers.GroupHeaderCellRenderer;
import com.novell.gw.jclient.application.controls.itemlisttable.renderers.ItemIconRenderer;
import com.novell.gw.jclient.application.controls.itemlisttable.renderers.LastEmptyCellRenderer;
import com.novell.gw.jclient.application.controls.itemlisttable.renderers.collapsable.Collapsable;
import com.novell.gw.jclient.application.controls.itemlisttable.renderers.collapsable.CollapsableCell;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.UIManager;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class ItemListTable_Level05
extends ItemListTable_Level04 {
    protected static final CollapsableCell COLLAPSABLE_CELL = new CollapsableCell();
    protected static final TableCellRenderer GROUP_HEADER_CELL_RENDERER = new GroupHeaderCellRenderer();
    protected static final TableCellRenderer DETAILS_ITEM_CELL_RENDERER = new DetailsItemCellRenderer();
    protected static final TableCellRenderer ADDITIONAL_ITEM_ICONS_RENDERER = new AdditionalItemIconsRenderer();
    protected static final TableCellRenderer ITEM_ICON_RENDERER = new ItemIconRenderer();
    protected static final TableCellRenderer EMPTY_CELL_RENDERER = new EmptyCellRenderer();
    protected static final TableCellRenderer LAST_EMPTY_CELL_RENDERER = new LastEmptyCellRenderer();

    public ItemListTable_Level05(IFolder folder, IViewDisplaySettings viewDisplaySettings, IItemList itemList) {
        super(folder, viewDisplaySettings, itemList);
        this.addFocusListener(new RepaintFocusListener());
    }

    protected ItemListTableModel_Level05 createDefaultDataModel() {
        return new ItemListTableModel_Level05<ItemListTable_Level05>(this);
    }

    protected ItemListTableModel_Level05 createDefaultDataModel(IFolder folder, IItemList itemList) {
        return new ItemListTableModel_Level05<ItemListTable_Level05>(this, folder, itemList);
    }

    public ItemListTableModel_Level05 getModel() {
        return (ItemListTableModel_Level05)super.getModel();
    }

    public void setModel(TableModel dataModel) {
        if (!(dataModel instanceof ItemListTableModel_Level05)) {
            throw new IllegalArgumentException();
        }
        super.setModel(dataModel);
    }

    @Deprecated
    public void scrollRectToVisible(Rectangle rectangle) {
        Rectangle visibleRect = this.getVisibleRect();
        rectangle.x = visibleRect.x;
        rectangle.width = visibleRect.width;
        super.scrollRectToVisible(rectangle);
    }

    protected int getStartColumnForLongCell(int row, int column) {
        if (this.getModel().isGroupHeader(row)) {
            return this.getColumnModel().getGroupHeaderColumnPosition() + 1;
        }
        return column;
    }

    protected boolean isLongCell(int row, int column) {
        int columnCount = this.getColumnCount() - this.getLastEmptyColumnsCount();
        return this.getModel().isGroupHeader(row) && column < columnCount && column > this.getColumnModel().getGroupHeaderColumnPosition();
    }

    public Rectangle getCellRect(int row, int column, boolean includeSpacing) {
        if (row != -1 && column != -1 && this.isLongCell(row, column)) {
            int startColumn = this.getStartColumnForLongCell(row, column);
            boolean leftToRight = this.getComponentOrientation().isLeftToRight();
            Rectangle cellRect = super.getCellRect(row, startColumn, includeSpacing);
            int columnCount = this.getColumnCount() - this.getLastEmptyColumnsCount();
            for (int i = startColumn + 1; i < columnCount; ++i) {
                cellRect.width += super.getCellRect((int)row, (int)i, (boolean)includeSpacing).width;
            }
            if (!leftToRight) {
                cellRect.x = this.getLastEmptyColumnsCount() > 0 ? this.getColumnModel().getColumn(this.getColumnCount() - 1).getWidth() : 0;
            }
            return cellRect;
        }
        return super.getCellRect(row, column, includeSpacing);
    }

    public boolean isCellEditable(int row, int column) {
        return this.getColumnModel().getColumn(column).getColumnType() == TableColumnType.COLUMN_GROUP_HEADER && this.getValueAt(row, column) instanceof Collapsable || super.isCellEditable(row, column);
    }

    public TableCellEditor getCellEditor(int row, int column) {
        if (this.getValueAt(row, column) instanceof Collapsable) {
            return COLLAPSABLE_CELL;
        }
        return super.getCellEditor(row, column);
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        Object value = this.getValueAt(row, column);
        TableColumnType columnType = this.getColumnModel().getColumn(column).getColumnType();
        if (columnType == TableColumnType.COLUMN_LAST_EMPTY_COLUMN) {
            return LAST_EMPTY_CELL_RENDERER;
        }
        if (columnType == TableColumnType.COLUMN_GROUP_HEADER) {
            if (value instanceof Collapsable) {
                return COLLAPSABLE_CELL;
            }
            return EMPTY_CELL_RENDERER;
        }
        if (value instanceof IGroupHeader && column > this.getColumnModel().getGroupHeaderColumnPosition()) {
            return GROUP_HEADER_CELL_RENDERER;
        }
        if (columnType == TableColumnType.COLUMN_ADDITIONAL_ICONS && (value instanceof IMessage || value instanceof IFolder)) {
            return ADDITIONAL_ITEM_ICONS_RENDERER;
        }
        if (value instanceof IContact || value instanceof IMessage || value instanceof IFolder) {
            if (columnType == TableColumnType.COLUMN_MAIN_ICON) {
                return ITEM_ICON_RENDERER;
            }
            if (column >= this.getFirstColumn()) {
                return DETAILS_ITEM_CELL_RENDERER;
            }
        }
        return EMPTY_CELL_RENDERER;
    }

    public void setForeground(Color foreground) {
        super.setForeground(ColorUtils.unwrapColor(foreground));
    }

    public void setSelectionForeground(Color selectionForeground) {
        super.setSelectionForeground(ColorUtils.unwrapColor(selectionForeground));
    }

    public void setSelectionBackground(Color selectionBackground) {
        super.setSelectionBackground(ColorUtils.unwrapColor(selectionBackground));
    }

    public void setBackground(Color background) {
        super.setBackground(ColorUtils.unwrapColor(background));
    }

    public String getUIClassID() {
        return ItemListTable_Level05.class.getSimpleName();
    }

    static {
        UIManager.put(ItemListTable_Level05.class.getSimpleName(), ItemListTableUI_Level05.class.getName());
    }

    private class RepaintFocusListener
    implements FocusListener {
        private RepaintFocusListener() {
        }

        public void focusGained(FocusEvent e) {
            ItemListTable_Level05.this.repaint();
        }

        public void focusLost(FocusEvent e) {
            ItemListTable_Level05.this.repaint();
        }
    }
}

