/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.itemlisttable.level08;

import com.novell.gw.jclient.api.interfaces.IItem;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.api.interfaces.IViewDisplaySettings;
import com.novell.gw.jclient.api.interfaces.folder.IFolder;
import com.novell.gw.jclient.api.interfaces.message.IMessage;
import com.novell.gw.jclient.application.controls.itemlisttable.TableColumnType;
import com.novell.gw.jclient.application.controls.itemlisttable.level07.ItemListTable_Level07;
import com.novell.gw.jclient.application.controls.itemlisttable.renderers.TableRendererUtils;
import com.novell.gw.jclient.application.controls.itemlisttable.renderers.messagepreview.MessagePreviewCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.apache.log4j.Logger;

public class ItemListTable_Level08
extends ItemListTable_Level07 {
    private static final Logger logger = Logger.getLogger(ItemListTable_Level08.class);
    protected static final TableCellRenderer MESSAGE_PREVIEW_CELL_RENDERER = new MessagePreviewCellRenderer();

    public ItemListTable_Level08(IFolder folder, IViewDisplaySettings viewDisplaySettings, IItemList itemList) {
        super(folder, viewDisplaySettings, itemList);
    }

    public boolean isMessagePreview() {
        IViewDisplaySettings viewDisplaySettings = this.getViewDisplaySettings();
        return viewDisplaySettings != null && viewDisplaySettings.getMsgPreview();
    }

    public void scrollRowToVisible(int row) {
        if (this.isMessagePreview()) {
            int max = this.getVisibleRect().height / this.getRowHeight();
            logger.debug((Object)("max: " + max));
            for (int i = row - max; i < row + max; ++i) {
                if (i <= 0 || i >= this.getRowCount()) continue;
                this.updateRowHeight(i);
            }
        }
        super.scrollRowToVisible(row);
    }

    public void updateRowHeight(int row) {
        IItem item;
        if (this.isMessagePreview() && (item = this.getItemList().getItemAt(row)) instanceof IMessage) {
            this.updateRowHeight(row, (IMessage)item);
        }
    }

    private void updateRowHeight(int row, IMessage message) {
        int multiplier = 1;
        int width = 0;
        int empty = this.getColumnModel().getEmptyColumnsCount();
        int count = this.getColumnCount() - this.getLastEmptyColumnsCount();
        for (int i = empty; i < count; ++i) {
            width += this.getColumnModel().getColumn(i).getWidth();
        }
        String[] summaryValues = TableRendererUtils.getSummaryValues(message, this.getFolder(), this.getViewDisplaySettings(), this, width);
        int newRowHeight = this.getRowHeight() * (multiplier += summaryValues.length);
        if (this.getRowHeight(row) != newRowHeight) {
            this.setRowHeight(row, newRowHeight);
        }
    }

    public Object getValueAt(int row, int column) {
        Object value = super.getValueAt(row, column);
        if (this.isMessagePreview() && value instanceof IMessage) {
            this.updateRowHeight(row, (IMessage)value);
        }
        return value;
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        TableColumnType columnType = this.getColumnModel().getColumn(column).getColumnType();
        if (this.isMessagePreview() && columnType == TableColumnType.COLUMN_DETAILS && !this.getModel().isChecklistDummyItem(row)) {
            if (this.getItemList().getItemAt(row) instanceof IFolder) {
                return DETAILS_ITEM_CELL_RENDERER;
            }
            return MESSAGE_PREVIEW_CELL_RENDERER;
        }
        return super.getCellRenderer(row, column);
    }

    protected boolean isLongCell(int row, int column) {
        int columnCount = this.getColumnCount() - this.getLastEmptyColumnsCount();
        if (this.isMessagePreview() && column >= this.getFirstColumn() && column < columnCount && this.getItemList().getItemAt(row) instanceof IMessage) {
            return true;
        }
        return super.isLongCell(row, column);
    }

    protected int getStartColumnForLongCell(int row, int column) {
        Object value = this.getValueAt(row, column);
        if (this.isMessagePreview() && value instanceof IMessage && column >= this.getFirstColumn()) {
            return this.getFirstColumn();
        }
        return super.getStartColumnForLongCell(row, column);
    }
}

