/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.itemlisttable.level10;

import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.api.interfaces.IViewDisplaySettings;
import com.novell.gw.jclient.api.interfaces.folder.IFolder;
import com.novell.gw.jclient.application.controls.itemlisttable.TableColumnType;
import com.novell.gw.jclient.application.controls.itemlisttable.level09.ItemListTable_Level09;
import com.novell.gw.jclient.application.controls.itemlisttable.level10.ItemListTableColumnModel_Level10;
import com.novell.gw.jclient.application.controls.itemlisttable.renderers.SummaryItemCellRenderer;
import com.novell.gw.jclient.application.controls.itemlisttable.renderers.messagepreview.SummaryMessagePreviewCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

public class ItemListTable_Level10
extends ItemListTable_Level09 {
    public static final TableCellRenderer SUMMARY_ITEM_CELL_RENDERER = new SummaryItemCellRenderer();
    public static final TableCellRenderer SUMMARY_MESSAGE_PREVIEW_CELL_RENDERER = new SummaryMessagePreviewCellRenderer();

    public ItemListTable_Level10(IFolder folder, IViewDisplaySettings viewDisplaySettings, IItemList itemList) {
        super(folder, viewDisplaySettings, itemList);
    }

    public void setData(IItemList itemList) {
        super.setData(itemList);
        this.init();
    }

    private void init() {
        if (this.isSummaryView()) {
            this.setAutoResizeMode(2);
            this.setTableHeader(null);
        } else {
            this.setAutoResizeMode(0);
            this.setTableHeader(this.createDefaultTableHeader());
        }
    }

    public void updateUI() {
        super.updateUI();
        if (this.isSummaryView() && !this.getViewDisplaySettings().getMsgPreview()) {
            this.setRowHeight(this.getDefaultRowHeight() * 2);
        }
    }

    public boolean isSummaryView() {
        return this.getViewDisplaySettings() != null && this.getViewDisplaySettings().isSummaryView();
    }

    public int getLastEmptyColumnsCount() {
        if (this.isSummaryView()) {
            return 0;
        }
        return super.getLastEmptyColumnsCount();
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        TableColumnType columnType = this.getColumnModel().getColumn(column).getColumnType();
        if (TableColumnType.COLUMN_SUMMARY == columnType) {
            if (this.getModel().isChecklistDummyItem(row)) {
                return CHECKLIST_DUMMY_ITEM_RENDERER;
            }
            if (this.isMessagePreview()) {
                if (this.getItemList().getItemAt(row) instanceof IFolder) {
                    return DETAILS_ITEM_CELL_RENDERER;
                }
                return SUMMARY_MESSAGE_PREVIEW_CELL_RENDERER;
            }
            return SUMMARY_ITEM_CELL_RENDERER;
        }
        return super.getCellRenderer(row, column);
    }

    protected ItemListTableColumnModel_Level10 createDefaultColumnModel() {
        return new ItemListTableColumnModel_Level10<ItemListTable_Level10>(this);
    }

    public ItemListTableColumnModel_Level10 getColumnModel() {
        return (ItemListTableColumnModel_Level10)super.getColumnModel();
    }

    public void setColumnModel(TableColumnModel columnModel) {
        if (!(columnModel instanceof ItemListTableColumnModel_Level10)) {
            throw new IllegalArgumentException();
        }
        super.setColumnModel(columnModel);
    }

    public boolean getScrollableTracksViewportWidth() {
        return this.isSummaryView() || super.getScrollableTracksViewportWidth();
    }
}

