/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.itemlisttable.renderers.category;

import com.novell.gw.jclient.application.controls.itemlisttable.level06.ItemListTable_Level06;
import com.novell.gw.jclient.application.controls.itemlisttable.renderers.category.CategoryIcon;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.resources.ImageResources;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.lang.ref.WeakReference;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JTable;
import org.apache.log4j.Logger;

public class CategoryIconPanel
extends OrientablePanel {
    private static final Logger logger = Logger.getLogger(CategoryIconPanel.class);
    public static final int SHIFT_HORIZONTAL = 10;
    public static final int SHIFT_VERTICAL = 2;
    public static final int SHIFT_OVERLAY_HORIZONTAL = 6;
    public static final int SHIFT_OVERLAY_VERTICAL = 2;
    private final CategoryIcon categoryIcon = new CategoryIcon();
    private Icon icon;
    private Icon overlayIcon;
    private boolean isMouseOver = false;
    private Cursor cursorTemp;
    private Cursor cursorCategory = Cursor.getPredefinedCursor(12);
    private WeakReference<JTable> table;
    private boolean isSelected;
    private int row;

    public CategoryIconPanel() {
        this(null, false, -1);
    }

    public CategoryIconPanel(JTable table, boolean isSelected, int row) {
        this.table = table == null ? null : new WeakReference<JTable>(table);
        this.row = row;
        this.isSelected = isSelected;
        this.init();
    }

    private void init() {
        this.setIcon(ImageResources.ITM_MAIL_READ_HIGH);
        CategoryMouseAdapter mouseAdapter = new CategoryMouseAdapter();
        this.addMouseListener(mouseAdapter);
        this.addMouseMotionListener(mouseAdapter);
        this.setOpaque(true);
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
        this.repaint();
    }

    public Icon getOverlayIcon() {
        return this.overlayIcon;
    }

    public void setOverlayIcon(Icon overlayIcon) {
        this.overlayIcon = overlayIcon;
        this.repaint();
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        CategoryIconPanel panel = new CategoryIconPanel();
        frame.add(panel);
        frame.setDefaultCloseOperation(3);
        frame.setSize(400, 300);
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }

    public void setCategoryColor(Color color) {
        this.categoryIcon.setCategoryColor(color);
        this.repaint();
    }

    protected void paintBorder(Graphics g) {
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.isMouseOver) {
            if (this.icon != null) {
                this.paintIcon(g, this.icon, 10, 2);
                if (this.overlayIcon != null) {
                    this.paintIcon(g, this.overlayIcon, 6, 2);
                }
                this.paintIcon(g, this.categoryIcon, 0, 0);
            }
        } else if (this.icon != null) {
            if (this.categoryIcon.getCategoryColor() != null) {
                this.paintIcon(g, this.categoryIcon, 0, 0);
            }
            this.paintIcon(g, this.icon, 10, 2);
            if (this.overlayIcon != null) {
                this.paintIcon(g, this.overlayIcon, 6, 2);
            }
        }
    }

    public void paintIcon(Graphics graphics, Icon icon, int x, int y) {
        if (!this.getComponentOrientation().isLeftToRight()) {
            int newX = this.getWidth() - x - icon.getIconWidth();
            icon.paintIcon(this, graphics, newX, y);
        } else {
            icon.paintIcon(this, graphics, x, y);
        }
    }

    private void swapCursor(Cursor cursor) {
        if (cursor == null || !cursor.equals(this.getCursor())) {
            this.cursorTemp = this.getCursor();
            this.setCursor(cursor);
        }
    }

    private class CategoryMouseAdapter
    extends MouseAdapter
    implements MouseMotionListener {
        private CategoryMouseAdapter() {
        }

        public void mousePressed(MouseEvent e) {
            JTable table;
            JTable jTable = table = CategoryIconPanel.this.table == null ? null : (JTable)CategoryIconPanel.this.table.get();
            if (table != null) {
                if (CategoryIconPanel.this.isMouseOver) {
                    if (!CategoryIconPanel.this.isSelected) {
                        table.getSelectionModel().setSelectionInterval(CategoryIconPanel.this.row, CategoryIconPanel.this.row);
                    }
                } else {
                    table.getSelectionModel().setSelectionInterval(CategoryIconPanel.this.row, CategoryIconPanel.this.row);
                }
                if (table instanceof ItemListTable_Level06) {
                    ((ItemListTable_Level06)table).showCategoryPopup(e);
                }
            }
        }

        public void mouseExited(MouseEvent e) {
            CategoryIconPanel.this.isMouseOver = false;
            CategoryIconPanel.this.swapCursor(CategoryIconPanel.this.cursorTemp);
            CategoryIconPanel.this.repaint();
        }

        public void mouseMoved(MouseEvent e) {
            Point point = e.getPoint();
            if (point.x <= CategoryIconPanel.this.categoryIcon.getIconWidth() && point.y <= CategoryIconPanel.this.categoryIcon.getIconHeight()) {
                if (!CategoryIconPanel.this.isMouseOver) {
                    CategoryIconPanel.this.isMouseOver = true;
                    CategoryIconPanel.this.swapCursor(CategoryIconPanel.this.cursorCategory);
                    CategoryIconPanel.this.repaint();
                }
            } else if (CategoryIconPanel.this.isMouseOver) {
                CategoryIconPanel.this.isMouseOver = false;
                CategoryIconPanel.this.swapCursor(CategoryIconPanel.this.cursorTemp);
                CategoryIconPanel.this.repaint();
            }
        }

        public void mouseDragged(MouseEvent e) {
        }
    }
}

