/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.itemlisttable.renderers.messagepreview;

import com.novell.gw.jclient.api.interfaces.message.IMessage;
import com.novell.gw.jclient.application.controls.itemlisttable.level07.ItemListTableColumnModel_Level07;
import com.novell.gw.jclient.application.controls.itemlisttable.level08.ItemListTable_Level08;
import com.novell.gw.jclient.application.controls.itemlisttable.renderers.RenderingLabel;
import com.novell.gw.jclient.application.controls.itemlisttable.renderers.TableRendererUtils;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.border.Border;

public class MessagePreviewPanel
extends OrientablePanel {
    protected List<JLabel> firstLineLabels = new ArrayList<JLabel>();
    protected JLabel secondLineLabel = new RenderingLabel();
    protected JLabel thirdLineLabel = new RenderingLabel();
    private IMessage message;
    private WeakReference<ItemListTable_Level08> table;
    private int columnCount = 0;
    private boolean isSelected = false;

    public MessagePreviewPanel() {
        this.setLayout(new FlowLayout(3, 0, 0));
    }

    protected void setWidth(int width, JLabel label) {
        label.setPreferredSize(new Dimension(width, label.getPreferredSize().height));
        label.setMaximumSize(new Dimension(width, label.getMaximumSize().height));
        label.setSize(new Dimension(width, label.getWidth()));
    }

    public void rebuild() {
        this.removeAll();
        if (this.getTable() == null || this.message == null) {
            return;
        }
        Color foreground = TableRendererUtils.getCellColor(this.message, this.isSelected, true, true, -1, this.getTable());
        int summaryWidth = 0;
        for (int i = 0; i < this.columnCount; ++i) {
            int columnIndex = i + this.getTable().getColumnModel().getEmptyColumnsCount();
            JLabel label = this.getLabel(i);
            label.setForeground(foreground);
            TableRendererUtils.applyFontAndRenderingHints(label, this.getTable(), this.message);
            String text = TableRendererUtils.getString(this.message, this.getTable(), columnIndex);
            label.setText(text);
            int width = this.getTable().getColumnModel().getColumn(columnIndex).getWidth();
            Border border = this.getBorder();
            if (border != null) {
                if (i == 0) {
                    width -= border.getBorderInsets((Component)this).left;
                }
                if (i == this.columnCount - 1) {
                    width -= border.getBorderInsets((Component)this).right;
                }
            }
            summaryWidth += width;
            this.setWidth(width, label);
            this.add(label);
        }
        this.buildLastLines(summaryWidth, foreground);
    }

    protected void buildLastLines(int summaryWidth, Color foreground) {
        String[] summaryValues = TableRendererUtils.getSummaryValues(this.getMessage(), this.getTable().getFolder(), this.getTable().getViewDisplaySettings(), this.getTable(), summaryWidth);
        if (summaryValues.length > 0) {
            this.secondLineLabel.setText(summaryValues[0]);
            this.buildLine(this.secondLineLabel, summaryWidth, foreground);
        }
        if (summaryValues.length > 1) {
            this.thirdLineLabel.setText(summaryValues[1]);
            this.buildLine(this.thirdLineLabel, summaryWidth, foreground);
        }
    }

    private void buildLine(JLabel label, int summaryWidth, Color foreground) {
        if (this.isSelected) {
            label.setForeground(foreground);
        } else {
            label.setForeground(Color.GRAY);
        }
        TableRendererUtils.applyFontAndRenderingHints(label, this.getTable(), this.message);
        this.setWidth(summaryWidth, label);
        this.add(label);
    }

    public JLabel getLabel(int index) {
        if (index >= this.firstLineLabels.size()) {
            RenderingLabel label = new RenderingLabel();
            label.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 1));
            this.firstLineLabels.add(index, label);
        }
        return this.firstLineLabels.get(index);
    }

    public void setData(ItemListTable_Level08 table, IMessage message, boolean isSelected) {
        this.setTable(table);
        this.message = message;
        this.isSelected = isSelected;
        if (table != null) {
            ItemListTableColumnModel_Level07 columnModel = table.getColumnModel();
            this.columnCount = columnModel.getColumnsFieldInfos().length;
        }
        this.rebuild();
    }

    public IMessage getMessage() {
        return this.message;
    }

    public void setMessage(IMessage message) {
        this.message = message;
    }

    public ItemListTable_Level08 getTable() {
        return this.table == null ? null : (ItemListTable_Level08)this.table.get();
    }

    public void setTable(ItemListTable_Level08 table) {
        this.table = table == null ? null : new WeakReference<ItemListTable_Level08>(table);
    }

    public boolean isSelected() {
        return this.isSelected;
    }
}

