/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.itemview;

import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.ItemBox;
import com.novell.gw.jclient.application.controls.itemview.QuickViewer;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import javax.swing.Timer;
import org.apache.log4j.Logger;

public abstract class AbstractAutoSavePanel
extends OrientablePanel
implements ItemBox {
    private static Logger logger = Logger.getLogger(AbstractAutoSavePanel.class);
    private Timer timer = new Timer(40000, new SaveAction());
    protected boolean isQuickView;
    protected boolean isDataChanged;
    protected static final int AUTO_SAVE_TIME = 40000;
    protected ArrayList<Component> components = new ArrayList();
    protected MVCController controller;
    protected AbstractItem item;

    protected AbstractAutoSavePanel() {
    }

    public AbstractAutoSavePanel(MVCController controller) {
        this();
        this.controller = controller;
        this.isQuickView = this.controller.getMVCView() instanceof QuickViewer;
    }

    public AbstractItem getItem() {
        return this.item;
    }

    protected abstract void save();

    protected void startTimer() {
        this.isDataChanged = true;
        if (this.isQuickView) {
            logger.debug((Object)"Timer Started");
            if (this.timer.isRunning()) {
                this.timer.restart();
            } else {
                this.timer.start();
            }
        }
    }

    public boolean hasComponentsFocus() {
        for (Component component : this.components) {
            if (!component.hasFocus()) continue;
            return true;
        }
        return false;
    }

    protected void findAllChildComponents(Container container) {
        this.components.add(container);
        for (Component child : container.getComponents()) {
            this.findAllChildComponents((Container)child);
        }
    }

    public void saveChanges() {
        if (this.isDataChanged) {
            this.isDataChanged = false;
            this.save();
        }
        this.isDataChanged = false;
    }

    public void release() {
        this.timer.stop();
        this.timer = null;
        if (this.components != null) {
            this.components.clear();
            this.components = null;
        }
    }

    protected class CurrentFocusAdapter
    extends FocusAdapter {
        protected CurrentFocusAdapter() {
        }

        public void focusLost(FocusEvent e) {
            logger.debug((Object)"focusLost");
            if (!AbstractAutoSavePanel.this.components.contains(e.getOppositeComponent()) && !AbstractAutoSavePanel.this.hasComponentsFocus()) {
                AbstractAutoSavePanel.this.saveChanges();
            }
        }

        public void focusGained(FocusEvent e) {
            logger.debug((Object)"focusGained");
        }
    }

    private class SaveAction
    implements ActionListener {
        private SaveAction() {
        }

        public void actionPerformed(ActionEvent e) {
            AbstractAutoSavePanel.this.saveChanges();
            AbstractAutoSavePanel.this.timer.stop();
            logger.debug((Object)"Timer Stoped");
        }
    }
}

