/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.itemview;

import com.appframework.cache.IdentifiedObject;
import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.appframework.resources.GWIcons;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.gwcomponent.GWPopupMenu;
import com.novell.gw.jclient.application.controls.menus.PopupMenuFactory;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientableList;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.GWAttachment;
import com.novell.gw.jclient.bl.om.options.EnvironmentOptions;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.Serializable;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.UIResource;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EnvelopMessageTreePopup
extends GWPopupMenu {
    private static Logger logger = Logger.getLogger(EnvelopMessageTreePopup.class);
    private IdentifiedObject selectedItem;
    private AbstractItem item;
    private boolean showAttachments;
    private MVCController controller;
    private DefaultListModel model = new DefaultListModel();
    private JPopupMenu popupMenu;
    private MessagePopupMenuListener popupMenuListener = new MessagePopupMenuListener();
    private WindowFocusListener windowFocusListener = new EMTPWindowFocusListener();
    private boolean canHide = true;
    private JList listMessageTree = new OrientableList();
    private boolean hideSystemAttachments;

    public EnvelopMessageTreePopup(MVCController theController) {
        EnvironmentOptions environmentOptions = OptionManager.getInstance().getEnvironmentOptions();
        this.hideSystemAttachments = environmentOptions.isHideSystemAttachments();
        this.controller = theController;
        this.listMessageTree.addMouseMotionListener(new MotionListener());
        this.listMessageTree.addMouseListener(new MouseListener());
        this.listMessageTree.setCellRenderer(new Renderer());
        OrientableScrollPane scroll = new OrientableScrollPane(this.listMessageTree);
        scroll.setBorder(null);
        this.add(scroll);
    }

    public void rebuild(boolean showAttachments) {
        this.model.clear();
        this.showAttachments = showAttachments;
        ItemWrapper root = new ItemWrapper(0, this.item);
        this.model.addElement(root);
        this.buildTreeNodes(root, this.item.getAttachments());
        this.listMessageTree.setModel(this.model);
    }

    @Override
    public void show(Component invoker, int x, int y) {
        super.show(invoker, x, y);
        SwingUtilities.getWindowAncestor(invoker).addWindowFocusListener(this.windowFocusListener);
    }

    public void setSelectedObject(IdentifiedObject selectedObject) {
        this.selectedItem = selectedObject;
    }

    public void rebuild(AbstractItem theParentItem, IdentifiedObject theSelectedItem, boolean showAttachments) {
        this.item = theParentItem;
        this.selectedItem = theSelectedItem;
        this.rebuild(showAttachments);
    }

    private void buildTreeNodes(ItemWrapper theNode, List<GWAttachment> attachments) {
        int level = theNode.getItemLevel();
        for (GWAttachment attachment : attachments) {
            if (attachment.isMessageAttachment()) {
                String userGuid = ControlsUtils.getUserGuid(this.controller);
                AbstractItem enclosedItem = attachment.getEnclosedItem(userGuid);
                ItemWrapper node = new ItemWrapper(level + 1, enclosedItem);
                this.model.addElement(node);
                this.buildTreeNodes(node, enclosedItem.getAttachments());
                continue;
            }
            if (!this.showAttachments || attachment.isSystemAttachment() && this.hideSystemAttachments) continue;
            this.model.addElement(new ItemWrapper(level + 1, attachment));
        }
    }

    private void updateSelection(MouseEvent e) {
        int index = this.listMessageTree.locationToIndex(e.getPoint());
        this.listMessageTree.setSelectedIndex(index);
    }

    private void selectGWItem() {
        if (this.popupMenu != null) {
            this.popupMenu.setVisible(false);
        }
        this.selectedItem = ((ItemWrapper)this.listMessageTree.getSelectedValue()).getItem();
        this.setVisible(false);
        Command command = new Command(1030, this.selectedItem);
        this.controller.processCommand(command);
    }

    public void setHideSystemAttachments(boolean hideSystemAttachments) {
        this.hideSystemAttachments = hideSystemAttachments;
    }

    private static boolean isLeftToRight() {
        return UIUtils.getComponentOrientation().isLeftToRight();
    }

    @Override
    public void setVisible(boolean b) {
        Container parent;
        if (!b && !this.canHide) {
            return;
        }
        if (!b && (parent = this.getParent()) != null) {
            SwingUtilities.getWindowAncestor(this.getInvoker()).removeWindowFocusListener(this.windowFocusListener);
        }
        super.setVisible(b);
    }

    private class EMTPWindowFocusListener
    implements WindowFocusListener {
        private EMTPWindowFocusListener() {
        }

        public void windowGainedFocus(WindowEvent e) {
        }

        public void windowLostFocus(WindowEvent e) {
            if (EnvelopMessageTreePopup.this.popupMenu == null || !EnvelopMessageTreePopup.this.popupMenu.isVisible()) {
                EnvelopMessageTreePopup.this.canHide = true;
                EnvelopMessageTreePopup.this.setVisible(false);
            }
        }
    }

    private static class CheckBoxMenuItemIcon
    implements Icon,
    UIResource,
    Serializable {
        private CheckBoxMenuItemIcon() {
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.drawLine(x + 7, y + 1, x + 7, y + 3);
            g.drawLine(x + 6, y + 2, x + 6, y + 4);
            g.drawLine(x + 5, y + 3, x + 5, y + 5);
            g.drawLine(x + 4, y + 4, x + 4, y + 6);
            g.drawLine(x + 3, y + 5, x + 3, y + 7);
            g.drawLine(x + 2, y + 4, x + 2, y + 6);
            g.drawLine(x + 1, y + 3, x + 1, y + 5);
        }

        public int getIconWidth() {
            return 13;
        }

        public int getIconHeight() {
            return 13;
        }
    }

    private class MessagePopupMenuListener
    implements PopupMenuListener {
        private MessagePopupMenuListener() {
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            EnvelopMessageTreePopup.this.canHide = false;
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            EnvelopMessageTreePopup.this.canHide = true;
        }

        public void popupMenuCanceled(PopupMenuEvent e) {
            EnvelopMessageTreePopup.this.canHide = true;
            EnvelopMessageTreePopup.this.setVisible(false);
        }
    }

    private static class ItemWrapper {
        private int itemLevel;
        private IdentifiedObject item;

        public ItemWrapper(int itemLevel, IdentifiedObject item) {
            this.itemLevel = itemLevel;
            this.item = item;
        }

        public int getItemLevel() {
            return this.itemLevel;
        }

        public IdentifiedObject getItem() {
            return this.item;
        }

        public String toString() {
            return this.item.toString();
        }
    }

    private class MouseListener
    extends MouseAdapter {
        private MouseListener() {
        }

        private boolean isOnListItem(Point point) {
            Rectangle rectangle = EnvelopMessageTreePopup.this.listMessageTree.getCellBounds(0, EnvelopMessageTreePopup.this.listMessageTree.getModel().getSize() - 1);
            return rectangle.contains(point);
        }

        public void mousePressed(MouseEvent e) {
            if (this.isOnListItem(e.getPoint())) {
                if (e.isPopupTrigger()) {
                    this.showPopup(e);
                }
                if (SwingUtilities.isLeftMouseButton(e)) {
                    EnvelopMessageTreePopup.this.selectGWItem();
                }
            }
        }

        private void showPopup(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            if (EnvelopMessageTreePopup.this.listMessageTree.getParent() instanceof JViewport) {
                JViewport viewport = (JViewport)EnvelopMessageTreePopup.this.listMessageTree.getParent();
                y -= viewport.getViewPosition().y;
            }
            IdentifiedObject selectedValue = ((ItemWrapper)((JList)e.getComponent()).getSelectedValue()).getItem();
            if (EnvelopMessageTreePopup.this.popupMenu != null) {
                EnvelopMessageTreePopup.this.popupMenu.setVisible(false);
                EnvelopMessageTreePopup.this.popupMenu.removePopupMenuListener(EnvelopMessageTreePopup.this.popupMenuListener);
            }
            if (selectedValue instanceof GWAttachment || selectedValue instanceof AbstractItem) {
                logger.debug((Object)("selectedValue: " + selectedValue));
                EnvelopMessageTreePopup.this.popupMenu = PopupMenuFactory.createAttachmentsPopupMenu(EnvelopMessageTreePopup.this.controller, selectedValue);
                EnvelopMessageTreePopup.this.canHide = false;
                EnvelopMessageTreePopup.this.popupMenu.addPopupMenuListener(EnvelopMessageTreePopup.this.popupMenuListener);
                EnvelopMessageTreePopup.this.popupMenu.show(EnvelopMessageTreePopup.this.getParent(), x, y);
            }
        }
    }

    private class MotionListener
    extends MouseMotionAdapter {
        private MotionListener() {
        }

        public void mouseMoved(MouseEvent e) {
            EnvelopMessageTreePopup.this.updateSelection(e);
        }
    }

    private class Renderer
    extends OrientablePanel
    implements ListCellRenderer {
        private JLabel lblItem = new OrientableLabel();
        private JLabel lblSelection = new OrientableLabel();
        private CheckBoxMenuItemIcon checkBoxMenuItemIcon = new CheckBoxMenuItemIcon();
        public static final int GAP = 10;

        public Renderer() {
            this.lblItem.setOpaque(false);
            this.lblSelection.setOpaque(false);
            this.setLayout(new BorderLayout());
            this.add((Component)this.lblSelection, "Before");
            this.add((Component)this.lblItem, "Center");
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            ItemWrapper wrapper = (ItemWrapper)value;
            IdentifiedObject item = wrapper.getItem();
            if (item instanceof AbstractItem) {
                this.lblItem.setIcon(ControlsUtils.getImageForGWItem((AbstractItem)item));
            } else {
                GWAttachment attachment = (GWAttachment)item;
                this.lblItem.setIcon(ControlsUtils.getSmallIconForAttachment(attachment.getFileName(), attachment.getDownloadState()));
            }
            this.lblItem.setText(item.toString());
            int inset = 10 * wrapper.getItemLevel();
            if (EnvelopMessageTreePopup.isLeftToRight()) {
                this.setBorder(BorderFactory.createEmptyBorder(5, inset + 5, 5, 5));
            } else {
                this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, inset + 5));
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            if (item.equals(EnvelopMessageTreePopup.this.selectedItem)) {
                this.lblSelection.setIcon(this.checkBoxMenuItemIcon);
            } else {
                this.lblSelection.setIcon(GWIcons.EMPTY_ICON);
            }
            return this;
        }
    }
}

