/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.itemview;

import com.appframework.components.htmleditor.HTMLViewer;
import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.novell.gw.engine.EngineException;
import com.novell.gw.jclient.api.enums.FolderType;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendar;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.ItemBox;
import com.novell.gw.jclient.application.controls.itemlisttable.lastlevel.ItemListTable;
import com.novell.gw.jclient.application.controls.itemview.CheckListViewPanel;
import com.novell.gw.jclient.application.controls.itemview.GWItemPropertiesPersonalizePanel;
import com.novell.gw.jclient.application.controls.itemview.ItemProperties;
import com.novell.gw.jclient.application.controls.itemview.MessageSource;
import com.novell.gw.jclient.application.controls.itemview.QuickViewerController;
import com.novell.gw.jclient.application.controls.itemview.QuickViewerShowUpInfoProvider;
import com.novell.gw.jclient.application.controls.itemview.QuickViewerToolBarsPanelsPane;
import com.novell.gw.jclient.application.controls.itemview.itemviewer.ItemViewer;
import com.novell.gw.jclient.application.controls.orientable.OrientableTabbedPane;
import com.novell.gw.jclient.application.interfaces.ISelectedItemsInfo;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.MessageUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FocusTraversalPolicy;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuickViewer
extends JPanel
implements MVCView<QuickViewerController, AbstractItem>,
ItemBox {
    private static Logger logger = Logger.getLogger(QuickViewer.class);
    public static final Set<Class> SELECTION_EVENT_SOURCES = new HashSet<Class>();
    private QuickViewerController controller;
    private JTabbedPane tabView = new OrientableTabbedPane();
    private CheckListViewPanel tabCheckList = null;
    private ItemViewer tabItemViewer;
    private ItemProperties tabItemProperties;
    private MessageSource tabMessageSource = null;
    private GWItemPropertiesPersonalizePanel tabItemPersonalize;
    private AbstractItem item;
    private String lastMarkedReadLaterItemId = null;
    private CurrentTabChangeListener tabViewChangeListener;
    private QuickViewerShowUpInfoProvider showUpInfoProvider;

    public QuickViewer(MVCController theParentController, QuickViewerShowUpInfoProvider showUpInfoProvider) {
        super(new BorderLayout());
        this.showUpInfoProvider = showUpInfoProvider;
        this.controller = new QuickViewerController(this, theParentController);
        this.setHidden(true);
        this.build();
    }

    private void build() {
        this.tabItemViewer = new ItemViewer(this.controller, "ATTACHLIST_SPLITPOS_QW", false);
        this.tabItemProperties = new ItemProperties(this.getController());
        this.tabItemPersonalize = new GWItemPropertiesPersonalizePanel(this.controller, null);
        QuickViewerToolBarsPanelsPane toolbarsPanel = new QuickViewerToolBarsPanelsPane(this.controller);
        this.tabView.addTab(StringResources.NO_ITEM, this.tabItemViewer);
        this.tabView.setSelectedIndex(this.tabView.indexOfComponent(this.tabItemViewer));
        this.add((Component)this.tabView, "Center");
        this.tabViewChangeListener = new CurrentTabChangeListener();
        this.tabView.addChangeListener(this.tabViewChangeListener);
        this.add((Component)toolbarsPanel, "North");
    }

    public JComponent getTextComponent() {
        return this.tabItemViewer.getComponentForFocus();
    }

    @Override
    public void setController(QuickViewerController theController) {
        this.controller = theController;
    }

    @Override
    public QuickViewerController getController() {
        return this.controller;
    }

    @Override
    public void setMVCModel(AbstractItem model) {
        if (this.item != null && this.item.equals(model)) {
            return;
        }
        this.item = model;
        this.setItem(this.item);
    }

    @Override
    public AbstractItem getMVCModel() {
        return this.item;
    }

    public void setHidden(boolean b) {
        logger.debug((Object)("QuickViewer " + (b ? "disabled" : "enabled")));
        this.controller.setEnabled(!b);
        if (!b) {
            ISelectedItemsInfo selectedItems = this.showUpInfoProvider.getSelectedItemsInfo();
            if (selectedItems != null && selectedItems.hasItems() && selectedItems.getItems().size() == 1) {
                this.processGWItemSelected(selectedItems.getItems().get(0));
            } else {
                this.setMVCModel(null);
            }
        }
    }

    public boolean isHidden() {
        return !this.controller.isEnabled();
    }

    public FocusTraversalPolicy getFocusPolicy() {
        return this.tabItemViewer.getFocusPolicy();
    }

    void processGWItemMarkedReadLater(String itemId) {
        logger.debug((Object)("item marked as 'read later', itemId = " + itemId));
        this.lastMarkedReadLaterItemId = itemId;
    }

    void processGWItemSelected(AbstractItem item) {
        try {
            if (!this.isHidden()) {
                String itemId = item.getID();
                assert (itemId != null) : "itemId is null";
                if (itemId.equals(this.lastMarkedReadLaterItemId)) {
                    logger.debug((Object)("not markin item(" + item + ") as 'open', it just was marked as 'read later'"));
                } else {
                    logger.debug((Object)("markin item(" + item + ") as 'open'"));
                    item.markOpen();
                    this.lastMarkedReadLaterItemId = null;
                }
            }
        }
        catch (EngineException e) {
            logger.error((Object)e, (Throwable)e);
        }
        this.setMVCModel(item);
    }

    public String getSelectedText() {
        return ((HTMLViewer)this.tabItemViewer.getComponentForFocus()).getSelectedText();
    }

    private void updateSelectedPanel(Component selectedComponent) {
        assert (selectedComponent instanceof ItemBox) : "selectedComponent does not implement ItemBox: " + selectedComponent;
        ((ItemBox)((Object)selectedComponent)).loadContent();
        if (this.item != null) {
            if (selectedComponent == this.tabItemProperties) {
                this.getController().processCommand(new Command(1360));
            } else if (selectedComponent == this.tabItemViewer) {
                this.getController().processCommand(new Command(1350));
            } else if (selectedComponent == this.tabItemPersonalize) {
                logger.debug((Object)"personalize tab selected");
                this.tabItemPersonalize.processPanelSelected();
            }
        }
    }

    public void release() {
        logger.debug((Object)"releasing QuickViewer....");
        this.removeAll();
        if (this.tabItemProperties != null) {
            this.tabItemProperties.release();
            this.tabItemProperties = null;
        }
        if (this.tabItemViewer != null) {
            this.tabItemViewer.release();
            this.tabItemViewer = null;
        }
        if (this.tabCheckList != null) {
            this.tabCheckList.release();
            this.tabCheckList = null;
        }
        if (this.tabItemPersonalize != null) {
            this.tabItemPersonalize.release();
            this.tabItemPersonalize = null;
        }
        if (this.tabMessageSource != null) {
            this.tabMessageSource.release();
            this.tabMessageSource = null;
        }
        logger.debug((Object)".....QuickViewer released");
    }

    @Override
    public void setItem(AbstractItem item) {
        this.tabView.removeChangeListener(this.tabViewChangeListener);
        this.updateTabItemView(item);
        this.updateTabProperties(item);
        this.updateTabPersonalize(item);
        this.updateTabMessageSource(item);
        this.updateTabChecklist(item);
        this.loadContent();
        this.tabView.addChangeListener(this.tabViewChangeListener);
    }

    @Override
    public AbstractItem getItem() {
        return this.item;
    }

    @Override
    public void loadContent() {
        Component selectedTab = this.tabView.getSelectedComponent();
        assert (selectedTab instanceof ItemBox) : "tab does not implement ItemBox";
        ((ItemBox)((Object)selectedTab)).loadContent();
    }

    private void updateTabItemView(AbstractItem item) {
        int index = this.tabView.indexOfComponent(this.tabItemViewer);
        if (item == null) {
            this.tabView.setTitleAt(index, StringResources.NO_ITEM);
        } else {
            this.tabView.setTitleAt(index, ControlsUtils.getItemTypeName(item));
        }
        this.tabItemViewer.setItem(item);
    }

    private void updateTabPersonalize(AbstractItem item) {
        boolean showTab = MessageUtils.canShowPersonalizeTab(item);
        this.updateTab(this.tabItemPersonalize, showTab, item, 2);
    }

    private void updateTabMessageSource(AbstractItem item) {
        boolean showTab;
        boolean bl = showTab = item != null && !item.isPersonal() && !item.isDraft() && item.hasSourceAttachment();
        if (showTab || this.tabMessageSource != null) {
            if (this.tabMessageSource == null) {
                this.tabMessageSource = new MessageSource(this.getController());
            }
            this.updateTab(this.tabMessageSource, showTab, item, 3);
        }
    }

    private void updateTabChecklist(AbstractItem item) {
        boolean showTab;
        boolean bl = showTab = item != null && item.isInChecklist() && item.getNativeItem().getViewFolder().getType() == FolderType.CHECKLIST;
        if (showTab || this.tabCheckList != null) {
            if (this.tabCheckList == null) {
                this.tabCheckList = new CheckListViewPanel(this.controller);
            }
            this.updateTab(this.tabCheckList, showTab, this.item, 4);
        }
    }

    private void updateTabProperties(AbstractItem item) {
        boolean showTab = item != null && !item.isPersonal() && item.canDoInfo();
        this.updateTab(this.tabItemProperties, showTab, item, 1);
    }

    private void updateTab(Component tab, boolean showTab, AbstractItem item, int index) {
        boolean isShown;
        assert (tab instanceof ItemBox) : "unexpected tab (showTab = " + showTab + "): " + tab;
        boolean bl = isShown = this.tabView.indexOfComponent(tab) != -1;
        if (index >= this.tabView.getTabCount()) {
            index = this.tabView.getTabCount();
        }
        if (showTab) {
            if (!isShown) {
                this.tabView.insertTab(tab.getName(), null, tab, null, index);
            }
            ((ItemBox)((Object)tab)).setItem(item);
        } else if (isShown) {
            this.tabView.remove(tab);
        }
    }

    static {
        SELECTION_EVENT_SOURCES.add(ItemListTable.class);
        SELECTION_EVENT_SOURCES.add(GWCalendar.class);
    }

    private class CurrentTabChangeListener
    implements ChangeListener {
        private CurrentTabChangeListener() {
        }

        public void stateChanged(ChangeEvent event) {
            QuickViewer.this.updateSelectedPanel(QuickViewer.this.tabView.getSelectedComponent());
        }
    }
}

