/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.itemview;

import com.appframework.ActionList;
import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.toolbars.ApplicationFrameToolBar;
import com.novell.gw.jclient.application.controls.toolbars.AppointmentOperationsToolBar;
import com.novell.gw.jclient.application.controls.toolbars.ItemOperationsEmptyToolBar;
import com.novell.gw.jclient.application.controls.toolbars.ItemOperationsToolBar;
import com.novell.gw.jclient.application.controls.toolbars.QuickViewerToolBar;
import com.novell.gw.jclient.application.controls.toolbars.ReminderNoteOperationsToolBar;
import com.novell.gw.jclient.application.controls.toolbars.SentItemOperationsToolBar;
import com.novell.gw.jclient.application.controls.toolbars.TaskOperationsToolBar;
import com.novell.gw.jclient.application.controls.toolbars.ext.DragableHeaderToolBar;
import com.novell.gw.jclient.application.controls.toolbars.ext.DropableToolBarsPanel;
import com.novell.gw.jclient.application.controls.toolbars.ext.HeaderToolBar;
import com.novell.gw.jclient.application.controls.toolbars.ext.ToolBarUtils;
import com.novell.gw.jclient.application.controls.toolbars.ext.ToolBarsPanelsPane;
import com.novell.gw.jclient.application.frames.search.FrameItemSearchActionList;
import com.novell.gw.jclient.application.options.ApplicationOptions;
import com.novell.gw.jclient.application.options.OptionManager;
import java.awt.Component;
import java.awt.Container;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JToolBar;
import org.apache.log4j.Logger;

class QuickViewerToolBarsPanelsPane
extends ToolBarsPanelsPane {
    private static Logger logger = Logger.getLogger(QuickViewerToolBarsPanelsPane.class);
    private static final int DEFAULT_ITEM_CONTEXT_TOOLBAR_ROW = 0;
    private static final int DEFAULT_QUICK_VIEWER_TOOLBAR_ROW = 1;
    private static final int DEFAULT_TOOLBAR_LOCATION_AT_ROW = 0;
    private static final int MAX_NUMBER_OF_TOOLBARS = 2;
    private DragableHeaderToolBar htlbItemContext = new DragableHeaderToolBar();
    private DragableHeaderToolBar htlbQuickViewer = new DragableHeaderToolBar();
    private Map<Class<? extends ApplicationFrameToolBar>, ApplicationFrameToolBar> toolBars = new HashMap<Class<? extends ApplicationFrameToolBar>, ApplicationFrameToolBar>();
    private JToolBar itemContextToolbar = null;
    private QuickViewerToolBar toolbarQuickViewer;

    public QuickViewerToolBarsPanelsPane(MVCController parentController) {
        super(parentController);
        this.init();
    }

    private void init() {
        ActionList actionList = this.getController().getActionList();
        long time = System.currentTimeMillis();
        this.toolBars.put(ItemOperationsToolBar.class, new ItemOperationsToolBar(actionList));
        this.toolBars.put(ItemOperationsEmptyToolBar.class, new ItemOperationsEmptyToolBar(actionList));
        this.toolBars.put(SentItemOperationsToolBar.class, new SentItemOperationsToolBar(actionList));
        this.toolBars.put(AppointmentOperationsToolBar.class, new AppointmentOperationsToolBar(actionList));
        this.toolBars.put(TaskOperationsToolBar.class, new TaskOperationsToolBar(actionList));
        this.toolBars.put(ReminderNoteOperationsToolBar.class, new ReminderNoteOperationsToolBar(actionList));
        logger.debug((Object)("toolbars creation time, ms: " + (System.currentTimeMillis() - time)));
        this.toolbarQuickViewer = new QuickViewerToolBar(actionList);
        for (int i = 0; i < 2; ++i) {
            DropableToolBarsPanel dropablePanel = this.buildDropableToolBarsPanel(i);
            if (dropablePanel == null) continue;
            this.add(dropablePanel);
        }
        this.htlbQuickViewer.setToolBar(this.toolbarQuickViewer);
    }

    public void saveToolbarsPositions() {
        Container toolbarSlot;
        JToolBar toolbar;
        Container toolbarParent;
        Component[] components;
        for (Component component : components = this.getComponents()) {
            if (!(component instanceof Container) || ((Container)component).getComponents().length != 0) continue;
            this.remove(component);
        }
        components = this.getComponents();
        if (components.length > 2) {
            logger.warn((Object)("Too many components: " + components.length));
            logger.warn((Object)"Tool bars positions will NOT be saved!");
            return;
        }
        String optionsPrefix = "QUICK_VIEWER.";
        if (QuickViewerToolBarsPanelsPane.isItemContextToolBarVisible() && (toolbarParent = (toolbar = this.itemContextToolbar).getParent()) instanceof DragableHeaderToolBar && (toolbarSlot = toolbarParent.getParent()) instanceof DropableToolBarsPanel) {
            int toolbarSlotIndex = ToolBarUtils.indexOf(toolbarSlot);
            ApplicationOptions.getInstance().put(optionsPrefix + "TOOLBAR_ITEM_CONTEXT" + "." + "TOOLBAR_ROW", toolbarSlotIndex);
            ApplicationOptions.getInstance().put(optionsPrefix + "TOOLBAR_ITEM_CONTEXT" + "." + "TOOLBAR_LOCATION_AT_ROW", toolbarParent.getLocation().x);
        }
        if ((toolbar = this.toolbarQuickViewer) != null && (toolbarParent = toolbar.getParent()) instanceof DragableHeaderToolBar && (toolbarSlot = toolbarParent.getParent()) instanceof DropableToolBarsPanel) {
            int toolbarSlotIndex = ToolBarUtils.indexOf(toolbarSlot);
            ApplicationOptions.getInstance().put(optionsPrefix + "TOOLBAR_QUICK_VIEWER" + "." + "TOOLBAR_ROW", toolbarSlotIndex);
            ApplicationOptions.getInstance().put(optionsPrefix + "TOOLBAR_QUICK_VIEWER" + "." + "TOOLBAR_LOCATION_AT_ROW", toolbarParent.getLocation().x);
        }
    }

    public void updateToolbars() {
        this.rebuildItemContextToolbar();
    }

    protected DropableToolBarsPanel buildDropableToolBarsPanel(int rowIndex) {
        if (rowIndex >= 2 || rowIndex < 0) {
            throw new IllegalArgumentException("illegal rowIndex: " + rowIndex);
        }
        String optionsPrefix = "QUICK_VIEWER.";
        int itemContextToolBarRow = ApplicationOptions.getInstance().getInteger(optionsPrefix + "TOOLBAR_ITEM_CONTEXT" + "." + "TOOLBAR_ROW", 0);
        int itemContextToolBarShift = ApplicationOptions.getInstance().getInteger(optionsPrefix + "TOOLBAR_ITEM_CONTEXT" + "." + "TOOLBAR_LOCATION_AT_ROW", 0);
        int quickViewerToolBarRow = ApplicationOptions.getInstance().getInteger(optionsPrefix + "TOOLBAR_QUICK_VIEWER" + "." + "TOOLBAR_ROW", 1);
        int quickViewerToolBarShift = ApplicationOptions.getInstance().getInteger(optionsPrefix + "TOOLBAR_QUICK_VIEWER" + "." + "TOOLBAR_LOCATION_AT_ROW", 0);
        logger.debug((Object)("Item Context toolbar row = " + itemContextToolBarRow + ", shift = " + itemContextToolBarShift));
        logger.debug((Object)("Quick Viewer toolbar row = " + quickViewerToolBarRow + ", shift = " + quickViewerToolBarShift));
        if (itemContextToolBarRow != rowIndex && quickViewerToolBarRow != rowIndex) {
            return null;
        }
        DropableToolBarsPanel dropablePanel = new DropableToolBarsPanel();
        TreeMap<Integer, DragableHeaderToolBar> shiftsAndToolbars = new TreeMap<Integer, DragableHeaderToolBar>();
        if (itemContextToolBarRow == rowIndex) {
            shiftsAndToolbars.put(itemContextToolBarShift, this.htlbItemContext);
        }
        if (quickViewerToolBarRow == rowIndex) {
            if (shiftsAndToolbars.containsKey(quickViewerToolBarShift)) {
                logger.info((Object)"shift of quick tabItemViewer toolbar fixed");
                quickViewerToolBarShift += 100;
            }
            shiftsAndToolbars.put(quickViewerToolBarShift, this.htlbQuickViewer);
        }
        HeaderToolBar previousPanel = null;
        int previousShift = 0;
        for (Integer shift : shiftsAndToolbars.keySet()) {
            HeaderToolBar panel = (HeaderToolBar)shiftsAndToolbars.get(shift);
            dropablePanel.add(panel);
            if (previousPanel != null) {
                previousPanel.setCurrentWidth(shift - previousShift);
            }
            previousPanel = panel;
            previousShift = shift;
        }
        return dropablePanel;
    }

    private void rebuildItemContextToolbar() {
        boolean showToolbar = this.itemContextToolbar == null ? false : (this.getController().getParentController() instanceof FrameItemSearchActionList ? OptionManager.getInstance().getQuickViewerOptions().isShowQVToolbar() : ApplicationOptions.getInstance().getBoolean("ITEM_CONTEXT_TOOLBAR_VISIBLE", true));
        if (showToolbar) {
            if (this.itemContextToolbar != null && !this.itemContextToolbar.equals(this.htlbItemContext.getToolBar())) {
                this.htlbItemContext.setToolBar(this.itemContextToolbar);
            }
            this.htlbItemContext.setVisible(true);
        } else {
            this.htlbItemContext.setVisible(false);
        }
    }

    private static boolean isItemContextToolBarVisible() {
        return ApplicationOptions.getInstance().getBoolean("ITEM_CONTEXT_TOOLBAR_VISIBLE", true);
    }

    private void updateItemContextToolbar() {
        if (this.isSingleItemSelected()) {
            Class<? extends ApplicationFrameToolBar> toolbarClass = ControlsUtils.getItemToolbarClass(this.selectedItemsInfo.getItem());
            this.itemContextToolbar = this.toolBars.get(toolbarClass);
        }
    }

    protected void processMultipleContactsSelected() {
        this.updateItemContextToolbar();
        this.updateToolbars();
    }

    protected void processMultipleItemsSelected() {
        this.updateItemContextToolbar();
        this.updateToolbars();
    }

    protected void processNoContactSelected() {
        this.updateItemContextToolbar();
        this.updateToolbars();
    }

    protected void processNoItemSelected() {
        this.updateItemContextToolbar();
        this.updateToolbars();
    }

    protected void processSingleContactSelected() {
        this.updateItemContextToolbar();
        this.updateToolbars();
    }

    protected void processSingleItemSelected() {
        this.updateItemContextToolbar();
        this.updateToolbars();
    }

    protected void processActionSwitchQvToolbar() {
        this.updateToolbars();
    }
}

