/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.itemview;

import com.novell.gw.jclient.application.controls.skinnable.SkinnableLabel;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.SwingUtilities;

public class UnderlinableLabel
extends SkinnableLabel
implements FocusListener {
    private Rectangle paintIconR = new Rectangle();
    private Rectangle paintTextR = new Rectangle();
    private Rectangle paintViewR = new Rectangle();
    private Insets paintViewInsets = new Insets(0, 0, 0, 0);
    private String textValue = "";
    private boolean textVisible = true;

    public UnderlinableLabel() {
        this.skinnableDelegate.clearPropertyBindings();
        this.setFocusable(true);
        this.addFocusListener(this);
    }

    public void paint(Graphics g) {
        if (this.isFocusOwner()) {
            FontMetrics fm = g.getFontMetrics();
            Insets insets = this.getInsets(this.paintViewInsets);
            this.paintViewR.x = insets.left;
            this.paintViewR.y = insets.top;
            this.paintViewR.width = this.getWidth() - (insets.left + insets.right);
            this.paintViewR.height = this.getHeight() - (insets.top + insets.bottom);
            this.paintIconR.height = 0;
            this.paintIconR.width = 0;
            this.paintIconR.y = 0;
            this.paintIconR.x = 0;
            this.paintTextR.height = 0;
            this.paintTextR.width = 0;
            this.paintTextR.y = 0;
            this.paintTextR.x = 0;
            SwingUtilities.layoutCompoundLabel(this, fm, this.getText(), this.getIcon(), this.getVerticalAlignment(), this.getHorizontalAlignment(), this.getVerticalTextPosition(), this.getHorizontalTextPosition(), this.paintViewR, this.paintIconR, this.paintTextR, this.getIconTextGap());
            g.setColor(this.getForeground());
            g.drawLine(this.paintTextR.x, this.paintTextR.y + this.paintTextR.height - 1, this.paintTextR.x + this.paintTextR.width, this.paintTextR.y + this.paintTextR.height - 1);
        }
        super.paint(g);
    }

    public String getTextValue() {
        return this.textValue;
    }

    public String getText() {
        return this.textVisible ? this.textValue : "";
    }

    public void setText(String text) {
        this.textValue = text;
        super.setText(this.textVisible ? this.textValue : "");
    }

    public boolean isTextVisible() {
        return this.textVisible;
    }

    public void setTextVisible(boolean textVisible) {
        this.textVisible = textVisible;
        this.setText(this.textValue);
    }

    public void focusGained(FocusEvent e) {
        this.repaint();
    }

    public void focusLost(FocusEvent e) {
        this.repaint();
    }

    public String getName() {
        return "StorageSwitcher";
    }
}

