/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.itemview.contentviewer;

import com.appframework.components.htmleditor.HTMLViewer;
import com.appframework.utils.NetUtils;
import com.novell.gw.jclient.application.controls.itemview.contentviewer.HTMLHyperlinkListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.apache.log4j.Logger;

public class HTMLViewerHyperlinkListener
extends HTMLHyperlinkListener
implements HyperlinkListener {
    private static Logger logger = Logger.getLogger(HTMLViewerHyperlinkListener.class);
    protected HTMLViewer htmlViewer;

    public HTMLViewerHyperlinkListener() {
    }

    public HTMLViewerHyperlinkListener(HTMLViewer htmlViewer) {
        this();
        this.htmlViewer = htmlViewer;
    }

    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType().toString().equals(HyperlinkEvent.EventType.ACTIVATED.toString())) {
            this.processURL(e.getURL().toString());
        }
    }

    public void processURL(String url) {
        if (url.toLowerCase().startsWith("www.")) {
            url = "http://" + url;
        } else if (url.toLowerCase().startsWith("ftp.")) {
            url = "ftp://" + url;
        } else if (url.indexOf(64) > 0 && url.indexOf(47) == -1 && !url.toLowerCase().startsWith("mailto:")) {
            url = "mailto:" + url;
        }
        if (this.htmlViewer != null && !NetUtils.isMailtoUrl(url)) {
            try {
                URL page = NetUtils.createUrl(url);
                logger.debug((Object)("URL: " + page));
                this.htmlViewer.setPage(page);
            }
            catch (MalformedURLException e) {
                logger.error((Object)e);
                logger.debug((Object)e, (Throwable)e);
            }
        } else {
            super.processURL(url);
        }
    }
}

