/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.itemview.imageviewer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.ParameterBlock;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.swing.Icon;

public class ImageViewIcon
implements Icon {
    protected RenderedImage im;
    protected SampleModel sampleModel;
    protected ColorModel colorModel;
    protected int minX;
    protected int minY;
    protected int width;
    protected int height;
    protected Rectangle imageBounds;
    protected int minTileX;
    protected int maxTileX;
    protected int minTileY;
    protected int maxTileY;
    protected int tileWidth;
    protected int tileHeight;
    protected int tileGridXOffset;
    protected int tileGridYOffset;
    protected int originX;
    protected int originY;
    private Color backgroundColor = null;

    public ImageViewIcon(RenderedImage im, Color theBackgroundColor) {
        int mx = im.getMinX();
        int my = im.getMinY();
        if (mx < 0 || my < 0) {
            ParameterBlock pb = new ParameterBlock();
            pb.addSource(im);
            pb.add((float)Math.max(-mx, 0));
            pb.add((float)Math.max(-my, 0));
            pb.add(new InterpolationNearest());
            im = JAI.create((String)"translate", (ParameterBlock)pb, null);
        }
        this.im = im;
        this.sampleModel = im.getSampleModel();
        this.colorModel = im.getColorModel();
        if (this.colorModel == null) {
            this.colorModel = PlanarImage.createColorModel((SampleModel)im.getSampleModel());
        }
        if (this.colorModel == null) {
            throw new IllegalArgumentException("ImageViewIcon is unable to display supplied RenderedImage.");
        }
        if (this.colorModel.getTransparency() != 1) {
            Object col = im.getProperty("background_color");
            this.backgroundColor = col instanceof Color ? (Color)col : theBackgroundColor;
        }
        this.minX = im.getMinX();
        this.minY = im.getMinY();
        this.width = im.getWidth();
        this.height = im.getHeight();
        this.imageBounds = new Rectangle(this.minX, this.minY, this.width, this.height);
        this.minTileX = im.getMinTileX();
        this.maxTileX = im.getMinTileX() + im.getNumXTiles() - 1;
        this.minTileY = im.getMinTileY();
        this.maxTileY = im.getMinTileY() + im.getNumYTiles() - 1;
        this.tileWidth = im.getTileWidth();
        this.tileHeight = im.getTileHeight();
        this.tileGridXOffset = im.getTileGridXOffset();
        this.tileGridYOffset = im.getTileGridYOffset();
        this.originY = 0;
        this.originX = 0;
    }

    public int getIconWidth() {
        return this.im.getWidth();
    }

    public int getIconHeight() {
        return this.im.getHeight();
    }

    public RenderedImage getImage() {
        return this.im;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2D = null;
        if (!(g instanceof Graphics2D)) {
            System.err.println("ImageViewIcon: not a Graphics2D.");
            return;
        }
        g2D = (Graphics2D)g;
        Rectangle clipBounds = g.getClipBounds();
        int transX = x;
        int transY = y;
        Rectangle imageRect = new Rectangle(this.minX + transX, this.minY + transY, this.width, this.height);
        if (clipBounds == null) {
            clipBounds = new Rectangle(0, 0, c.getWidth(), c.getHeight());
        }
        int txmin = PlanarImage.XToTileX((int)(clipBounds.x - transX), (int)this.tileGridXOffset, (int)this.tileWidth);
        txmin = Math.max(txmin, this.minTileX);
        txmin = Math.min(txmin, this.maxTileX);
        int txmax = PlanarImage.XToTileX((int)(clipBounds.x + clipBounds.width - 1 - transX), (int)this.tileGridXOffset, (int)this.tileWidth);
        txmax = Math.max(txmax, this.minTileX);
        txmax = Math.min(txmax, this.maxTileX);
        int tymin = PlanarImage.YToTileY((int)(clipBounds.y - transY), (int)this.tileGridYOffset, (int)this.tileHeight);
        tymin = Math.max(tymin, this.minTileY);
        tymin = Math.min(tymin, this.maxTileY);
        int tymax = PlanarImage.YToTileY((int)(clipBounds.y + clipBounds.height - 1 - transY), (int)this.tileGridYOffset, (int)this.tileHeight);
        tymax = Math.max(tymax, this.minTileY);
        tymax = Math.min(tymax, this.maxTileY);
        g2D.clip(imageRect);
        if (this.backgroundColor != null) {
            g2D.setColor(this.backgroundColor);
        }
        for (int tj = tymin; tj <= tymax; ++tj) {
            for (int ti = txmin; ti <= txmax; ++ti) {
                int tx = PlanarImage.tileXToX((int)ti, (int)this.tileGridXOffset, (int)this.tileWidth);
                int ty = PlanarImage.tileYToY((int)tj, (int)this.tileGridYOffset, (int)this.tileHeight);
                Raster tile = this.im.getTile(ti, tj);
                DataBuffer dataBuffer = tile.getDataBuffer();
                Point origin = new Point(0, 0);
                WritableRaster wr = Raster.createWritableRaster(this.sampleModel, dataBuffer, origin);
                BufferedImage bi = new BufferedImage(this.colorModel, wr, false, null);
                AffineTransform transform = AffineTransform.getTranslateInstance(tx + transX, ty + transY);
                if (this.backgroundColor != null) {
                    g2D.fillRect(tx + transX, ty + transY, this.tileWidth, this.tileHeight);
                }
                g2D.drawImage(bi, transform, null);
            }
        }
    }
}

