/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.itemview.itemviewer;

import com.appframework.components.htmleditor.HTMLExternalTextViewer;
import com.appframework.components.htmleditor.InvalidTextException;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.appframework.utils.Utils;
import com.novell.gw.engine.MachineSettings;
import com.novell.gw.jclient.api.enums.AttachmentDownloadState;
import com.novell.gw.jclient.application.GWClient;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.ActionSwitchAttachmentWindow;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.GWSplitPane;
import com.novell.gw.jclient.application.controls.attachmentlist.AttachmentView;
import com.novell.gw.jclient.application.controls.attachmentlist.OpenAttachmentView;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.ColorConstants;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.ItemBox;
import com.novell.gw.jclient.application.controls.itemview.EmbededParentView;
import com.novell.gw.jclient.application.controls.itemview.GWItemPropertiesPanel;
import com.novell.gw.jclient.application.controls.itemview.QuickViewerController;
import com.novell.gw.jclient.application.controls.itemview.contentviewer.ContentViewer;
import com.novell.gw.jclient.application.controls.itemview.itemviewer.ItemViewerController;
import com.novell.gw.jclient.application.controls.menus.GWMenu;
import com.novell.gw.jclient.application.controls.orientable.MenuItemFactory;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.frames.open.FrameOpenActionList;
import com.novell.gw.jclient.application.frames.search.FrameItemSearchActionList;
import com.novell.gw.jclient.application.options.ApplicationOptions;
import com.novell.gw.jclient.application.options.DividerPositionListener;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.GWEngineUtils;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.DocumentItem;
import com.novell.gw.jclient.bl.om.items.GWAttachment;
import com.novell.gw.jclient.bl.om.items.MessageBody;
import com.novell.gw.jclient.bl.om.items.MessageUtils;
import com.novell.gw.jclient.bl.om.options.EnvironmentOptions;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.FocusManager;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemViewer
extends JComponent
implements ItemBox,
MVCView<ItemViewerController, Object> {
    private static Logger logger = Logger.getLogger(ItemViewer.class);
    private static final Charset[] STANDARD_CROSSPLATFORM_CHARSETS = new Charset[]{Charset.forName("US-ASCII"), Charset.forName("ISO-8859-1"), Charset.forName("UTF-8"), Charset.forName("UTF-16BE"), Charset.forName("UTF-16LE"), Charset.forName("UTF-16")};
    private AttachmentView attachmentView;
    private JSplitPane splitPane;
    private AbstractItem<?> item;
    private AbstractItem currentItem;
    private ContentViewer contentViewer;
    private EmbededParentView embededParentView;
    private static final int DEVIDER_SIZE = 4;
    private static long MAX_PREVIEW_FILE_SIZE = 200000L;
    private boolean embededParentViewAdded;
    private DefaultMutableTreeNode itemsTree;
    private ItemViewerController controller;
    private FocusTraversalPolicy focusPolicy;
    private JPanel attachmentsPanel;
    private String splitterType;
    private GWAttachment attachment;
    private JPanel pnlInfo;
    private GWItemPropertiesPanel itemPropertiesPanel;
    private JPanel pnlHTMLMessageWarn;
    private AbstractFolder selectedFolder;
    private static int nextInstanceId = 0;
    private int instanceId = nextInstanceId++;
    private CharsetMenu charsetMenu = new CharsetMenu();

    public ItemViewer(MVCController theParentController, String splitterType, boolean handleSelectionCommands) {
        logger.debug((Object)("creating: " + this));
        this.splitterType = splitterType;
        this.setLayout(new BorderLayout());
        this.setDoubleBuffered(true);
        this.setOpaque(true);
        this.controller = new ItemViewerController(this, theParentController, handleSelectionCommands);
        this.contentViewer = new ContentViewer(this.controller);
        this.attachmentView = new OpenAttachmentView(true, this.controller);
        this.attachmentView.setPreferredSize(new Dimension(100, 60));
        this.attachmentView.setHideSystemAttachments(ItemViewer.isHideSystemAttachments());
        this.itemPropertiesPanel = new GWItemPropertiesPanel(this.controller);
        this.embededParentView = new EmbededParentView(this.controller);
        this.focusPolicy = new ViewerFocusPolicy();
        this.itemPropertiesPanel.setVisible(false);
        this.pnlInfo = new JPanel(new GridBagLayout());
        this.pnlHTMLMessageWarn = this.createHTMLWarnPanel();
        this.build();
    }

    private void buildEmbededMessageTree() {
        this.itemsTree = new DefaultMutableTreeNode(this.item);
        this.buildTreeNodes(this.itemsTree, this.item.getAttachments());
    }

    private AbstractItem getParentItemFor(AbstractItem theItem) {
        return ItemViewer.getParentItemFor(this.itemsTree, theItem);
    }

    private static AbstractItem getParentItemFor(DefaultMutableTreeNode parentNode, AbstractItem theItem) {
        if (parentNode == null) {
            return null;
        }
        int nCount = parentNode.getChildCount();
        for (int i = 0; i < nCount; ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)parentNode.getChildAt(i);
            if (node.getUserObject().equals(theItem)) {
                return (AbstractItem)parentNode.getUserObject();
            }
            AbstractItem result = ItemViewer.getParentItemFor(node, theItem);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private void buildTreeNodes(DefaultMutableTreeNode parentNode, List<GWAttachment> attachments) {
        for (GWAttachment attachment : attachments) {
            if (!attachment.isMessageAttachment()) continue;
            String userGuid = ControlsUtils.getUserGuid(this.controller);
            AbstractItem enclosedItem = attachment.getEnclosedItem(userGuid);
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(enclosedItem);
            parentNode.add(node);
            this.buildTreeNodes(node, enclosedItem.getAttachments());
        }
    }

    public void clear() {
        this.contentViewer.clear();
    }

    @Override
    public void loadContent() {
        logger.debug((Object)"loading content");
        if (this.item == null) {
            if (this.contentViewer != null) {
                this.contentViewer.clear();
            }
            if (this.itemPropertiesPanel != null) {
                this.itemPropertiesPanel.setVisible(false);
            }
            this.getController().updatePlainHTML();
        } else {
            if (this.itemPropertiesPanel != null) {
                this.itemPropertiesPanel.setVisible(true);
            }
            this.buildEmbededMessageTree();
            this.setCurrentItem(this.item);
            this.setupItemMessage();
            this.getController().updatePlainHTML();
            this.setShowAttachments();
            if (this.item instanceof DocumentItem) {
                this.attachmentView.selectAttachment(this.item.getAttachments().get(0));
            }
        }
    }

    public JMenu getCharsetMenu() {
        return this.charsetMenu;
    }

    @Override
    public AbstractItem getItem() {
        return this.item;
    }

    @Override
    public void setItem(AbstractItem item) {
        logger.debug((Object)("theItem: " + item));
        boolean showAttachments = ApplicationOptions.getInstance().getBoolean("ATTACHLIST_VISIBLE", true);
        this.item = item;
        this.currentItem = item;
        this.setEmbededParentViewVisible(false);
        if (this.pnlHTMLMessageWarn != null && this.pnlHTMLMessageWarn.isVisible()) {
            this.pnlHTMLMessageWarn.setVisible(false);
        }
        this.setAttachment(null);
        if (ApplicationOptions.getInstance().getBoolean("ATTACHLIST_VISIBLE", true) != showAttachments) {
            ActionSwitchAttachmentWindow action = (ActionSwitchAttachmentWindow)this.controller.getActionList().getAction(ActionKey.SWITCH_ATTACHMENT_WINDOW);
            action.performSwitch(showAttachments);
        }
    }

    @Override
    public Object getMVCModel() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setMVCModel(Object model) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setController(ItemViewerController controller) {
        throw new UnsupportedOperationException("This class does not allow to set controller externally.");
    }

    @Override
    public ItemViewerController getController() {
        return this.controller;
    }

    private void setCurrentItem(AbstractItem theItem) {
        this.attachmentView.setMVCModel(theItem);
        this.currentItem = theItem;
        this.itemPropertiesPanel.setParentItem(this.item);
        this.itemPropertiesPanel.setEmbeddedObject(theItem);
        this.itemPropertiesPanel.setMVCModel(theItem);
        this.pnlHTMLMessageWarn.setVisible(false);
        this.itemPropertiesPanel.setNotificationVisible(false);
    }

    boolean canSetAttachment() {
        return this.itemsTree != null;
    }

    void setAttachment(Object theObject) {
        assert (this.itemsTree != null) : "itemsTree not inited > exception may follow";
        if (theObject instanceof GWAttachment) {
            GWAttachment theAttachment = (GWAttachment)theObject;
            this.refreshAttachment(theAttachment);
            AbstractItem parentItem = theAttachment.getGwItem();
            if (parentItem != null) {
                this.currentItem = parentItem;
                this.itemPropertiesPanel.setEmbeddedObject(this.currentItem);
            }
            this.updateEmbededParentView();
            this.setAttachment(theAttachment);
        } else if (theObject instanceof AbstractItem) {
            AbstractItem theItem = (AbstractItem)theObject;
            if (!theItem.equals(this.currentItem) || this.isAttachmentSelected()) {
                this.viewEmbededMessage(theItem);
            }
            this.setAttachment(null);
        }
    }

    private void setAttachment(GWAttachment theAttachment) {
        this.attachment = theAttachment;
        if (this.attachment != null) {
            String fileExtension = Utils.getExtention(this.attachment.getFileName());
            this.charsetMenu.setEnabled(ControlsUtils.isText(fileExtension));
        } else {
            this.charsetMenu.setEnabled(false);
        }
    }

    boolean isAttachmentSelected() {
        return this.attachment != null;
    }

    void setEmbededMessage(AbstractItem theItem) {
        this.setCurrentItem(theItem);
        this.viewEmbededMessage(theItem);
        this.controller.updatePlainHTML();
        logger.debug((Object)"EMBEDDED MESSAGE");
    }

    private void viewEmbededMessage(AbstractItem theItem) {
        this.currentItem = theItem;
        this.setupItemMessage();
        this.updateEmbededParentView();
    }

    private void updateEmbededParentView() {
        AbstractItem parentItem = this.getParentItemFor(this.currentItem);
        if (parentItem != null) {
            this.embededParentView.setMVCModel(parentItem);
        }
        this.setEmbededParentViewVisible(parentItem != null);
    }

    public void setupHTMLView() {
        this.setupHTMLMessage();
    }

    private void build() {
        OrientablePanel messagePanel = new OrientablePanel(new BorderLayout());
        messagePanel.setBorder(BorderFactory.createEmptyBorder());
        messagePanel.add((Component)this.contentViewer, "Center");
        this.attachmentsPanel = new OrientablePanel(new BorderLayout());
        this.attachmentsPanel.setBorder(BorderFactory.createEmptyBorder());
        this.attachmentsPanel.add((Component)this.attachmentView, "Center");
        this.attachmentView.setParentComponent(this);
        this.splitPane = new GWSplitPane(0, messagePanel, this.attachmentsPanel);
        this.splitPane.setBorder(BorderFactory.createEmptyBorder());
        this.splitPane.setOneTouchExpandable(false);
        this.splitPane.setResizeWeight(1.0);
        this.splitPane.setDividerSize(4);
        this.splitPane.addPropertyChangeListener(new DividerPositionListener(this.splitterType, this.splitPane));
        OrientablePanel mainContent = new OrientablePanel(new BorderLayout());
        mainContent.setBorder(BorderFactory.createEmptyBorder());
        mainContent.add((Component)this.pnlInfo, "North");
        mainContent.add((Component)this.splitPane, "Center");
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.fill = 2;
        constraints.weightx = 1.0;
        this.pnlInfo.add((Component)this.itemPropertiesPanel, constraints);
        ++constraints.gridy;
        this.pnlInfo.add((Component)this.pnlHTMLMessageWarn, constraints);
        this.add((Component)mainContent, "Center");
    }

    private void refreshAttachment(GWAttachment theAttachment) {
        if (theAttachment.getNativeAttachment().getDownloadState() != AttachmentDownloadState.DOWNLOADED) {
            theAttachment.getNativeAttachment().checkDownloadStateAndStartRetrieve();
            return;
        }
        String ext = Utils.getExtention(theAttachment.getFileName());
        this.contentViewer.clear();
        try {
            if (ControlsUtils.isImage(ext)) {
                GWEngineUtils.saveAttachment(theAttachment);
                this.contentViewer.setupImage(ControlsUtils.getAttachmentFilePath(theAttachment).getAbsolutePath());
            } else if (ControlsUtils.isPDF(ext)) {
                this.contentViewer.setupMessage(StringResources.PDF_SHOULD_BE_VIEWED_WITH_AN_EXTERN);
            } else if (theAttachment.getSize() > MAX_PREVIEW_FILE_SIZE) {
                this.contentViewer.setupMessage(StringResources.THE_ATTACHMENT_IS_TOO_LARGE);
            } else if (ControlsUtils.isHTML(ext)) {
                GWEngineUtils.saveAttachment(theAttachment);
                this.contentViewer.setupHTMLPage(ControlsUtils.getAttachmentFilePath(theAttachment).getAbsolutePath());
            } else if (ControlsUtils.isText(ext)) {
                GWEngineUtils.saveAttachment(theAttachment);
                String filepath = ControlsUtils.getAttachmentFilePath(theAttachment).getAbsolutePath();
                byte[] bytes = ControlsUtils.getByteSequenceFromPage(filepath);
                try {
                    this.contentViewer.setupMessage(new String(bytes, this.charsetMenu.getSelectedCharset().name()));
                }
                catch (UnsupportedEncodingException e) {
                    this.contentViewer.setupMessage(new String(bytes));
                    logger.debug((Object)e, (Throwable)e);
                }
            } else if (ControlsUtils.isRTF(ext)) {
                GWEngineUtils.saveAttachment(theAttachment);
                this.contentViewer.setupRTF(ControlsUtils.getAttachmentFilePath(theAttachment).getAbsolutePath());
            } else {
                this.contentViewer.setupMessage(StringResources.THE_ATTACHMENT_CAN_ONLY_BE);
            }
        }
        catch (GWCommandException e) {
            logger.error((Object)e);
            logger.debug((Object)e, (Throwable)e);
        }
    }

    public void reloadMessage() {
        if (this.contentViewer.getViewMode() == 1) {
            this.setupHTMLMessage();
        } else if (this.contentViewer.getViewMode() == 2) {
            this.setupRtfMessage();
        }
    }

    public void zoom(boolean isZoomIn) {
        this.contentViewer.zoom(isZoomIn);
    }

    public void resetZoom() {
        if (GWClient.USE_EXTERNAL_HTML_VIEWER() && this.contentViewer.getViewMode() == 1) {
            this.contentViewer.resetZoom();
        } else {
            this.reloadMessage();
        }
    }

    private void setupItemMessage() {
        MachineSettings.TextOption textOption = OptionManager.getInstance().getTextOption();
        boolean defaultViewHTML = textOption.isDefaultReadHTML();
        boolean plainForced = textOption.isPlainTextReadForced();
        boolean htmlDisallowed = textOption.isHTMLDisallowed();
        if (this.currentItem.isHTMLMessage() && !htmlDisallowed && (defaultViewHTML || !this.currentItem.hasBodyText() && !plainForced)) {
            this.setupHTMLMessage();
        } else {
            assert (this.getMessageBody().isRtfMessage() || !this.currentItem.hasBodyText());
            this.setupRtfMessage();
        }
    }

    private MessageBody getMessageBody() {
        return this.currentItem != null ? this.currentItem.getMessage() : new MessageBody(null);
    }

    public void setupRtfMessage() {
        assert (this.currentItem.getMessage().isRtfMessage() || !this.currentItem.hasBodyText());
        String rtfText = this.getMessageBody().isRtfMessage() ? this.getMessageBody().getRtfText() : "{\\rtf1\\ansi}";
        this.pnlHTMLMessageWarn.setVisible(false);
        try {
            this.contentViewer.setupRTFMessage(rtfText);
        }
        catch (InvalidTextException e) {
            this.itemPropertiesPanel.setNotificationVisible(true);
            logger.debug((Object)e, (Throwable)e);
            return;
        }
        this.itemPropertiesPanel.setNotificationVisible(false);
    }

    private void setupHTMLMessage() {
        if (this.currentItem.isHTMLMessage()) {
            String path = this.currentItem.getHTMLBodyTextFile();
            boolean showWarning = this.currentItem.getNativeItem().containsExternalImages();
            logger.debug((Object)("contains external images: " + showWarning));
            logger.debug((Object)("user enabled images: " + this.currentItem.getNativeItem().getUserEnabledImages()));
            this.contentViewer.enableImages(!showWarning, false);
            this.contentViewer.setupHTMLPage(path);
            if (showWarning) {
                this.pnlHTMLMessageWarn.setVisible(true);
            }
        } else {
            this.pnlHTMLMessageWarn.setVisible(false);
        }
        this.itemPropertiesPanel.setNotificationVisible(false);
    }

    public AbstractItem getCurrentItem() {
        return this.currentItem;
    }

    void setEmbededParentViewVisible(boolean b) {
        if (b) {
            if (!this.embededParentViewAdded) {
                this.add((Component)this.embededParentView, "North");
            }
        } else if (this.embededParentViewAdded) {
            this.remove(this.embededParentView);
        }
        this.embededParentViewAdded = b;
        this.validate();
    }

    public void setShowAttachments(boolean showAttachments) {
        if (showAttachments) {
            if (this.attachmentsPanel.equals(this.splitPane.getBottomComponent())) {
                return;
            }
            this.splitPane.setBottomComponent(this.attachmentsPanel);
            this.splitPane.setDividerSize(4);
            int pos = ApplicationOptions.getInstance().getInteger(this.splitterType, -1);
            if (pos <= 0) {
                this.splitPane.resetToPreferredSizes();
            } else {
                this.splitPane.setDividerLocation(pos);
            }
        } else {
            this.splitPane.setBottomComponent(null);
            this.splitPane.setDividerSize(0);
        }
        this.invalidate();
        this.repaint();
    }

    public void setShowAttachments() {
        MVCController<MVCView> parentController = this.getController().getParentController();
        boolean show = parentController instanceof QuickViewerController && parentController.getParentController() instanceof FrameItemSearchActionList ? OptionManager.getInstance().getQuickViewerOptions().isShowAttachmentPanel() : (parentController instanceof FrameOpenActionList ? MessageUtils.showAttachmentWindow(true, this.getItem().getNativeItem()) : ApplicationOptions.getInstance().getBoolean("ATTACHLIST_VISIBLE", true));
        this.setShowAttachments(show);
    }

    private static boolean isHideSystemAttachments() {
        EnvironmentOptions environmentOptions = OptionManager.getInstance().getEnvironmentOptions();
        return environmentOptions.isHideSystemAttachments();
    }

    public void openParentMessage() {
        AbstractItem parentItem = this.getParentItemFor(this.currentItem);
        if (parentItem != null) {
            AbstractItem grandParentItem = this.getParentItemFor(parentItem);
            if (grandParentItem == null) {
                this.setEmbededParentViewVisible(false);
            } else {
                this.embededParentView.setMVCModel(grandParentItem);
                this.setEmbededParentViewVisible(true);
            }
            this.setCurrentItem(parentItem);
        }
    }

    public int getViewMode() {
        return this.contentViewer.getViewMode();
    }

    public void setHideSystemAttachments() {
        this.attachmentView.setHideSystemAttachments(ItemViewer.isHideSystemAttachments());
        this.itemPropertiesPanel.setHideSystemAttachments(ItemViewer.isHideSystemAttachments());
    }

    public FocusTraversalPolicy getFocusPolicy() {
        return this.focusPolicy;
    }

    public JComponent getComponentForFocus() {
        return this.contentViewer.getTextComponent();
    }

    private JPanel createHTMLWarnPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.insets.left = 5;
        constraints.anchor = 21;
        panel.add((Component)new OrientableLabel(ImageResources.WARNING_ICON), constraints);
        ++constraints.gridx;
        constraints.weightx = 1.0;
        panel.add((Component)new OrientableLabel(StringResources.GW_HAS_PREVENTED_IMAGES_ON_THIS_PAGE_FROM_DISPLAYING + " " + StringResources.CLICK_HERE_TO_DISPLAY_IMAGES), constraints);
        panel.setBackground(ColorConstants.YELLOW);
        panel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                ItemViewer.this.pnlHTMLMessageWarn.setVisible(false);
                ItemViewer.this.getCurrentItem().setUserEnabledImages(true);
                ItemViewer.this.contentViewer.enableImages(true, true);
                String path = ItemViewer.this.currentItem.getHTMLBodyTextFile();
                ItemViewer.this.contentViewer.setupHTMLPage(path);
            }

            public void mouseEntered(MouseEvent e) {
                ItemViewer.this.setCursor(Cursor.getPredefinedCursor(12));
            }

            public void mouseExited(MouseEvent e) {
                ItemViewer.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        panel.setVisible(false);
        return panel;
    }

    void processGWItemSelected(AbstractItem item) {
        assert (item != null) : "item is null";
        if (item.equals(this.item) && (item.isDraft() || item.isPersonal())) {
            this.setEmbededParentViewVisible(false);
        }
        this.setItem(item);
        this.loadContent();
    }

    public void save() {
        this.itemPropertiesPanel.save();
    }

    void processFolderSelected(AbstractFolder abstractFolder) {
        assert (abstractFolder != null) : "abstractFolder is null";
        if (!abstractFolder.equals(this.selectedFolder)) {
            this.setItem(null);
            this.setEmbededParentViewVisible(false);
            this.getController().turnOff();
            this.selectedFolder = abstractFolder;
            this.loadContent();
        }
    }

    public void release() {
        if (this.contentViewer != null) {
            this.contentViewer.release();
        }
    }

    public ContentViewer getContentViewer() {
        return this.contentViewer;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName());
        builder.append('[');
        builder.append("instanceId=");
        builder.append(this.instanceId);
        builder.append(']');
        return builder.toString();
    }

    private class CharsetMenu
    extends GWMenu
    implements ActionListener {
        private Charset selectedCharset;

        public CharsetMenu() {
            super(StringResources.ENCODING);
            this.selectedCharset = Charset.defaultCharset();
            this.init();
        }

        private void init() {
            ButtonGroup buttonGroup = new ButtonGroup();
            for (Charset charset : STANDARD_CROSSPLATFORM_CHARSETS) {
                JMenuItem menuItem = MenuItemFactory.createCkeckBoxMenuItem(charset.name());
                if (Charset.defaultCharset().equals(charset)) {
                    menuItem.setSelected(true);
                }
                menuItem.addActionListener(this);
                buttonGroup.add(menuItem);
                this.add(menuItem);
            }
        }

        public Charset getSelectedCharset() {
            return this.selectedCharset;
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof JMenuItem) {
                JMenuItem menuItem = (JMenuItem)e.getSource();
                this.selectedCharset = Charset.forName(menuItem.getName());
                ItemViewer.this.refreshAttachment(ItemViewer.this.attachment);
            }
        }
    }

    private class ViewerFocusPolicy
    extends LayoutFocusTraversalPolicy {
        private ViewerFocusPolicy() {
        }

        public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
            Component focusOwner = FocusManager.getCurrentManager().getPermanentFocusOwner();
            if (!aComponent.hasFocus()) {
                return focusOwner;
            }
            if (aComponent.equals(ItemViewer.this.attachmentView.getListContent())) {
                return this.getFirstComponent(SwingUtilities.getWindowAncestor(ItemViewer.this));
            }
            return super.getComponentAfter(focusCycleRoot, aComponent);
        }

        public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
            if (SwingUtilities.getWindowAncestor(ItemViewer.this) != null && aComponent.equals(this.getFirstComponent(SwingUtilities.getWindowAncestor(ItemViewer.this)))) {
                if (ItemViewer.this.attachmentView.isShowing()) {
                    return ItemViewer.this.attachmentView.getListContent();
                }
                return ItemViewer.this.contentViewer.getTextComponent();
            }
            return super.getComponentBefore(focusCycleRoot, aComponent);
        }

        public Component getDefaultComponent(Container focusCycleRoot) {
            JComponent component = ItemViewer.this.getComponentForFocus();
            if (component instanceof HTMLExternalTextViewer) {
                return ((HTMLExternalTextViewer)component).getBrowser();
            }
            return component;
        }
    }
}

