/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.menus;

import com.appframework.ActionList;
import com.appframework.AppAction;
import com.appframework.filter.FiltersFactory;
import com.novell.gw.jclient.application.GWMainAppFrame;
import com.novell.gw.jclient.application.GWMainAppFrameActionList;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.filter.ActionContextItemFilter;
import com.novell.gw.jclient.application.actions.item.ActionItemNotEligible;
import com.novell.gw.jclient.application.controls.gwcomponent.GWPopupMenu;
import com.novell.gw.jclient.application.controls.menus.GWMenu;
import com.novell.gw.jclient.application.controls.panelviews.PanelView;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;

public abstract class AbstractActionsPopupMenu
extends GWPopupMenu {
    protected ActionList actionList;
    protected boolean lastItemAddedIsSeparator = false;
    protected AbstractFolder folder;
    protected AbstractItem item;
    protected String columnName = null;
    protected boolean isInPanel = false;
    protected String panelName;

    public AbstractActionsPopupMenu() {
    }

    public AbstractActionsPopupMenu(ActionList theActionList) {
        this.actionList = theActionList;
    }

    public AbstractActionsPopupMenu(ActionList theActionList, AbstractFolder folder) {
        this(theActionList);
        this.folder = folder;
    }

    public AbstractActionsPopupMenu(ActionList theActionList, AbstractFolder folder, AbstractItem item, String columnName) {
        this(theActionList, folder);
        this.item = item;
        this.columnName = columnName;
    }

    public JMenuItem add(JMenuItem menuItem) {
        if (menuItem.isEnabled()) {
            this.lastItemAddedIsSeparator = false;
            return super.add(menuItem);
        }
        return null;
    }

    public JMenuItem add(Action action) {
        if (action.isEnabled()) {
            return super.add(action);
        }
        return null;
    }

    public static MouseListener createMenuMouseListener(JPopupMenu theMenu) {
        return new MenuMouseListener(theMenu);
    }

    public void addSeparator() {
        if (!this.lastItemAddedIsSeparator) {
            super.addSeparator();
            this.lastItemAddedIsSeparator = true;
        }
    }

    public ActionList getActionList() {
        return this.actionList;
    }

    public void insert(Component component, int index) {
        if (component.isEnabled()) {
            super.insert(component, index);
            this.lastItemAddedIsSeparator = false;
        }
    }

    protected ActionContextItemFilter getFindAction() {
        ActionContextItemFilter actionContextItemFilter = (ActionContextItemFilter)this.actionList.getAction(ActionKey.CONTEXT_ITEM_FILTER);
        actionContextItemFilter.setModel(this.item, this.columnName, this.isInPanel ? this.panelName : this.folder.getName(), this.isInPanel);
        return actionContextItemFilter;
    }

    protected void buildFindMenuItem() {
        if (this.actionList.getAction(ActionKey.CONTEXT_ITEM_FILTER) != null) {
            this.add(this.getFindAction().getMenuItem());
            if (FiltersFactory.getInstance().getFilter(this.actionList) != null) {
                this.add(this.actionList.getAction(ActionKey.CLEAR_FILTER).getMenuItem());
            }
        }
    }

    protected void buildJunkMailMenu() {
        int stringId;
        GWMenu menuJunkMail = new GWMenu(StringResources.JUNK_MAIL);
        boolean isEligible = false;
        if (this.item.getNativeItem().canHandleJunkMailItem(1)) {
            menuJunkMail.add(this.actionList.getAction(ActionKey.TRUST_SENDER).getMenuItem());
            isEligible = true;
        }
        if (this.item.getNativeItem().canHandleJunkMailItem(3)) {
            menuJunkMail.add(this.actionList.getAction(ActionKey.JUNK_SENDER).getMenuItem());
            isEligible = true;
        }
        if (this.item.getNativeItem().canHandleJunkMailItem(2)) {
            menuJunkMail.add(this.actionList.getAction(ActionKey.BLOCK_SENDER).getMenuItem());
            isEligible = true;
        }
        if ((stringId = this.item.getNativeItem().canHandleJunkMailItem()) != 0) {
            if (isEligible) {
                menuJunkMail.addSeparator();
            }
            ActionItemNotEligible action = (ActionItemNotEligible)this.actionList.getAction(ActionKey.ITEM_NOT_ELIGIBLE);
            action.setMultipleItems(false);
            JMenuItem menuItem1 = menuJunkMail.add(action.getMenuItem());
            menuItem1.setText(EngineCommandManager.getResourceString(stringId));
        }
        menuJunkMail.addSeparator();
        menuJunkMail.add(this.actionList.getAction(ActionKey.JUNK_MAIL_HANDLING).getMenuItem());
        this.add(menuJunkMail);
    }

    protected void checkMenuOpenedInPanel(ActionList actionList) {
        PanelView selectedPanel;
        GWMainAppFrame frame;
        this.isInPanel = false;
        if (actionList instanceof GWMainAppFrameActionList && (frame = (GWMainAppFrame)((GWMainAppFrameActionList)actionList).getMVCView()).isMultiPanelView() && (selectedPanel = frame.getMultiPanelView().getSelectedPanel()) != null) {
            this.panelName = selectedPanel.getPanelName();
            this.isInPanel = true;
        }
    }

    protected int findMenuItem(ActionKey name) {
        MenuElement[] elements = this.getSubElements();
        int nCount = elements.length;
        for (int i = 0; i < nCount; ++i) {
            JMenuItem item;
            AppAction appAction;
            Component component = this.getComponent(i);
            if (!(component instanceof JMenuItem) || (appAction = (AppAction)(item = (JMenuItem)component).getAction()) == null) continue;
            ActionKey menuItemName = appAction.getActionKey();
            return i;
        }
        return -1;
    }

    protected void addAction(ActionKey actionName) {
        AppAction action = this.actionList.getAction(actionName);
        if (action != null && action.isEnabled()) {
            this.add(action.getPopupMenuItem());
        }
    }

    private static class MenuMouseListener
    extends MouseAdapter {
        JPopupMenu popupMenu;

        public MenuMouseListener(JPopupMenu thePopupMenu) {
            this.popupMenu = thePopupMenu;
        }

        public void mousePressed(MouseEvent e) {
            this.doPopup(e);
        }

        public void mouseClicked(MouseEvent e) {
            this.doPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.doPopup(e);
        }

        private void doPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.popupMenu.show((Component)e.getSource(), e.getX(), e.getY());
            }
        }
    }
}

