/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.menus;

import com.appframework.ActionList;
import com.appframework.filter.FiltersFactory;
import com.appframework.mvc.MVCController;
import com.novell.gw.engine.ItemListFilter;
import com.novell.gw.jclient.api.impl.APIWrapperManager;
import com.novell.gw.jclient.api.interfaces.IDataStore;
import com.novell.gw.jclient.application.GWMainAppFrame;
import com.novell.gw.jclient.application.GWMainAppFrameActionList;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.controls.filter.AbstractFilter;
import com.novell.gw.jclient.application.controls.filter.AdvancedFilter;
import com.novell.gw.jclient.application.controls.filter.CustomFilter;
import com.novell.gw.jclient.application.controls.menus.AbstractActionsPopupMenu;
import com.novell.gw.jclient.application.controls.menus.FilterSelectAction;
import com.novell.gw.jclient.application.controls.menus.GWMenu;
import com.novell.gw.jclient.application.frames.calendar.FrameCalendarActionList;
import com.novell.gw.jclient.application.frames.search.FrameItemSearchActionList;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.categories.CategoryUtils;
import com.novell.gw.jclient.bl.om.filter.Filter;
import java.awt.Component;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class FilterGWItemsPopupMenu
extends AbstractActionsPopupMenu {
    private static Logger logger = Logger.getLogger(FilterGWItemsPopupMenu.class);

    public FilterGWItemsPopupMenu(ActionList theActionList) {
        super(theActionList);
        this.build();
    }

    private void build() {
        boolean isUserFilteringBoxType;
        JMenuItem mi = this.actionList.getAction(ActionKey.CREATE_GWITEM_FILTER).getMenuItem();
        String title = StringResources.FIND;
        if (this.actionList instanceof GWMainAppFrameActionList && ((GWMainAppFrameActionList)this.actionList).getMVCView() != null && ((GWMainAppFrame)((GWMainAppFrameActionList)this.actionList).getMVCView()).getFolder() != null) {
            this.checkMenuOpenedInPanel(this.actionList);
            if (this.isInPanel) {
                title = StringResources.formatString(StringResources.IN_SOME_PANEL_D, this.panelName);
            } else {
                String name = ((GWMainAppFrame)((GWMainAppFrameActionList)this.actionList).getMVCView()).getFolder().getName();
                title = StringResources.formatString(StringResources.IN_SOME_FOLDER_D, name);
            }
        } else if (this.actionList instanceof FrameItemSearchActionList) {
            title = StringResources.formatString(StringResources.IN_SOME_FOLDER_D, StringResources.FIND_RESULTS);
        } else if (this.actionList instanceof FrameCalendarActionList) {
            title = StringResources.formatString(StringResources.IN_SOME_FOLDER_D, StringResources.CALENDAR);
        }
        mi.setText(title);
        this.add(mi);
        if (FiltersFactory.getInstance().getFilter(this.actionList) != null) {
            this.add(this.actionList.getAction(ActionKey.CLEAR_FILTER).getMenuItem());
        }
        this.addSeparator();
        this.add(this.createCategoryMenuItem());
        this.addSeparator();
        Filter filter = FiltersFactory.getInstance().getFilter(this.actionList);
        boolean bl = isUserFilteringBoxType = filter != null && filter.getItemListFilter().isUserFilteringBoxType();
        if (!isUserFilteringBoxType) {
            this.add(this.actionList.getAction(ActionKey.RECEIVED_ITEMS_FILTER).getMenuItem());
            this.add(this.actionList.getAction(ActionKey.SENT_ITEMS_FILTER).getMenuItem());
            this.add(this.actionList.getAction(ActionKey.POSTED_ITEMS_FILTER).getMenuItem());
            this.add(this.actionList.getAction(ActionKey.DRAFT_ITEMS_FILTER).getMenuItem());
            this.addSeparator();
        }
        this.add(this.actionList.getAction(ActionKey.FILTER_ITEMS_WITH_ATTACHMENTS).getMenuItem());
        this.addSeparator();
        String userGuid = EngineCommandManager.getUserGuid();
        IDataStore ds = EngineCommandManager.getInstance(userGuid).getCurrentDataStore();
        int count = ds.getSavedFilterCount(0);
        boolean isMore = false;
        for (int i = 0; i < count; ++i) {
            ItemListFilter itemfilter = ds.getSavedFilter(0, i);
            if (itemfilter.getShowOnMenu()) {
                AbstractFilter f = itemfilter.canShowAsSimple(ds.getNativeDataStore()) ? new CustomFilter(itemfilter.getFromText(), itemfilter.getToCcText(), itemfilter.getSubjectText(), itemfilter.getMessage(), APIWrapperManager.getCategoryList(itemfilter.getCategories(ds.getNativeDataStore()))) : new AdvancedFilter(itemfilter);
                this.add(new FilterSelectAction((MVCController)this.actionList.getMVCView().getController(), f, itemfilter.getName()).getMenuItem());
                continue;
            }
            isMore = true;
        }
        if (isMore) {
            this.add(this.actionList.getAction(ActionKey.MORE_FILTER).getMenuItem());
        }
    }

    public void show(Component invoker, int x, int y) {
        this.removeAll();
        this.build();
        super.show(invoker, x, y);
    }

    public JMenu createCategoryMenuItem() {
        GWMenu menuCategories = new GWMenu(StringResources.CATEGORIES);
        menuCategories.add(this.actionList.getAction(ActionKey.ALL_CATEGORIES).getMenuItem());
        menuCategories.addSeparator();
        Filter filter = FiltersFactory.getInstance().getFilter(this.actionList);
        CategoryUtils.populateMenuWithCategories(menuCategories, filter, this.actionList);
        menuCategories.addSeparator();
        menuCategories.add(this.actionList.getAction(ActionKey.MORE_CATEGORIES_FILTER).getMenuItem());
        return menuCategories;
    }
}

