/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.panelviews;

import com.novell.gw.jclient.api.interfaces.IFolderDisplaySettings;
import com.novell.gw.jclient.api.interfaces.IPanelDisplaySettings;
import com.novell.gw.jclient.application.dialogs.folderproperties.DisplaySettingsSaver;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PanelsManager {
    private static final Logger logger = Logger.getLogger(PanelsManager.class);
    protected final IFolderDisplaySettings folderDisplaySettings;

    PanelsManager(IFolderDisplaySettings folderDisplaySettings) {
        this.folderDisplaySettings = folderDisplaySettings;
        this.checkDisplaySettings();
    }

    public static PanelsManager getInstance(IFolderDisplaySettings folderDisplaySettings) {
        if (folderDisplaySettings instanceof DisplaySettingsSaver) {
            return new PanelsManager(folderDisplaySettings){

                public void setPanels(IPanelDisplaySettings[][] panels) {
                    int columnNum = 0;
                    for (IPanelDisplaySettings[] panelsForColumn : panels) {
                        int columnIndex = 0;
                        for (IPanelDisplaySettings panel : panelsForColumn) {
                            panel.setPanelColumnNum(columnNum);
                            panel.setPanelIndex(columnIndex);
                            ++columnIndex;
                        }
                        ++columnNum;
                    }
                    ((DisplaySettingsSaver)this.folderDisplaySettings).setPanelDisplaySettingsMatrix(panels);
                }
            };
        }
        return new PanelsManager(folderDisplaySettings);
    }

    public List<IPanelDisplaySettings> getPanelsForColumn(int column) {
        ArrayList<IPanelDisplaySettings> panelsForColumn = new ArrayList<IPanelDisplaySettings>();
        int count = this.folderDisplaySettings.getPanelCount();
        for (int i = 0; i < count; ++i) {
            IPanelDisplaySettings curPanelSettings = this.folderDisplaySettings.getPanelSettings(i);
            int currentPanelColumn = curPanelSettings.getPanelColumnNum();
            if (currentPanelColumn != column) continue;
            panelsForColumn.add(curPanelSettings);
        }
        if (panelsForColumn.size() == 0) {
            logger.warn((Object)("No panels found for column " + column));
        }
        return panelsForColumn;
    }

    public void setPanels(IPanelDisplaySettings[][] panels) {
        this.folderDisplaySettings.deleteAllPanelSettings();
        int columnNum = 0;
        for (IPanelDisplaySettings[] panelsForColumn : panels) {
            int columnIndex = 0;
            for (IPanelDisplaySettings panel : panelsForColumn) {
                panel.setPanelColumnNum(columnNum);
                panel.setPanelIndex(columnIndex);
                panel.createPanelDisplaySettingsRec(this.folderDisplaySettings);
                ++columnIndex;
            }
            ++columnNum;
        }
        this.folderDisplaySettings.setPanelColumnCount(columnNum);
        this.folderDisplaySettings.resetPanelSettings();
    }

    public IPanelDisplaySettings[][] getPanels() {
        int columnCount = this.folderDisplaySettings.getPanelColumnCount();
        IPanelDisplaySettings[][] panels = new IPanelDisplaySettings[columnCount][];
        for (int column = 0; column < columnCount; ++column) {
            List<IPanelDisplaySettings> panelsForColumnAsList = this.getPanelsForColumn(column);
            IPanelDisplaySettings[] panelsForColumn = panelsForColumnAsList.toArray(new IPanelDisplaySettings[panelsForColumnAsList.size()]);
            panels[column] = panelsForColumn;
            for (int index = 0; index < panelsForColumn.length; ++index) {
                IPanelDisplaySettings settings = panelsForColumn[index];
                settings.setPanelIndex(index);
                settings.setPanelColumnNum(column);
            }
        }
        return panels;
    }

    public IPanelDisplaySettings[] getAllPanels() {
        int count = this.folderDisplaySettings.getPanelCount();
        IPanelDisplaySettings[] allPanels = new IPanelDisplaySettings[count];
        for (int i = 0; i < count; ++i) {
            allPanels[i] = this.folderDisplaySettings.getPanelSettings(i);
        }
        return allPanels;
    }

    public int getPanelsCountForColumn(int column) {
        int panelsForColumn = 0;
        int count = this.folderDisplaySettings.getPanelCount();
        for (int i = 0; i < count; ++i) {
            IPanelDisplaySettings curPanelSettings = this.folderDisplaySettings.getPanelSettings(i);
            if (curPanelSettings.getPanelColumnNum() != column) continue;
            ++panelsForColumn;
        }
        return panelsForColumn;
    }

    public boolean replacePanel(IPanelDisplaySettings newSettings, IPanelDisplaySettings oldSettings) {
        int index = oldSettings.getPanelIndex();
        int column = oldSettings.getPanelColumnNum();
        IPanelDisplaySettings[][] panels = this.getPanels();
        if (0 <= column && column < panels.length && 0 <= index && index < panels[column].length && panels[column][index].equals(oldSettings)) {
            panels[column][index] = newSettings;
            this.setPanels(panels);
            return true;
        }
        for (int i = 0; i < panels.length; ++i) {
            for (int j = 0; j < panels[i].length; ++j) {
                if (!panels[i][j].equals(oldSettings)) continue;
                panels[i][j] = newSettings;
                this.setPanels(panels);
                return true;
            }
        }
        return false;
    }

    public boolean move(IPanelDisplaySettings targetPanel, int oldColumnNum, int oldColumnIndex) {
        int i;
        logger.debug((Object)("panel: " + targetPanel + ", oldColumnNum: " + oldColumnNum + ", oldColumnIndex: " + oldColumnIndex));
        int newColumnNum = targetPanel.getPanelColumnNum();
        int newColumnIndex = targetPanel.getPanelIndex();
        logger.debug((Object)("newColumnNum: " + newColumnNum + ", newColumnIndex: " + newColumnIndex));
        IPanelDisplaySettings movedPanel = null;
        int nCount = this.folderDisplaySettings.getPanelCount();
        for (i = 0; i < nCount && ((movedPanel = this.folderDisplaySettings.getPanelSettings(i)).getPanelColumnNum() != oldColumnNum || movedPanel.getPanelIndex() != oldColumnIndex); ++i) {
        }
        if (movedPanel == null) {
            return false;
        }
        if (newColumnNum == oldColumnNum && newColumnIndex == oldColumnIndex) {
            return false;
        }
        if (newColumnNum != oldColumnNum) {
            if (this.getPanelsCountForColumn(newColumnNum) == 1 && this.getPanelsCountForColumn(oldColumnNum) == 1) {
                logger.debug((Object)"swapping panels");
                targetPanel.setPanelColumnNum(oldColumnNum);
                movedPanel.setPanelColumnNum(newColumnNum);
                this.folderDisplaySettings.resetPanelSettings();
                return true;
            }
            this.folderDisplaySettings.reorderPanels(newColumnNum, newColumnIndex + 1);
        } else if (newColumnIndex < oldColumnIndex) {
            this.folderDisplaySettings.reorderPanels(newColumnNum, newColumnIndex);
        } else {
            nCount = this.folderDisplaySettings.getPanelCount();
            for (i = 0; i < nCount; ++i) {
                IPanelDisplaySettings curPanel = this.folderDisplaySettings.getPanelSettings(i);
                if (curPanel.getPanelColumnNum() != newColumnNum || curPanel.getPanelIndex() > newColumnIndex || curPanel.getPanelIndex() <= oldColumnIndex) continue;
                curPanel.setPanelIndex(curPanel.getPanelIndex() - 1);
            }
        }
        movedPanel.setPanelColumnNum(newColumnNum);
        movedPanel.setPanelIndex(newColumnIndex + (newColumnNum != oldColumnNum ? 1 : 0));
        this.checkDisplaySettings();
        this.folderDisplaySettings.resetPanelSettings();
        return true;
    }

    public void checkDisplaySettings() {
        int currentColumn = 0;
        int columnCount = 0;
        for (int i = 0; i < this.folderDisplaySettings.getPanelCount(); ++i) {
            int panelColumnNum = this.folderDisplaySettings.getPanelSettings(i).getPanelColumnNum();
            if (columnCount > panelColumnNum) continue;
            columnCount = panelColumnNum + 1;
        }
        while (currentColumn < columnCount) {
            logger.debug((Object)("processing column #" + currentColumn));
            logger.warn((Object)("column #" + currentColumn + " has no panels > correcting..."));
            if (this.getPanelsCountForColumn(currentColumn) == 0) {
                --columnCount;
                int nCount = this.folderDisplaySettings.getPanelCount();
                for (int i = currentColumn; i < nCount; ++i) {
                    IPanelDisplaySettings curPanel = this.folderDisplaySettings.getPanelSettings(i);
                    if (curPanel.getPanelColumnNum() <= currentColumn) continue;
                    curPanel.setPanelColumnNum(curPanel.getPanelColumnNum() - 1);
                }
            }
            logger.debug((Object)("column #" + currentColumn + " processed"));
            ++currentColumn;
        }
        this.folderDisplaySettings.setPanelColumnCount(columnCount);
    }

    public void remove(int column, int columnPosition) {
        int nCount = this.folderDisplaySettings.getPanelCount();
        for (int i = 0; i < nCount; ++i) {
            IPanelDisplaySettings curPanel = this.folderDisplaySettings.getPanelSettings(i);
            if (curPanel.getPanelColumnNum() != column || curPanel.getPanelIndex() != columnPosition) continue;
            this.folderDisplaySettings.deletePanelSettings(curPanel);
            break;
        }
        this.checkDisplaySettings();
    }

    public void insert(IPanelDisplaySettings panel, int columnNum, int columnIndex) {
        this.folderDisplaySettings.reorderPanels(columnNum, columnIndex + 1);
        panel.setPanelColumnNum(columnNum);
        panel.setPanelIndex(columnIndex + 1);
        panel.createPanelDisplaySettingsRec(this.folderDisplaySettings);
        this.folderDisplaySettings.resetPanelSettings();
    }
}

